//
//   File : kvi_taskbar.h (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_taskbar.h)
//   Last major modification : Thu Jan 7 1999 03:56:50 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#ifndef _KVI_TASKBAR_H_INCLUDED_
#define _KVI_TASKBAR_H_INCLUDED_

#include <qtoolbar.h>
#include <qlist.h>
#include <qpixmap.h>
//#include <qpopupmenu.h>

class KviFrame;
class KviWindow;
class KviTaskBar;

class KviTaskBarButton : public QWidget
{
	friend class KviTaskBar;
	friend class KviFrame;
	friend class KviWindow;
	friend class KviHelpWindow;
	Q_OBJECT
public:
	KviTaskBarButton(QWidget *parent,KviTaskBar *pTaskBar,KviWindow *win_ptr,QPixmap *mem_buf);
	~KviTaskBarButton();
private:
	KviWindow *m_pWindow;
	KviTaskBar *m_pTaskBar;
	QPixmap   *m_pMemBuffer;
	bool       m_bIsOn;
	bool       m_bAttached;
	bool       m_bHighlighted;
	bool       m_bAltColor;
	int        m_iProgress;
protected:
	/**
	* Highlights this button if it is NOT PRESSED.<br>
	* (inline)
	*/
	void highlight(bool bAltColor = false);
	/**
	* Sets the progress for this button.<br>
	* progress == 0 removes the progress bar.<br>
	* (inline)
	*/
	void setProgress(int progress);
	/**
	* Repaints the button , updating the string data and the toolTip.<br>
	*/
	void updateButton();
	void setOn(bool bOn);
	void setAttachState(bool bAttached);
	virtual void paintEvent(QPaintEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
public:
	bool isOn(){ return m_bIsOn; };
};

inline void KviTaskBarButton::setProgress(int progress)
{
	if(progress != m_iProgress){
		m_iProgress = progress;
		if(m_iProgress > 100)m_iProgress = 100;
		paintEvent(0);
	}
}

class KviTransparentWidget;

class KviTaskBar : public QToolBar
{
	friend class KviTaskBarButton;
	Q_OBJECT
public:		// Construction & Destruction
	KviTaskBar(KviFrame *parent,QMainWindow::ToolBarDock dock);
	~KviTaskBar();
private:
	KviTransparentWidget    * m_pBase;
	QList<KviTaskBarButton> * m_pButtonList;
	int                       m_iButtonHeight;
	QPixmap                 * m_pMemBuffer;
//	QPopupMenu              * m_pMovePopup;
	KviFrame                * m_pFrm;

public:		// Methods
	KviTaskBarButton * addWinButton(KviWindow *win_ptr);
	void removeWinButton(KviWindow *win_ptr);
	virtual void fontChange(const QFont &oldFont);
	KviTaskBarButton * getButton(KviWindow *win_ptr);
	void setActiveButton(KviWindow *win_ptr);
	void windowAttached(KviWindow *win_ptr,bool bAttached);
	KviTaskBarButton * getNextWindowButton(bool bRight,KviWindow *win_ptr);
//public slots:
//	void dockTop();
//	void dockBottom();
//	void dockLeft();
//	void dockRight();
protected slots:
	void setupMinimumSizes(Orientation o);
protected:	// Protected methods
	void buttonLeftClicked(KviWindow *win_ptr,KviTaskBarButton *btn);
	void buttonRightClicked(KviWindow *win_ptr,KviTaskBarButton *btn);
	void layoutButtons();
	void recalcButtonHeight();
	virtual void resizeEvent(QResizeEvent *e);
//	virtual void mousePressEvent(QMouseEvent *e);
	virtual QSizePolicy sizePolicy();
};

#endif //_KVI_TASKBAR_H_INCLUDED_
