//
//   File : kvi_ircview.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_ircview.cpp)
//   Last major modification : Tue Jul 6 1999 14:45:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

// Damn complex class ...but it works :)
// #include <brain.h>
//
// #define HOPE_THAT_IT_WILL_NEWER_NEED_TO_BE_MODIFIED :)

// 07 May 1999 , Already forgot how this damn thing works , and spent 1 hour over a stupid bug.
//		I had to recreate the whole thing in my mind......ooooouh...How did I wrote it ?
//      Just take a look to paintEvent() or to calculateLineWraps()...
//      Anyway...I've solved the bug.

// 23 Nov 1999 , Well , not so bad...I seem to still remember how it works
//      So just for fun , complicated the things a little bit more.
//      Added precaclucaltion of the text blocks and word wrapping
//      and a fast scrolling mode (3 lines at once) for consecutive
//      appendText() calls.
//      Now the code becomes really not understandable...:)

#define _KVI_IRCVIEW_CPP_

#define _KVI_DEBUG_CLASS_NAME_ "KviIrcView"
#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_debug.h"

#include "kvi_app.h"
#include "kvi_defines.h"
#include "kvi_options.h"

#include "kvi_ircview.h"

#include "kvi_window.h"
#include "kvi_dcc_chat.h"
#include "kvi_locale.h"
#include "kvi_frame.h"
#include "kvi_listbox.h"

#include "kvi_malloc.h"
#include "kvi_memmove.h"

#include "kvi_event.h"
#include "kvi_console.h"

#include "kvi_uparser.h"

#include "kvi_statusbar.h"

#include <X11/Xlib.h>
//#include <X11/X.h> // GCFunctions
#ifdef COMPILE_USE_AA_FONTS
	#include <X11/Xft/Xft.h>
#endif

#include <qbitmap.h>

#if QT_VERSION >= 300
	#ifndef QT_CLEAN_NAMESPACE
		#define QT_CLEAN_NAMESPACE
		#include <qcursor.h>
		#undef QT_CLEAN_NAMESPACE
	#else
		#include <qcursor.h>
	#endif
#else
	#include <qcursor.h>
#endif

#include <qclipboard.h>
#include <qdatetime.h>
#include <qdragobject.h>
#include <qmessagebox.h>


//Declared in kvi_app.cpp and managed by KviApp class
extern QPixmap           * g_pixViewOut[KVI_OUT_NUM_IMAGES];
extern Display           * g_display;
extern GC                  g_ircviewGC;
extern QPixmap           * g_pIrcViewMemBuffer;
extern HANDLE              g_hIrcViewMemBuffer;
extern QList<KviIrcView> * g_pIrcViewWidgetList;
extern KviEventManager   * g_pEventManager;

// lol... er, n/m --> [02:59:17] Server services.webchat.org: ConferenceRoom/1.8.5c-WEBCHAT.Linux-ELF-static services.webchat.org :200-0001-152
#ifdef COMPILE_USE_AA_FONTS
//	static XftFont       * g_pIrcViewXftFont;
//	static XftDraw       * g_pIrcViewXftDraw;
	extern XftFont        * g_pXftFont;
	extern XftDraw        * g_pXftDraw;
	// prototypes fo Qt internal functions
	extern int       qt_use_xft (void);                                                     // qpainter_x11.cpp
	extern void    * qt_ft_font (const QFont *f);                                           // qfont_x11.cpp
	extern XftDraw * qt_lookup_ft_draw (Drawable draw, bool paintEventClipOn, QRegion *crgn);  // qpixmap_x11.cpp
#endif

#define KVI_IRCVIEW_BLOCK_SELECTION_TOTAL 0
#define KVI_IRCVIEW_BLOCK_SELECTION_LEFT 1
#define KVI_IRCVIEW_BLOCK_SELECTION_RIGHT 2
#define KVI_IRCVIEW_BLOCK_SELECTION_CENTRAL 3


/* FIXME: "PgUp and PgDn scrolls a fixed number of lines! Make it view height dependant" */

//================ getColorBytes ===============//

const char * getColorBytes(const char *data_ptr,char *byte_1,char *byte_2)
{
	//Scans the data_ptr for a mIrc color code XX,XX
	//and fills the color values in the two bytes

	//First we can have a digit or a coma
	if(((*data_ptr >= '0') && (*data_ptr <='9'))){
		//Something interesting ok.
		(*byte_1)=(*data_ptr)-'0'; //store the code
		data_ptr++;     //and check the next
		if(((*data_ptr >= '0') && (*data_ptr <= '9'))||(*data_ptr==',')){
			//Yes we can understand it
			if(*data_ptr==','){
				//A comma, need to check for background
				data_ptr++;
			} else {
				//A number
				// Maybe move the modulus operation to shifts ?
				(*byte_1)=((((*byte_1)*10)+((*data_ptr)-'0'))%16);
				data_ptr++;
				if(*data_ptr==','){
					//A comma, need to check for background
					data_ptr++;
				} else {
					//Senseless return
					(*byte_2)=KVI_NOCHANGE;
					return data_ptr;
				}
			}
		} else {
			//Senseless character control code OK and return
			(*byte_2)=KVI_NOCHANGE;
			return data_ptr;
		}
	} else {
		//Senseless character : only a CTRL+K code
		(*byte_1)=KVI_NOCHANGE;
		(*byte_2)=KVI_NOCHANGE;
		return data_ptr;
	}

	if((*data_ptr >= '0') && (*data_ptr <='9')){
		//Background , a color code
		(*byte_2)=(*data_ptr)-'0';
		data_ptr++;
		if((*data_ptr >= '0') && (*data_ptr <='9')){
			(*byte_2)=((((*byte_2)*10)+((*data_ptr)-'0'))%16);
			data_ptr++;
		}
		return data_ptr;
	} else {
		(*byte_2)=KVI_NOCHANGE;
		return data_ptr;
	}
}

//============ KviIrcView ============//

KviIrcView::KviIrcView(QWidget *parent,KviFrame *pFrm,KviWindow *pWnd)
:QWidget(parent,"irc_view")
{
	g_pIrcViewWidgetList->append(this); // register
	setBackgroundMode(NoBackground);
	resizeMemBuffer();

	m_pFirstLine               = 0;
	m_pCurLine                 = 0;
	m_pLastLine                = 0;
	m_iNumLines                = 0;
	m_iMaxLines                = g_pOptions->m_iViewMaxBufferSize;
	m_bAcceptDrops             = false;
	m_pPrivateBackgroundPixmap = 0;
	m_pScrollBar               = new KviIrcViewScrollBar(0,0,1,10,0,QScrollBar::Vertical,this,"irc_view_scrollbar");

	m_pScrollBar->setTracking(true);
	m_pScrollBar->show();
	m_pScrollBar->setFocusProxy(this);

	connect(m_pScrollBar,SIGNAL(valueChanged(int)),this,SLOT(scrollBarPositionChanged(int)));

	m_iLastScrollBarValue      = 0;
	m_bSelecting               = false;
	m_bDoubleClicked           = false;
	m_bShowImages              = g_pOptions->m_bShowImages;
	m_iSelectTimer             = 0;
	m_bTimestamp               = g_pOptions->m_bTimestamp;

	setFont(g_pOptions->m_fntView);
	// The following may be useful
	// (fontChange is not triggered when g_pOptions->m_fntView == font())
	recalcFontVariables(g_pOptions->m_fntView);

	m_bSkipScrollBarRepaint    = false;
	m_pLogFile                 = 0;
	m_pKviWindow               = pWnd;
	m_pFrm                     = pFrm;
	m_iUnprocessedPaintEventRequests = 0;
	m_bPostedPaintEventPending = false;
	// links highlighting
	m_pLastLinkUnderMouse      = 0;
	m_iLastLinkRectTop         = -1;
	m_iLastLinkRectHeight      = -1;

	m_pMessagesStoppedWhileSelecting = new QList<KviIrcViewTextLine>;
	m_pMessagesStoppedWhileSelecting->setAutoDelete(false);
	setMinimumWidth(KVI_IRCVIEW_MINIMUM_WIDTH);

	if (m_pKviWindow->type() == KVI_WND_TYPE_QUERY)m_bBeeping = initBeeping(m_pKviWindow->caption());
	else m_bBeeping=false;

	setMouseTracking(true);
}

//============ ~KviIrcView ============//

KviIrcView::~KviIrcView()
{
	g_pIrcViewWidgetList->removeRef(this); // unregister

	if(m_iSelectTimer)killTimer(m_iSelectTimer);
	stopLogging();
	resizeMemBuffer(); //<--- we are no longer on the widget list
	if(m_pPrivateBackgroundPixmap)delete m_pPrivateBackgroundPixmap;
	emptyBuffer(false);
	while(KviIrcViewTextLine * l = m_pMessagesStoppedWhileSelecting->first())
	{
		m_pMessagesStoppedWhileSelecting->removeFirst();
		kvi_free(l->data_ptr);                              // free string data
		if(l->attr_ptr->attribute == KVI_TEXT_ESCAPE)
		{
			kvi_free(l->attr_ptr->escape_cmd);
		}
		kvi_free(l->attr_ptr);                              // free attributes data
		if(l->num_text_blocks)kvi_free(l->text_blocks_ptr);
		delete l;
	}
	delete m_pMessagesStoppedWhileSelecting;
}

void KviIrcView::wheelEvent(QWheelEvent *e)
{
	m_pScrollBar->wheelEvent(e);
}

void KviIrcView::enableDnd(bool bEnable)
{
	setAcceptDrops(bEnable);
	m_bAcceptDrops = bEnable;
}

void KviIrcView::dragEnterEvent(QDragEnterEvent *e)
{
	if(!m_bAcceptDrops)return;
	e->accept(QUriDrag::canDecode(e));
	emit dndEntered();
}

void KviIrcView::dropEvent(QDropEvent *e)
{
	if(!m_bAcceptDrops)return;
	QStringList list;
	if(QUriDrag::decodeLocalFiles(e,list)){
		if(!list.isEmpty()){
			QStringList::ConstIterator it = list.begin(); //kewl ! :)
			for( ; it != list.end(); ++it ){
				KviStr tmp = *it; //wow :)
				if(*(tmp.ptr()) != '/')tmp.prepend("/"); //HACK HACK HACK for Qt bug (?!?)
				emit fileDropped(tmp.ptr());
			}
		}
	}
}

//============= BEEPING ===============//

void KviIrcView::toggleBeeping()
{
        if(isBeeping()) {
		if (m_pKviWindow->type() == KVI_WND_TYPE_QUERY)stopBeeping(m_pKviWindow->caption());
		else if (m_pKviWindow->type() == KVI_WND_TYPE_CHAT)stopBeeping(((KviDccChat *)m_pKviWindow)->m_szRemoteNick.ptr());
	} else {
		if (m_pKviWindow->type() == KVI_WND_TYPE_QUERY)startBeeping(m_pKviWindow->caption());
		else if (m_pKviWindow->type() == KVI_WND_TYPE_CHAT)startBeeping(((KviDccChat *)m_pKviWindow)->m_szRemoteNick.ptr());
	}
}
 
void KviIrcView::stopBeeping(const char *user)
{
        KviRegisteredUser *tmpU;
        KviStr currentFlags;
        KviStr tmpS(KviStr::Format,"%s!*@*", user);	//forms our hostname-and-username insensitive mask
							// (We're only matching on the nick)
 
        if((tmpU = g_pOptions->m_pRegUsersDb->findUserByMask(tmpS.ptr())) != NULL) {
                g_pOptions->m_pRegUsersDb->getFlags(tmpS.ptr(), currentFlags);                               // find what other flags exist
                if(currentFlags.contains("a"))g_pOptions->m_pRegUsersDb->unregisterUser(tmpU); // the beep control code added this
                                                                                                // user. For tidiness, delete them
                else g_pOptions->m_pRegUsersDb->deleteFlags(tmpU, "b");
        } else if (! g_pOptions->m_bAddUsersForBeepControl) {   // if user can't be found, but the setting is false, it might be that
                                                                // they were never added at user's behest. So it's not a problem.
                debug("Woah...couldn't find the user that I put in there.\nEvil is afoot...\n");
        }
 
        m_bBeeping = false;
}
 
void KviIrcView::startBeeping(const char *user)
{
        KviRegisteredUser *tmpU = new KviRegisteredUser();
        KviIrcUser tmpI;
	KviStr tmpS(KviStr::Format,"%s!*@*", user);	//forms our hostname-and-username insensitive mask
							// (We're only matching on the nick)
 
        // if user isn't in the list, they need to be
        // that's just how I'm doing it, okay?
        if( ((tmpU = g_pOptions->m_pRegUsersDb->findUserByMask(tmpS.ptr())) == NULL) && g_pOptions->m_bAddUsersForBeepControl) {
                // need to fill out a KviRegisteredUser object
                // for that we first need a KviIrcUser object
//                tmpI = new KviIrcUser();
                tmpI.setNick(user);
                tmpI.setHost("");
                tmpI.setUsername("");


                tmpU = new KviRegisteredUser();
                tmpU->user = tmpI;
                tmpU->allFlags = KviStr("ab");
                tmpU->passwd = KviStr("-");
                tmpU->comment = KviStr("Auto-entry for beep control");
                tmpU->bNotify = 0;
                tmpU->bIgnore = 0;

//				delete tmpI;

                g_pOptions->m_pRegUsersDb->registerUser(tmpU, "ab");
        } else if (tmpU != NULL) {
                g_pOptions->m_pRegUsersDb->addFlags(tmpU, "b");
        }
        m_bBeeping = true;
}
 
bool KviIrcView::initBeeping(const char *user)
{
        KviRegisteredUser *tmpU = new KviRegisteredUser();
        KviStr currentFlags;
 	KviStr tmpS(KviStr::Format,"%s!*@*", user);	//forms our hostname-and-username insensitive mask
							// (We're only matching on the nick)
 
        if((tmpU = g_pOptions->m_pRegUsersDb->findUserByMask(tmpS.ptr())) != NULL) {
                g_pOptions->m_pRegUsersDb->getFlags(tmpS.ptr(),currentFlags);                               // find what other flags exist
                if(currentFlags.contains("b"))return true;
        }
        return false;
 
}                                                                                                                                          

//============= LOGGING ===============//

void KviIrcView::stopLogging()
{
	if(m_pLogFile){
		QCString tmp = QDateTime::currentDateTime().toString().local8Bit();
		KviStr szLogEnd(KviStr::Format,_i18n_("### Log session terminated at %s ###"),tmp.data());
		add2Log(szLogEnd.ptr());		
		m_pLogFile->close();
		delete m_pLogFile;
		m_pLogFile = 0;
	}
}

void KviIrcView::getTextBuffer(KviStr &buffer)
{
	buffer = "";
	if(!m_pLastLine)return;
	for(KviIrcViewTextLine *l=m_pFirstLine;l;l=l->next_line){
		buffer.append(l->data_ptr);
		buffer.append("\n");
	}
}

void KviIrcView::toggleLogging()
{
	if(isLogging())stopLogging();
	else {
		KviStr tmp;
		m_pKviWindow->getDefaultLogName(tmp);
		startLogging(tmp.ptr());
	}
}

void KviIrcView::logToFile()
{
	// Yeah....this is powerful! :)
	KviStr cmd = "/DIALOG (savefile,Choose a log file name,$deflogfile($window),$window) "\
		"if((\"$dialogresult\" != \"\")&&(\"$dialogmagic\" == \"$window\"))log on $dialogresult";
	m_pFrm->m_pUserParser->parseUserCommand(cmd,m_pKviWindow);
}

void KviIrcView::saveBufferToFile()
{
	// Yeah....this is powerful! :)
	KviStr cmd = "/DIALOG (savefile,Choose a file name,$deflogfile($window).savebuf,$window) "\
		"if(\"$dialogresult\" != \"\")window $dialogmagic savebuffer $dialogresult";
	m_pFrm->m_pUserParser->parseUserCommand(cmd,m_pKviWindow);
}

void KviIrcView::toggleTimestamp()
{
	setTimestamp(!timestamp());
}

void KviIrcView::toggleImages()
{
	setShowImages(!imagesVisible());
}

void KviIrcView::clearBuffer()
{
	emptyBuffer(true);
}

bool KviIrcView::saveBuffer(const char *filename)
{
	QFile f(filename);
	if(!f.open(IO_WriteOnly|IO_Truncate))return false;
	KviStr tmp;
	getTextBuffer(tmp);
	f.writeBlock(tmp.ptr(),tmp.len());
	f.close();
	return true;
}


//============== startLogging ===============//

bool KviIrcView::startLogging(const char *filename)
{
	stopLogging();


	m_pLogFile = new QFile(filename);
	if(m_pLogFile->exists()){
		if(!m_pLogFile->open(IO_Append|IO_WriteOnly)){
			delete m_pLogFile;
			m_pLogFile = 0;
			return false;
		}
	} else {
		if(!m_pLogFile->open(IO_WriteOnly)){
			delete m_pLogFile;
			m_pLogFile = 0;
			return false;
		}
	}
	QCString tmp = QDateTime::currentDateTime().toString().local8Bit();
	KviStr szLogStart(KviStr::Format,_i18n_("### Log session started at %s ###"),tmp.data());
	add2Log(szLogStart.ptr());
	return true;
}

//=============== add2Log ==============//

void KviIrcView::add2Log(const char *buffer,int buf_len)
{
//	if(!m_pLogFile)return;
	if(buf_len<0)buf_len=strlen(buffer);
	if((m_pLogFile->writeBlock(buffer,buf_len)==-1)||(m_pLogFile->putch('\n')==-1))
			debug("WARNING: Cannot write to the log file.");
}

//============== prevLine ==============//
void KviIrcView::prevLine(){ m_pScrollBar->subtractLine(); }
//============== nextLine ==============//
void KviIrcView::nextLine(){ m_pScrollBar->addLine(); }
//============== prevPage ==============//
void KviIrcView::prevPage(){ m_pScrollBar->subtractPage(); }
//============== nextLine ==============//
void KviIrcView::nextPage(){ m_pScrollBar->addPage(); }

//============ setPrivateBackgroundPixmap ===========//

void KviIrcView::setPrivateBackgroundPixmap(const QPixmap &pixmap,bool bRepaint)
{
	if(m_pPrivateBackgroundPixmap){
		delete m_pPrivateBackgroundPixmap;
		m_pPrivateBackgroundPixmap=0;
	}
	if(!pixmap.isNull())m_pPrivateBackgroundPixmap = new QPixmap(pixmap);
	if(bRepaint)paintEvent(0);
}

//============= scrollBarPositionChanged=============//

void KviIrcView::scrollBarPositionChanged(int newValue)
{
	if(!m_pCurLine)return;
	int diff = 0;
	if(newValue > m_iLastScrollBarValue){
		while(newValue > m_iLastScrollBarValue){
			if(m_pCurLine->next_line){
				m_pCurLine=m_pCurLine->next_line;
				diff++;
			}
			m_iLastScrollBarValue++;
		}
	} else {
		while(newValue < m_iLastScrollBarValue){
			if(m_pCurLine->prev_line)m_pCurLine=m_pCurLine->prev_line;
			m_iLastScrollBarValue--;
		}
	}
	__range_valid(newValue == m_iLastScrollBarValue);
	if(!m_bSkipScrollBarRepaint)paintEvent(0);
//	if(!m_bSkipScrollBarRepaint)postUpdateEvent();
}

//============= emptyBuffer ==============//

void KviIrcView::emptyBuffer(bool bRepaint)
{
	while(m_pLastLine != 0)removeHeadLine();
	if(bRepaint)paintEvent(0);
}

//============= setMaxBufferSize ===============//

void KviIrcView::setMaxBufferSize(int maxBufSize,bool bRepaint)
{
	if(maxBufSize < 32)maxBufSize = 32;
	m_iMaxLines = maxBufSize;
	while(m_iNumLines > m_iMaxLines)removeHeadLine();
	m_pScrollBar->setRange(0,m_iNumLines);
	if(bRepaint)paintEvent(0);
}

//================ setShowImages ===============//

void KviIrcView::setShowImages(bool bShow,bool bRepaint){
	if(m_bShowImages!=bShow){
		m_bShowImages=bShow;
		if(bRepaint)paintEvent(0);
	}
}

//================ setTimestamp ================//

void KviIrcView::setTimestamp(bool bTimestamp)
{
	m_bTimestamp = bTimestamp;
/*

// STATS FOR A BUFFER FULL OF HIGHLY COLORED STRINGS , HIGHLY WRAPPED
//
// Lines = 1024 (322425 bytes - 314 KB) (avg 314 bytes per line) , well :)
// string bytes = 87745 (85 KB)
// attributes = 3576 (42912 bytes - 41 KB)
// blocks = 12226 (146712 bytes - 143 KB)     

	unsigned long int nAlloc = 0;
	unsigned long int nLines = 0;
	unsigned long int nStringBytes = 0;
	unsigned long int nAttrBytes = 0;
	unsigned long int nBlockBytes = 0;
	unsigned long int nBlocks = 0;
	unsigned long int nAttributes = 0;
	KviIrcViewTextLine * l=m_pFirstLine;
	while(l){
		nLines++;
		nAlloc += sizeof(KviIrcViewTextLine);
		nStringBytes += l->data_len + 1;
		nAlloc += l->data_len + 1;
		nAlloc += (l->attr_len * sizeof(KviIrcViewTextAttribute));
		nAttrBytes +=(l->attr_len * sizeof(KviIrcViewTextAttribute));
		nAlloc += (l->num_text_blocks * sizeof(KviIrcViewTextAttribute));
		nBlockBytes += (l->num_text_blocks * sizeof(KviIrcViewTextAttribute));
		nBlocks += (l->num_text_blocks);
		nAttributes += (l->attr_len);
		l = l->next_line;
	}
	debug("\n\nLines = %u (%u bytes - %u KB) (avg %u bytes per line)",nLines,nAlloc,nAlloc / 1024,nLines ? (nAlloc / nLines) : 0);
	debug("string bytes = %u (%u KB)",nStringBytes,nStringBytes / 1024);
	debug("attributes = %u (%u bytes - %u KB)",nAttributes,nAttrBytes,nAttrBytes / 1024);
	debug("blocks = %u (%u bytes - %u KB)\n",nBlocks,nBlockBytes,nBlockBytes / 1024);
*/
}

//============= appendLine =============//

bool KviIrcView::event(QEvent *e)
{
	if(e->type() == QEvent::User){
		__range_valid(m_bPostedPaintEventPending);
		if(m_iUnprocessedPaintEventRequests)paintEvent(0);
		// else we just had a pointEvent that did the job
		m_bPostedPaintEventPending = false;
		return true;
	}
	return QWidget::event(e);
}

void KviIrcView::postUpdateEvent()
{

	if(!m_bPostedPaintEventPending){
		m_bPostedPaintEventPending = true;
		QEvent *e = new QEvent(QEvent::User);
		g_pApp->postEvent(this,e); // queue a repaint
	}
	m_iUnprocessedPaintEventRequests++; // paintEvent() will set it to 0
	if(m_iUnprocessedPaintEventRequests == 3){
		if(g_pOptions->m_pixViewBack->isNull() && (!m_pPrivateBackgroundPixmap))fastScroll(3);
		else paintEvent(0);
	}
}

void KviIrcView::appendLine(KviIrcViewTextLine *ptr,bool bRepaint)
{
	if(isBeeping() && ! m_pKviWindow->hasFocus() && g_pOptions->m_bEnableBeeping)QApplication::beep();

	//This one appends a KviIrcViewTextLine to
	//the buffer list (at the end)
	if(m_bSelecting)
	{
		// Do not move the view!
		// So we append the text line to a temp queue
		// and then we'll add it when the mouse button is released
		m_pMessagesStoppedWhileSelecting->append(ptr);
		return;
	}

//	__range_valid(ptr->data_ptr);
	if(m_pLastLine){
		m_pLastLine->next_line=ptr;
		ptr->prev_line  =m_pLastLine;
		ptr->next_line  =0;
		m_iNumLines++;
		if(m_iNumLines > m_iMaxLines){
			removeHeadLine();
			if(m_pCurLine==m_pLastLine){
				m_pCurLine=ptr;
				if(bRepaint)postUpdateEvent();
			} else {
				// the cur line remains the same
				// the scroll bar must move up one place to be in sync
				m_bSkipScrollBarRepaint = true;
				if(m_pScrollBar->value() > 0){
					m_iLastScrollBarValue--;
					__range_valid(m_iLastScrollBarValue >= 0);
					m_pScrollBar->subtractLine();
				} // else will stay in sync
				m_bSkipScrollBarRepaint = false;
			}
		} else {
			m_pScrollBar->setRange(0,m_iNumLines);
			if(m_pCurLine==m_pLastLine){
				m_bSkipScrollBarRepaint = true;
				m_pScrollBar->addLine();
				m_bSkipScrollBarRepaint = false;
				if(bRepaint)postUpdateEvent();
			}
		}
		m_pLastLine=ptr;
	} else {
		//First line
		m_pLastLine    = ptr;
		m_pFirstLine   = ptr;
		m_pCurLine     = ptr;
		ptr->prev_line = 0;
		ptr->next_line = 0;
		m_iNumLines    = 1;
		m_pScrollBar->setRange(0,1);
		m_pScrollBar->addLine();
		if(bRepaint)paintEvent(0);
	}

	if(m_pLogFile){
		if(g_pOptions->m_bLogMsgType[ptr->msg_type]){
			add2Log(ptr->data_ptr,ptr->data_len - 1);
		}
	}
}

//============== removeHeadLine ===============//

void KviIrcView::removeHeadLine(bool bRepaint)
{
	//Removes the first line of the text buffer
	if(!m_pLastLine)return;
	__range_valid(m_pFirstLine->prev_line==0);
	__range_valid(m_pFirstLine->data_ptr);
	kvi_free(m_pFirstLine->data_ptr);                        //free string data
	if(m_pFirstLine->attr_ptr->attribute == KVI_TEXT_ESCAPE)
	{
		kvi_free(m_pFirstLine->attr_ptr->escape_cmd);
	}
	kvi_free(m_pFirstLine->attr_ptr);                        //free attributes data
	if(m_pFirstLine->num_text_blocks)kvi_free(m_pFirstLine->text_blocks_ptr);
	if(m_pFirstLine->next_line){
		KviIrcViewTextLine *aux_ptr=m_pFirstLine->next_line; //get the next line
		aux_ptr->prev_line=0;                                //becomes the first
		if(m_pFirstLine==m_pCurLine)m_pCurLine=aux_ptr;      //move the cur line if necessary
		delete m_pFirstLine;                                 //delete the struct
		m_pFirstLine=aux_ptr;                                //set the last
		m_iNumLines--;                                       //and decrement the count
	} else { //unique line
		m_pCurLine   = 0;
		m_pFirstLine = 0;
		m_iNumLines  = 0;
		delete m_pFirstLine;
		m_pLastLine  = 0;
	}
	if(bRepaint)paintEvent(0);
}

//============= appendText ===============//

void KviIrcView::appendText(int msg_type,const char *data_ptr,bool bRepaint)
{
	//appends a text string to the buffer list
	//splits the lines
	__range_valid(data_ptr);
	m_pLastLinkUnderMouse = 0;
	while(*data_ptr){                                         //Have more data
		KviIrcViewTextLine *line_ptr=new KviIrcViewTextLine;  //create a line struct
		line_ptr->msg_type=msg_type;
		line_ptr->max_line_width=-1;
		line_ptr->num_text_blocks=0;
		data_ptr=getTextLine(msg_type,data_ptr,line_ptr);
		appendLine(line_ptr,bRepaint);
	}
}

void KviIrcView::getDoubleClickCommand(KviStr &buffer,const char * escape_cmd)
{
	while(*escape_cmd == ' ')escape_cmd++;
	while(*escape_cmd == '[')
	{
		if(kvi_strEqualCIN(escape_cmd,"[dbl]",5))
		{
			escape_cmd+=5;
			buffer=escape_cmd;
			int idx = buffer.findFirstIdx("[rbt]");
			if(idx != -1)buffer.setLen(idx);
			return;
		}
		escape_cmd++;
		while(*escape_cmd && (*escape_cmd != '['))escape_cmd++;
	}
	buffer = escape_cmd; // whole command is a double click command
}

void KviIrcView::getRightClickCommand(KviStr &buffer,const char * escape_cmd)
{
	while(*escape_cmd == ' ')escape_cmd++;
	while(*escape_cmd == '[')
	{
		if(kvi_strEqualCIN(escape_cmd,"[rbt]",5))
		{
			escape_cmd+=5;
			buffer=escape_cmd;
			return;
		}
		escape_cmd++;
		while(*escape_cmd && (*escape_cmd != '['))escape_cmd++;
	}
}

//============= getTextLine ===============//

const char * KviIrcView::getTextLine(int msg_type,const char * data_ptr,KviIrcViewTextLine *line_ptr)
{
	//Splits the text data in lines (separated by '\n')

	int buffer_pos_idx=0;       //we're at the beginning in the buffer
	int curAttrIdx = 0;
	int blockLen;
	register const char *p=data_ptr;

	//Alloc the first attribute
	line_ptr->attr_len = 1;
	line_ptr->attr_ptr = (KviIrcViewTextAttribute *)kvi_malloc(sizeof(KviIrcViewTextAttribute));
	//And fill it up
	line_ptr->attr_ptr[0].attribute = KVI_TEXT_COLOR;
	line_ptr->attr_ptr[0].block_idx = 0;

	if(m_bTimestamp){
		line_ptr->data_ptr = (char *)kvi_malloc(12);     //[hh:mm:ss]space\0
		line_ptr->data_len = 12;
		line_ptr->attr_ptr[0].block_len = 11;
		buffer_pos_idx     = 11;
		*(line_ptr->data_ptr)='[';
		kvi_fastmove((void *)(line_ptr->data_ptr+1),(void *)QTime::currentTime().toString().latin1(),8);
		*((line_ptr->data_ptr)+9)=']';
		*((line_ptr->data_ptr)+10)=' ';
	} else {
		line_ptr->data_ptr = (char *)kvi_malloc(1);      //at least terminator
		line_ptr->data_len = 1;
		line_ptr->attr_ptr[0].block_len = 0;
	}

	line_ptr->attr_ptr[0].attr_back = g_pOptions->m_cViewOutTypeBack[msg_type];
	line_ptr->attr_ptr[0].attr_fore = g_pOptions->m_cViewOutTypeFore[msg_type];

	for(;;){
		if(g_pOptions->m_bUrlHighlighting)while((((unsigned char)*p) > 31)&&(*p != '~')&&(*p != 'h')&&(*p != 'f')&&(*p != 'F')&&(*p != 'w')&&(*p != 'W'))p++;
		else while((((unsigned char)*p) > 31)&&(*p != '~'))p++;
		switch(*p){
			case '\0':
				//Found the end of the string
				//Calculate the length of the last block
				blockLen = (p-data_ptr);
				//Update lengths
				line_ptr->data_len+=blockLen;
				line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
				//Resize the data buffer
				line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
				//Move the string data
				kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
				//move the buffer pointer to the end
				buffer_pos_idx+=blockLen;
				//terminate the string
				line_ptr->data_ptr[buffer_pos_idx]='\0';
				return p;
				break;
			case '\r':
				// Command escape sequence
				// \r![dbl]double_click_command [rbt]right_click_command\rparameters string\r/!\r
				p++;
				if(*p == '!'){
					const char * next_cr = p;
					// lookup the next carriage return
					while(*next_cr && (*next_cr != '\r'))next_cr++;
					if(*next_cr)
					{
						const char * term_cr = next_cr;
						term_cr++;
						while(*term_cr && (*term_cr != '\r'))term_cr++;
						if(*term_cr)
						{
							// ok....the format is right:
							//  \r!    ... \r ...    \r
							//    ^p        ^next_cr  ^term_cr
							p--;
							//  \r!    ... \r ...    \r
							//   ^p         ^next_cr  ^term_cr
							//Calculate the length of the last block
							blockLen = (p-data_ptr);
							//Update lengths
							line_ptr->data_len+=blockLen;
							line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
							//Resize the data buffer
							line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
							//Move the string data
							kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
							//move the buffer pointer to the end
							buffer_pos_idx+=blockLen;

							//Create a new attribute block
							line_ptr->attr_len++;
							line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
								line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
							curAttrIdx++;
							p+=2; //point after \r!
							//And fill it up
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_ESCAPE;
							line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
							line_ptr->attr_ptr[curAttrIdx].block_len = 0;

							blockLen = (next_cr - p);
							line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc((next_cr - p) + 1);
							kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),p,blockLen);
							line_ptr->attr_ptr[curAttrIdx].escape_cmd[blockLen] = '\0';
							line_ptr->attr_ptr[curAttrIdx].attr_fore = KVI_NOCHANGE;
//							line_ptr->attr_ptr[curAttrIdx].attr_back = KVI_NOCHANGE;
							++next_cr; //point after the middle \r
							blockLen = (term_cr - next_cr);
							//Update lengths
							line_ptr->data_len+=blockLen;
							line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
							//Resize the data buffer
							line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
							//Move the string data
							kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)next_cr,blockLen);
							//move the buffer pointer to the end
							buffer_pos_idx+=blockLen;

							//Create a new attribute block
							line_ptr->attr_len++;
							line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
								line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
							curAttrIdx++;
							//And fill it up
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_UNESCAPE;
							line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
								line_ptr->attr_ptr[curAttrIdx].block_len = 0;
							p=++term_cr;
							data_ptr=p;
						}
					}
				}
				break;
			case '\n':
				//Found the end of a line
				//Calculate the length of the last block
				blockLen = (p-data_ptr);
				//Update lengths
				line_ptr->data_len+=blockLen;
				line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
				//Resize the data buffer
				line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
				//Move the string data
				kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
				//move the buffer pointer to the end
				buffer_pos_idx+=blockLen;
				//terminate the string
				line_ptr->data_ptr[buffer_pos_idx]='\0';
				//move the current pointer to the next character...if it is '\0' we will simply stop
				p++;
				return p;
				break;
			case KVI_TEXT_BOLD:
			case KVI_TEXT_RESET:
			case KVI_TEXT_REVERSE:
			case KVI_TEXT_UNDERLINE:
				//Control code...need a new attribute struct
				//Found the end of a line
				//Calculate the length of the last block
				blockLen = (p-data_ptr);
				//Update lengths
				line_ptr->data_len+=blockLen;
				line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
				//Resize the data buffer
				line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
				//Move the string data
				kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
				//move the buffer pointer to the end
				buffer_pos_idx+=blockLen;
				//Create a new attribute block
				line_ptr->attr_len++;
				line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
					line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
				curAttrIdx++;
				//And fill it up
				line_ptr->attr_ptr[curAttrIdx].attribute = *p;
				line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
				line_ptr->attr_ptr[curAttrIdx].block_len = 0;
				//move the current pointer to the next character...if it is '\0' we will simply stop
				data_ptr=++p;
				break;
			case KVI_TEXT_COLOR:
				//Color control code...need a new attribute struct
				//Calculate the length of the last block
				blockLen = (p-data_ptr);
				//Update lengths
				line_ptr->data_len+=blockLen;
				line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
				//Resize the data buffer
				line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
				//Move the string data
				kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
				//move the buffer pointer to the end
				buffer_pos_idx+=blockLen;
				//Create a new attribute block
				line_ptr->attr_len++;
				line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
					line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
				curAttrIdx++;
				//And fill it up
				line_ptr->attr_ptr[curAttrIdx].attribute = *p;
				line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
				line_ptr->attr_ptr[curAttrIdx].block_len = 0;
				//move the current pointer to the next character...if it is '\0' we will simply stop
				p++;
				p=getColorBytes(p,&(line_ptr->attr_ptr[curAttrIdx].attr_fore),
					&(line_ptr->attr_ptr[curAttrIdx].attr_back));
				data_ptr=p;
				break;
			case '~':
				if((g_pOptions->m_bUseKsircControlCodes) && (line_ptr->attr_ptr[curAttrIdx].attribute != *p)){
					//Control code...need a new attribute struct
					//Calculate the length of the last block
					blockLen = (p-data_ptr);
					//Update lengths
					line_ptr->data_len+=blockLen;
					line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
					//Resize the data buffer
					line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
					//Move the string data
					kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
					//move the buffer pointer to the end
					buffer_pos_idx+=blockLen;
					//Create a new attribute block
					line_ptr->attr_len++;
					line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
					line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
					curAttrIdx++;
					//And fill it up
					line_ptr->attr_ptr[curAttrIdx].attribute = *p;
					line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
					line_ptr->attr_ptr[curAttrIdx].block_len = 0;
					//move the current pointer to the next character...if it is '\0' we will simply stop
					p++;
					switch(*p){
						case 'c':
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_RESET;
							p++;
							break;
						case 'b':
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_BOLD;
							p++;
							break;
						case 'i': //italics not yet supported
							p++;
							break;
						case 'r':
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_REVERSE;
							p++;
							break;
						case 'u':
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_UNDERLINE;
							p++;
							break;
						case '~': break; //just a tilde
						default:
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_COLOR;
							p=getColorBytes(p,&(line_ptr->attr_ptr[curAttrIdx].attr_fore),
								&(line_ptr->attr_ptr[curAttrIdx].attr_back));
							break;
						}
					data_ptr=p;
				} else p++;
				break;
			case 'h':
			case 'f':
			case 'F':
				p++;
				if((*p == 't')||(*p == 'T')){
					p--;
					int partLen = 0; // here it is a
					if(kvi_strEqualCIN(p,"ftp.",4))partLen = 4;
					else if(kvi_strEqualCSN(p,"ftp://",6))partLen = 6;
					else if(kvi_strEqualCSN(p,"http://",7))partLen = 7;
					else if(kvi_strEqualCSN(p,"https://",8))partLen = 8;
					p+=partLen;
					if((partLen > 0)&&(((unsigned char)*p) > 47))
					{
						p-=partLen;
						//Url highlighting block
						//Calculate the length of the last block
						blockLen = (p-data_ptr);
						//Update lengths
						line_ptr->data_len+=blockLen;
						line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
						//Resize the data buffer
						line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
						//Move the string data
						kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
						//move the buffer pointer to the end
						buffer_pos_idx+=blockLen;
						//Create a new attribute block
						line_ptr->attr_len++;
						line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
							line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
						curAttrIdx++;
						//And fill it up
						line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_ESCAPE;
						line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
						line_ptr->attr_ptr[curAttrIdx].block_len = 0;
						line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(11);
						kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),"openurl $1",11);
						line_ptr->attr_ptr[curAttrIdx].attr_fore = g_pOptions->m_cViewOutUrlFore;
//						line_ptr->attr_ptr[curAttrIdx].attr_back = KVI_NOCHANGE;
						//move the current pointer after the 'http:/' block
						//and run until the presumed end of the url
						data_ptr=p;
						p+=partLen;
						//Question : What characters are NOT allowed in an URL ?
						//I assume [] () {} and chars below 33 (space too , and negative chars too! (for signed char systems))
						while((((unsigned char)*p) > 32) && (*p != '[') && (*p != ']') &&
								(*p != '(') && (*p != ')') && (*p != '{') && (*p != '}'))p++;
											//Calculate the length of the last block
						blockLen = (p-data_ptr);
						//code for onUrl event by YaP

						if(g_pEventManager->eventEnabled(KviEvent_OnUrl)){
							const char *tmp=data_ptr;
							KviStr tmpurl(tmp,blockLen);
							m_pFrm->m_pUserParser->callEvent(KviEvent_OnUrl,m_pKviWindow ? m_pKviWindow : m_pFrm->m_pConsole,tmpurl);
						}
						//Update lengths
						line_ptr->data_len+=blockLen;
						line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
						//Resize the data buffer
						line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
						//Move the string data
						kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
						//move the buffer pointer to the end
						buffer_pos_idx+=blockLen;
						//Create a new attribute block
						line_ptr->attr_len++;
						line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
							line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
						curAttrIdx++;
						//And fill it up
						line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_UNESCAPE;
						line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
						line_ptr->attr_ptr[curAttrIdx].block_len = 0;
						data_ptr=p;
					} else p-=partLen-1;
				}
				break;
			case 'w':
			case 'W':
				p++;
				if((*p == 'w')||(*p == 'W')){
					//p--;
					if(kvi_strEqualCIN(p,"ww.",3))//www.
					{
						p+=3;
						if(((unsigned char)*p) < 48)
							p-=3;
						else {
							p-=4;
							//Url highlighting block
							//Calculate the length of the last block
							blockLen = (p-data_ptr);
							//Update lengths
							line_ptr->data_len+=blockLen;
							line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
							//Resize the data buffer
							line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
							//Move the string data
							kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
							//move the buffer pointer to the end
							buffer_pos_idx+=blockLen;
							//Create a new attribute block
							line_ptr->attr_len++;
							line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
								line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
							curAttrIdx++;
							//And fill it up
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_ESCAPE;
							line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
							line_ptr->attr_ptr[curAttrIdx].block_len = 0;
							line_ptr->attr_ptr[curAttrIdx].escape_cmd = (char *)kvi_malloc(11);
							kvi_fastmove((void *)(line_ptr->attr_ptr[curAttrIdx].escape_cmd),"openurl $1",11);
							line_ptr->attr_ptr[curAttrIdx].attr_fore = g_pOptions->m_cViewOutUrlFore;
//							line_ptr->attr_ptr[curAttrIdx].attr_back = KVI_NOCHANGE;
							//move the current pointer after the 'http:/' block
							//and run until the presumed end of the url
							data_ptr=p;
							p+=4;
							//Question : What characters are NOT allowed in an URL ?
							//I assume [] () {} and chars below 33 (space too , and negative chars too! (for signed char systems))
							while((((unsigned char)*p) > 32) && (*p != '[') && (*p != ']') &&
								(*p != '(') && (*p != ')') && (*p != '{') && (*p != '}'))p++;
									//Calculate the length of the last block
							blockLen = (p-data_ptr);
							//code for onUrl event by YaP

							if(g_pEventManager->eventEnabled(KviEvent_OnUrl)){
								const char *tmp=data_ptr;
								KviStr tmpurl(tmp,blockLen);
								m_pFrm->m_pUserParser->callEvent(KviEvent_OnUrl,m_pKviWindow ? m_pKviWindow : m_pFrm->m_pConsole,tmpurl);
							}
							//Update lengths
							line_ptr->data_len+=blockLen;
							line_ptr->attr_ptr[curAttrIdx].block_len+=blockLen;
							//Resize the data buffer
							line_ptr->data_ptr=(char *)kvi_realloc((void *)line_ptr->data_ptr,line_ptr->data_len);
							//Move the string data
							kvi_fastmove((void *)(line_ptr->data_ptr+buffer_pos_idx),(void *)data_ptr,blockLen);
							//move the buffer pointer to the end
							buffer_pos_idx+=blockLen;
							//Create a new attribute block
							line_ptr->attr_len++;
							line_ptr->attr_ptr=(KviIrcViewTextAttribute *)kvi_realloc((void *)line_ptr->attr_ptr,
								line_ptr->attr_len * sizeof(KviIrcViewTextAttribute));
							curAttrIdx++;
							//And fill it up
							line_ptr->attr_ptr[curAttrIdx].attribute = KVI_TEXT_UNESCAPE;
							line_ptr->attr_ptr[curAttrIdx].block_idx = buffer_pos_idx;
							line_ptr->attr_ptr[curAttrIdx].block_len = 0;
							data_ptr=p;
						} //else p++;
					}
				}
				break;
			default:
				p++;
				break;
		}
	}
}

//================ drawBlockPart =================//

inline void KviIrcView::drawBlockPart(char curFore,char curBack,bool curBold,bool curUnderline,
	int curLeftCoord,int curBottomCoord,const char *data,int len,int wdth)
{
//	__range_valid(curFore != KVI_TRANSPARENT);
#ifdef COMPILE_USE_AA_FONTS
	if(g_pXftFont){
		if(curBack != KVI_TRANSPARENT){
			int theWdth = wdth;
			if((theWdth <= 0)&&(len > 0))
				theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+KVI_IRCVIEW_SCROLLBAR_WIDTH);
			XSetForeground(g_display,g_ircviewGC,
				g_pOptions->m_pMircColor[(unsigned char)curBack]->pixel());
			XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
				curBottomCoord - m_iFontLineSpacing + m_iFontDescent,theWdth,m_iFontLineSpacing);
		}
		QColor * clr = g_pOptions->m_pMircColor[(unsigned char)curFore];
		XftColor color;
		color.color.red = clr->red() | clr->red() << 8;
		color.color.green = clr->green() | clr->green() << 8;
		color.color.blue = clr->blue() | clr->blue() << 8;
		color.color.alpha = 0xffff;
		color.pixel = clr->pixel();
		XftDrawString8(g_pXftDraw,&color,g_pXftFont,curLeftCoord,curBottomCoord,(unsigned char *)data,len);
		if(curBold)XftDrawString8(g_pXftDraw,&color,g_pXftFont,curLeftCoord + 1,curBottomCoord,(unsigned char *)data,len);
		if(curUnderline){
			XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curFore]->pixel());
			int theWdth = wdth;
			if(theWdth < 0)
				theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+KVI_IRCVIEW_SCROLLBAR_WIDTH);
			XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth,
				LineSolid,CapButt,JoinMiter);
			XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,
				curLeftCoord,curBottomCoord,curLeftCoord+theWdth,curBottomCoord);
		}
	} else {
#endif
		XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curFore]->pixel());
		if(curBack != KVI_TRANSPARENT){
			XSetBackground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curBack]->pixel());
			XDrawImageString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,data,len);
		} else XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,data,len);
		if(curBold) //Draw doubled font (simulate bold)
			XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord+1,curBottomCoord,data,len);
		if(curUnderline){ //Draw a line under the text block....
			//if width is negative , it is the last block of a line
			int theWdth = wdth;
			if(theWdth < 0)theWdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+KVI_IRCVIEW_SCROLLBAR_WIDTH);
			XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth,LineSolid,CapButt,JoinMiter);
			XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,curLeftCoord+theWdth,curBottomCoord);
		}
#ifdef COMPILE_USE_AA_FONTS
	}
#endif
}

//void KviIrcView::drawNormalText(char curFore,char curBack,bool curBold,bool curUnderline,
//		int curLeftCoord,int curBottomCoord,const char * text_ptr,int len,int wdth)
//{
//	drawBlockPart(curFore,curBack,curBold,curUnderline,curLeftCoord,
//		curBottomCoord,text_ptr,len,wdth);
//	curLeftCoord += wdth;
//}

inline void KviIrcView::drawSelectedText(char curAttribute,char curFore,char curBack,
	int curLeftCoord,int curBottomCoord,const char *text_ptr,int len,int wdth)
{
#ifdef COMPILE_USE_AA_FONTS
	if(g_pXftFont){
//		int theWdth = wdth;
		if((wdth <= 0)&&(len > 0))
			wdth=width()-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER+KVI_IRCVIEW_SCROLLBAR_WIDTH);
		XSetForeground(g_display,g_ircviewGC,
			g_pOptions->m_pMircColor[(unsigned char)g_pOptions->m_cViewOutSeleBack]->pixel());
		XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
			curBottomCoord - m_iFontLineSpacing + m_iFontDescent,wdth,m_iFontLineSpacing);
		QColor * clr = g_pOptions->m_pMircColor[(unsigned char)g_pOptions->m_cViewOutSeleFore];
		XftColor color;
		color.color.red = clr->red() | clr->red() << 8;
		color.color.green = clr->green() | clr->green() << 8;
		color.color.blue = clr->blue() | clr->blue() << 8;
		color.color.alpha = 0xffff;
		color.pixel = clr->pixel();
		XftDrawString8(g_pXftDraw,&color,g_pXftFont,curLeftCoord,curBottomCoord,(unsigned char *)text_ptr,len);
	} else {
#endif
		XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)g_pOptions->m_cViewOutSeleFore]->pixel());
		XSetBackground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)g_pOptions->m_cViewOutSeleBack]->pixel());
		XDrawImageString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,text_ptr,len);
#ifdef COMPILE_USE_AA_FONTS
	}
#endif
	if(curAttribute){
		switch(curAttribute)
		{
			case KVI_TEXT_BOLD:
			case KVI_TEXT_RESET:
			case KVI_TEXT_REVERSE:
			case KVI_TEXT_UNDERLINE:
				m_iLastSelectionLineLen++;
				m_szLastSelectionLine.append(curAttribute);
				break;
			case KVI_TEXT_COLOR:
				m_iLastSelectionLineLen++;
				m_szLastSelectionLine.append(curAttribute);
				if(curFore != KVI_NOCHANGE){
					if(curFore <= 9)m_iLastSelectionLineLen++;
					else m_iLastSelectionLineLen+=2;
					m_szLastSelectionLine.append(KviStr::Format,"%d",(int)curFore);
				}
				if(curBack != KVI_NOCHANGE){
					if(curBack <= 9)m_iLastSelectionLineLen+=2;
					else m_iLastSelectionLineLen+=3;
					m_szLastSelectionLine.append(',');
					m_szLastSelectionLine.append(KviStr::Format,"%d",(int)curBack);
				}
				break;
		}
	}
	//Append the block to the selection line
	m_szLastSelectionLine.setLen(m_iLastSelectionLineLen+len);
	m_szLastStrippedSelectionLine.setLen(m_iLastStrippedSelectionLineLen+len);
	kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen,text_ptr,len);
	kvi_fastmove(m_szLastStrippedSelectionLine.ptr()+m_iLastStrippedSelectionLineLen,text_ptr,len);
//	kvi_fastmove(m_szLastSelectionLine.ptr()+m_iLastSelectionLineLen,(void *)text_ptr,len);
	m_iLastSelectionLineLen += len;
	m_iLastStrippedSelectionLineLen += len;
	//And move to the next block
//	curLeftCoord+= wdth;
}

void KviIrcView::fastScroll(int lines)
{
	m_iUnprocessedPaintEventRequests = 0;
	if(!isVisible())return;
	// Ok...the current line is the last one here
	// It is the only one that needs to be repainted
	int widgetWidth  = width()-KVI_IRCVIEW_SCROLLBAR_WIDTH;
	if(widgetWidth < 20)return; //can't show stuff here
	int widgetHeight = height();
	int maxLineWidth = widgetWidth;
	int defLeftCoord=KVI_IRCVIEW_HORIZONTAL_BORDER;
	if(m_bShowImages){
		maxLineWidth -= KVI_IRCVIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH;
		defLeftCoord+=KVI_IRCVIEW_PIXMAP_AND_SEPARATOR;
	}
	int heightToPaint = 1;
	KviIrcViewTextLine * l = m_pCurLine;
	while(lines > 0){
		if(l){
			if(maxLineWidth != l->max_line_width)calculateLineWraps(l,maxLineWidth);
			heightToPaint += l->line_wraps * m_iFontLineSpacing;
			heightToPaint += (m_iFontLineSpacing + m_iFontDescent);
			lines--;
			l = l->prev_line;
		} else lines = 0;
	}

	XCopyArea(g_display,handle(),handle(),g_ircviewGC,
				1,heightToPaint,
				widgetWidth - 2,
				widgetHeight - (heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER),
				1,1);
	QRect r(0,widgetHeight - (heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER),
			widgetWidth,heightToPaint + KVI_IRCVIEW_VERTICAL_BORDER);

	QPaintEvent * e = new QPaintEvent(r);
	paintEvent(e);
	delete e;

	if(m_iLastLinkRectHeight > -1)
	{
		// need to kill the last highlighted link
		m_iLastLinkRectTop -= heightToPaint;
		if(m_iLastLinkRectTop < 0)
		{
			m_iLastLinkRectHeight += m_iLastLinkRectTop;
			m_iLastLinkRectTop = 0;
		}
//		QRect rct(0,m_iLastLinkRectTop,widgetWidth,m_iLastLinkRectHeight);
//		debug("Repainting %d,%d,%d,%d",0,m_iLastLinkRectTop,widgetWidth,m_iLastLinkRectHeight);
//		QPaintEvent * e2 = new QPaintEvent(r);
//		paintEvent(e2);
//		delete e2;
//		QPoint mPos = mapFromGlobal(QCursor::pos());
//		if(rect().contains(mPos))
//		{
//			QMouseEvent
//		}
	}

}

void KviIrcView::paintEvent(QPaintEvent *p)
{
	//
	// THIS FUNCTION IS A MONSTER
	//
	int widgetWidth  = width() - KVI_IRCVIEW_SCROLLBAR_WIDTH;
	if(!isVisible() || (widgetWidth < 20))
	{
		m_iUnprocessedPaintEventRequests = 0; // assume a full repaint when this widget is shown...
		return; //can't show stuff here
	}

//	m_iUnprocessedPaintEventRequests = 0;
//	if(!isVisible())return;
//
//	int widgetWidth  = width() - KVI_IRCVIEW_SCROLLBAR_WIDTH;
//	if(widgetWidth < 20)return; //can't show stuff here

	int widgetHeight = height();

	QRect r;

	if(p)r=p->rect();
	else {
		// A self triggered event
		m_iUnprocessedPaintEventRequests = 0; // only full repaints reset
		r = rect();	
	}

	int rectLeft   = r.x();
	int rectTop    = r.y();
	int rectBottom = r.y() + r.height();
	int rectWidth  = r.width();
	if(rectWidth > widgetWidth)rectWidth = widgetWidth;
	int rectHeight = r.height();

	// evil XFillRectangle... 

	if(m_pPrivateBackgroundPixmap)
	{
		XSetTile(g_display,g_ircviewGC,m_pPrivateBackgroundPixmap->handle());
		XSetFillStyle(g_display,g_ircviewGC,FillTiled);
	   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
		XSetFillStyle(g_display,g_ircviewGC,FillSolid);
	} else {
		if(g_pOptions->m_pixViewBack->isNull())
		{
			XSetForeground(g_display,g_ircviewGC,g_pOptions->m_clrViewBack.pixel());
			XSetBackground(g_display,g_ircviewGC,g_pOptions->m_clrViewBack.pixel());
		   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
		} else {
			XSetTile(g_display,g_ircviewGC,g_pOptions->m_pixViewBack->handle());
			XSetFillStyle(g_display,g_ircviewGC,FillTiled);
		   	XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight);
			XSetFillStyle(g_display,g_ircviewGC,FillSolid);
		}
	}

#ifdef COMPILE_USE_AA_FONTS
	if(qt_use_xft())
	{
		g_pXftFont = (XftFont *)qt_ft_font(&(font()));
		g_pXftDraw = qt_lookup_ft_draw (g_hIrcViewMemBuffer,false,0);
		if(!g_pXftDraw)
		{
			g_pXftFont = 0;
			XSetFont(g_display,g_ircviewGC,font().handle());
		}
	} else {
#endif
		XSetFont(g_display,g_ircviewGC,font().handle());
#ifdef COMPILE_USE_AA_FONTS
		g_pXftFont = 0;
		g_pXftDraw = 0;
	}
#endif

	//Have lines visible
	int curBottomCoord = widgetHeight - KVI_IRCVIEW_VERTICAL_BORDER;
	int maxLineWidth   = widgetWidth;
	int defLeftCoord   = KVI_IRCVIEW_HORIZONTAL_BORDER;
	int lineWrapsHeight;

	if(m_bShowImages){
		maxLineWidth -= KVI_IRCVIEW_PIXMAP_SEPARATOR_AND_DOUBLEBORDER_WIDTH;
		defLeftCoord += KVI_IRCVIEW_PIXMAP_AND_SEPARATOR;
	}

	KviIrcViewTextLine *pCurTextLine = m_pCurLine;

	if(m_bSelecting)
	{
		if(m_bDoubleClicked)
		{
			m_szLastDoubleClickedEscape = "";
			m_szLastDoubleClickedEscapeCmd = "";
		} else {
			m_szLastSelectionLine   = "";
			m_szLastStrippedSelectionLine = "";
			m_szLastSelection       = "";
			m_szLastStrippedSelection = "";
			m_iLastSelectionLineLen = 0;
			m_iLastStrippedSelectionLineLen = 0;
		}
	}

	//Make sure that we have enough space to paint something...
	if(maxLineWidth < ((m_iFontCharacterWidth['w'] << 1)+m_iWrapMargin))pCurTextLine=0;

	//And loop thru lines until we not run over the upper bound of the view
	while((curBottomCoord >= KVI_IRCVIEW_VERTICAL_BORDER) && pCurTextLine)
	{
		//Paint pCurTextLine
		if(maxLineWidth != pCurTextLine->max_line_width)
		{
			// Width of the widget or the font has been changed
			// from the last time that this line was painted
			calculateLineWraps(pCurTextLine,maxLineWidth);
		}

		// the evil multiplication
		// in an i486 it can get up to 42 clock cycles
		lineWrapsHeight  = (pCurTextLine->line_wraps) * m_iFontLineSpacing;
		curBottomCoord  -= lineWrapsHeight;

		if((curBottomCoord - m_iFontLineSpacing) > rectBottom)
		{
			// not in update rect... skip
			curBottomCoord -= (m_iFontLineSpacing + m_iFontDescent);
			pCurTextLine = pCurTextLine->prev_line;
			continue;
		}

		if(m_bShowImages)
		{
			//Paint the pixmap first
			//Calculate the position of the image
			//imageYPos = curBottomCoord - (pixmapHeight(16) + ((m_iFontLineSpacing - 16)/2) );
			int imageYPos = curBottomCoord - ((m_iFontLineSpacing + 16) >> 1);
			//Set the mask if needed
			QPixmap *pix = g_pixViewOut[pCurTextLine->msg_type];
			if(pix->mask()){
				XSetClipMask(g_display,g_ircviewGC,pix->mask()->handle());
				XSetClipOrigin(g_display,g_ircviewGC,KVI_IRCVIEW_HORIZONTAL_BORDER,imageYPos);
			}
			//Draw the pixmap
			XCopyArea(g_display,pix->handle(),g_hIrcViewMemBuffer,g_ircviewGC,0,0,16,16,KVI_IRCVIEW_HORIZONTAL_BORDER,imageYPos);
			XSetClipMask(g_display,g_ircviewGC,None);
		}

		//Initialize for drawing this line of text
		char defaultBack  = pCurTextLine->text_blocks_ptr->attr_ptr->attr_back;
		char defaultFore  = pCurTextLine->text_blocks_ptr->attr_ptr->attr_fore;
		bool curBold      = false;
		bool curUnderline = false;
		char foreBeforeEscape= KVI_BLACK;
//		char backBeforeEscape= KVI_TRANSPARENT;
		bool curLink      = false;
		char curFore      = defaultFore;
		char curBack      = defaultBack;
		int  curLeftCoord = defLeftCoord;
		curBottomCoord   -= m_iFontDescent; //raise the text...

		//
		// Single text line loop (paint all text blocks)
		// (May correspond to more physical lines on the display if the text is wrapped)
		//

		for(int i=0;i < pCurTextLine->num_text_blocks;i++)
		{

			register KviIrcViewTextBlock * block = &(pCurTextLine->text_blocks_ptr[i]);

			// Play with the attributes

			if(block->attr_ptr)
			{
				//normal block
				switch(block->attr_ptr->attribute)
				{
					case KVI_TEXT_COLOR:
						if(block->attr_ptr->attr_fore != KVI_NOCHANGE)
							curFore = block->attr_ptr->attr_fore;
						else curFore = defaultFore;
						if(block->attr_ptr->attr_back != KVI_NOCHANGE)
							curBack = block->attr_ptr->attr_back;
						else curBack = defaultBack;
						break;
					case KVI_TEXT_ESCAPE:
						foreBeforeEscape      = curFore;
//						backBeforeEscape      = curBack;
						if(block->attr_ptr->attr_fore != KVI_NOCHANGE)
							curFore = block->attr_ptr->attr_fore;
//						if(block->attr_ptr->attr_back != KVI_NOCHANGE)
//							curBack = block->attr_ptr->attr_back;
						if(m_pLastLinkUnderMouse == block)curLink = true;
						break;
					case KVI_TEXT_UNESCAPE:
						curLink            = false;
						curFore            = foreBeforeEscape;
//						curBack            = backBeforeEscape;
						break;
/*
					case KVI_TEXT_ESCAPE_UNDERLINE:
						curLink               = true;
						curUnderline          = !curUnderline;
						foreBeforeEscape      = curFore;
						backBeforeEscape      = curBack;
						if(block->attr_ptr->attr_fore != KVI_NOCHANGE)
							curFore = block->attr_ptr->attr_fore;
						if(block->attr_ptr->attr_back != KVI_NOCHANGE)
							curBack = block->attr_ptr->attr_back;
						break;
					case KVI_TEXT_UNESCAPE_UNDERLINE:
						curLink            = false;
						curUnderline       = !curUnderline;
						curFore            = foreBeforeEscape;
						curBack            = backBeforeEscape;
						break;
*/
					case KVI_TEXT_BOLD:
						curBold            = !curBold;
						break;
					case KVI_TEXT_UNDERLINE:
						curUnderline       = !curUnderline;
						break;
					case KVI_TEXT_RESET:
						curBold            = false;
						curUnderline       = false;
						curFore            = defaultFore;
						curBack            = defaultBack;
						break;
					case KVI_TEXT_REVERSE: //Huh ?
						if(curBack != KVI_TRANSPARENT)
						{
							char aux       = curFore;
							curFore        = curBack;
							curBack        = aux;
						} else {
							curBack = curFore;
							switch(curBack)
							{
								case KVI_WHITE:
								case KVI_ORANGE:
								case KVI_YELLOW:
								case KVI_LIGHTGREEN:
								case KVI_BLUEMARINE:
								case KVI_LIGHTBLUE:
								case KVI_LIGHTVIOLET:
								case KVI_LIGHTGRAY:
									curFore=KVI_BLACK;
									break;
								default: //transparent too
									curFore=KVI_LIGHTGREEN;
									break;
							}
						}
						break;
				}

			} else {

				// no attributes, it is a line wrap
				curLeftCoord = defLeftCoord;
				if(g_pOptions->m_bWrapMargin)curLeftCoord+=m_iWrapMargin;
				curBottomCoord += m_iFontLineSpacing;

			}

			if(m_bSelecting)
			{ //Check if the block or a part of it is selected
				if(m_bDoubleClicked)
				{
					checkForDoubleClickedUrlOrEscape(pCurTextLine,curLeftCoord,curBottomCoord,i);
					goto no_selection_paint;
				} else {
					if(checkSelectionBlock(pCurTextLine,curLeftCoord,curBottomCoord,i))
					{
						//Selected in some way
						//__range_valid(g_pOptions->m_cViewOutSeleFore != KVI_TRANSPARENT);
						//__range_valid(g_pOptions->m_cViewOutSeleBack != KVI_TRANSPARENT);
						int wdth = block->block_width;
						char curAttribute = 0;
						char curAttrFore = KVI_NOCHANGE;
						char curAttrBack = KVI_NOCHANGE;
						if((block->attr_ptr)&&(i > 0))
						{
							curAttribute = block->attr_ptr->attribute;
							curAttrFore = block->attr_ptr->attr_fore;
							curAttrBack = block->attr_ptr->attr_back;
						}
						switch(m_TextBlockSelectionInfo.selection_type){
							case KVI_IRCVIEW_BLOCK_SELECTION_TOTAL:
								//if((wdth == 0) && (block->block_len > 0))
									//if((i < (pCurTextLine->num_text_blocks - 1))&&(pCurTextLine->text_blocks_ptr[i+1].attr_ptr == 0))
									//wdth = widgetWidth-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER);
									// else simply a zero characters block
								drawSelectedText(curAttribute,curAttrFore,curAttrBack,
									curLeftCoord,curBottomCoord,
									block->block_ptr,block->block_len,wdth);
									curLeftCoord += block->block_width;
								break;
							case KVI_IRCVIEW_BLOCK_SELECTION_LEFT:
								drawSelectedText(curAttribute,curAttrFore,curAttrBack,
									curLeftCoord,curBottomCoord,
									block->block_ptr,m_TextBlockSelectionInfo.part_1_length,
									m_TextBlockSelectionInfo.part_1_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_1_width;
								drawBlockPart(curFore,curBack,curBold,
									curUnderline,curLeftCoord,curBottomCoord,
									block->block_ptr+m_TextBlockSelectionInfo.part_1_length,
									m_TextBlockSelectionInfo.part_2_length,
									m_TextBlockSelectionInfo.part_2_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_2_width;
								break;
							case KVI_IRCVIEW_BLOCK_SELECTION_RIGHT:
								drawBlockPart(curFore,curBack,curBold,curUnderline,curLeftCoord,
									curBottomCoord,block->block_ptr,
									m_TextBlockSelectionInfo.part_1_length,
									m_TextBlockSelectionInfo.part_1_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_1_width;
								drawSelectedText(curAttribute,curAttrFore,curAttrBack,
									curLeftCoord,curBottomCoord,
									block->block_ptr + m_TextBlockSelectionInfo.part_1_length,
									m_TextBlockSelectionInfo.part_2_length,
									m_TextBlockSelectionInfo.part_2_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_2_width;
								break;
							case KVI_IRCVIEW_BLOCK_SELECTION_CENTRAL:
								drawBlockPart(curFore,curBack,curBold,curUnderline,curLeftCoord,
									curBottomCoord,block->block_ptr,
									m_TextBlockSelectionInfo.part_1_length,
									m_TextBlockSelectionInfo.part_1_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_1_width;
								drawSelectedText(curAttribute,curAttrFore,curAttrBack,
									curLeftCoord,curBottomCoord,
									block->block_ptr + m_TextBlockSelectionInfo.part_1_length,
									m_TextBlockSelectionInfo.part_2_length,
									m_TextBlockSelectionInfo.part_2_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_2_width;
								drawBlockPart(curFore,curBack,curBold,curUnderline,curLeftCoord,
									curBottomCoord,
									block->block_ptr+m_TextBlockSelectionInfo.part_1_length +
									m_TextBlockSelectionInfo.part_2_length,
									m_TextBlockSelectionInfo.part_3_length,
									m_TextBlockSelectionInfo.part_3_width);
									curLeftCoord += m_TextBlockSelectionInfo.part_3_width;
								break;
						}
					} else {
						int wdth = block->block_width;
						// Last block before a word wrap , or a zero characters attribute block ?
						if((wdth == 0) && (block->block_len > 0))
							// There is another block...
							// Check if it is a wrap...
							if((i < (pCurTextLine->num_text_blocks - 1))&&(pCurTextLine->text_blocks_ptr[i+1].attr_ptr == 0))
								wdth = widgetWidth-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER);
						// else simply a zero characters block
						drawBlockPart(
							curFore,curBack,curBold,curUnderline,curLeftCoord,curBottomCoord,
							block->block_ptr,
							block->block_len,
							wdth);
						curLeftCoord+=block->block_width;
					}
				}
			} else {
				//No selection ...go fast!
no_selection_paint:
				//__range_valid(curFore != KVI_TRANSPARENT);

#ifdef COMPILE_USE_AA_FONTS
				if(g_pXftFont)
				{
					if(curBack != KVI_TRANSPARENT){
						int wdth = block->block_width;
						// Last block before a word wrap , or a zero characters attribute block ?
						if(wdth == 0)
							// There is another block...
							// Check if it is a wrap...
							if((i < (pCurTextLine->num_text_blocks - 1))&&(pCurTextLine->text_blocks_ptr[i+1].attr_ptr == 0))
								wdth = widgetWidth-(curLeftCoord+KVI_IRCVIEW_HORIZONTAL_BORDER);
						// else simply a zero characters block; it is the last one!
						XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curBack]->pixel());
						XFillRectangle(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
							curBottomCoord - m_iFontLineSpacing + m_iFontDescent,wdth,m_iFontLineSpacing);
					}
					QColor * clr = g_pOptions->m_pMircColor[(unsigned char)curFore];
					XftColor color;
					color.color.red = clr->red() | clr->red() << 8;
					color.color.green = clr->green() | clr->green() << 8;
					color.color.blue = clr->blue() | clr->blue() << 8;
					color.color.alpha = 0xffff;
					color.pixel = clr->pixel();
					XftDrawString8(g_pXftDraw,&color,g_pXftFont,curLeftCoord,
						curBottomCoord,(unsigned char *)(block->block_ptr),block->block_len);
					if(curBold)XftDrawString8(g_pXftDraw,&color,g_pXftFont,curLeftCoord + 1,
									curBottomCoord,(unsigned char *)(block->block_ptr),block->block_len);
					if(curLink)
					{
						clr = g_pOptions->m_pMircColor[(unsigned char)g_pOptions->m_cViewOutUrlFore];
						color.color.red = clr->red() | clr->red() << 8;
						color.color.green = clr->green() | clr->green() << 8;
						color.color.blue = clr->blue() | clr->blue() << 8;
						color.color.alpha = 0xffff;
						color.pixel = clr->pixel();
						XftDrawString8(g_pXftDraw,&color,g_pXftFont,curLeftCoord - 1,
							curBottomCoord - 1,(unsigned char *)(block->block_ptr),block->block_len);
					}

					if(curUnderline)
					{
						//Draw a line under the text block....
						int wdth = block->block_width;
						//FIXME: Must check if width <= 0 or Xft won't underline properly
						if((wdth <= 0)&&(block->block_len > 0))wdth = widgetWidth - (curLeftCoord + KVI_IRCVIEW_HORIZONTAL_BORDER);
						XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curFore]->pixel());
						XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth,LineSolid,CapButt,JoinMiter);
						XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,
							curLeftCoord+wdth,curBottomCoord);
					}
					curLeftCoord += block->block_width;
				} else {
#endif
				// FIXME: We could avoid this XSetForeground if the curFore was not changed....
				XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curFore]->pixel());

				if(curBack != KVI_TRANSPARENT)
				{
					XSetBackground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)curBack]->pixel());
					XDrawImageString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
						curBottomCoord,block->block_ptr,block->block_len);
				} else {
					XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,
						curBottomCoord,block->block_ptr,block->block_len);
				}
				if(curBold)
				{ //Draw doubled font (simulate bold)
					XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord+1,
						curBottomCoord,block->block_ptr,block->block_len);
				}
				if(curLink)
				{
					XSetForeground(g_display,g_ircviewGC,g_pOptions->m_pMircColor[(unsigned char)g_pOptions->m_cViewOutUrlFore]->pixel());
//					XSetFunction(g_display,g_ircviewGC,GXxor);
					XDrawString(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord-1,
						curBottomCoord-1,block->block_ptr,block->block_len);
//					XSetFunction(g_display,g_ircviewGC,GXcopy);
				}
				if(curUnderline)
				{ //Draw a line under the text block....
					int wdth = block->block_width;
					//FIXME: Must check if width <= 0 or non-Xft won't underline properly
					if((wdth <= 0)&&(block->block_len > 0))wdth = widgetWidth - (curLeftCoord + KVI_IRCVIEW_HORIZONTAL_BORDER);
					XSetLineAttributes(g_display,g_ircviewGC,m_iFontLineWidth,LineSolid,CapButt,JoinMiter);
					XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,curLeftCoord,curBottomCoord,
						curLeftCoord+wdth,curBottomCoord);
				}
				curLeftCoord += block->block_width;
#ifdef COMPILE_USE_AA_FONTS
				}
#endif
			}
		}

		if(m_bSelecting && !m_bDoubleClicked){
			if(m_iLastSelectionLineLen > 0){
				if(m_szLastSelection.hasData())m_szLastSelection.prepend("\n");
				m_szLastSelection.prepend(m_szLastSelectionLine.ptr());
				m_szLastSelectionLine = "";
				m_iLastSelectionLineLen = 0;
			}
			if(m_iLastStrippedSelectionLineLen > 0){
				if(m_szLastStrippedSelection.hasData())m_szLastStrippedSelection.prepend("\n");
				m_szLastStrippedSelection.prepend(m_szLastStrippedSelectionLine.ptr());
				m_szLastStrippedSelectionLine = "";
				m_iLastStrippedSelectionLineLen = 0;
			}
		}

		curBottomCoord -= (lineWrapsHeight + m_iFontLineSpacing);
		pCurTextLine    = pCurTextLine->prev_line;
	}

	//Need to draw the sunken rect around the view now...
	XSetLineAttributes(g_display,g_ircviewGC,1,LineSolid,CapButt,JoinMiter); //need this for line size
	XSetForeground(g_display,g_ircviewGC,colorGroup().dark().pixel());
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,0,0,widgetWidth,0);
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,0,0,0,widgetHeight);
	XSetForeground(g_display,g_ircviewGC,colorGroup().light().pixel());
	widgetWidth--;
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,1,widgetHeight-1,widgetWidth,widgetHeight-1);
	XDrawLine(g_display,g_hIrcViewMemBuffer,g_ircviewGC,widgetWidth,1,widgetWidth,widgetHeight);

	// COPY TO THE DISPLAY
	// EVIL XCopyArea... it takes soooo long.
	XCopyArea(g_display,g_hIrcViewMemBuffer,this->handle(),g_ircviewGC,rectLeft,rectTop,rectWidth,rectHeight,rectLeft,rectTop);
}


//============ calculateLineWraps ==============//

void KviIrcView::calculateLineWraps(KviIrcViewTextLine *ptr,int maxWidth)
{
	if(ptr->num_text_blocks != 0)kvi_free(ptr->text_blocks_ptr); // free any previous wrap blocks
	ptr->text_blocks_ptr=(KviIrcViewTextBlock *)kvi_malloc(sizeof(KviIrcViewTextBlock)); // alloc one block
	ptr->max_line_width = maxWidth;                              // calculus for this width
	ptr->num_text_blocks = 0; // it will be ++
	ptr->line_wraps = 0;      // no line wraps yet
	int curAttrBlock=0; //Current attribute block
	int curLineWidth=0;

	// init the first block
	ptr->text_blocks_ptr->block_ptr = ptr->data_ptr;
	ptr->text_blocks_ptr->block_len = 0;
	ptr->text_blocks_ptr->block_width = 0;
	ptr->text_blocks_ptr->attr_ptr  = &(ptr->attr_ptr[0]);

//	int maxBlockLen = ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr->block_len;
	int maxBlockLen = ptr->attr_ptr->block_len; // ptr->attr_ptr[0].block_len

	for(;;){
		//Calculate the block_width
		register char *p=ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr;
//		KviIrcViewTextBlock * blk = ptr->text_blocks_ptr[ptr->num_text_blocks];
		int curBlockLen   = 0;
		int curBlockWidth = 0;
		while(curBlockLen < maxBlockLen){
			curBlockWidth += m_iFontCharacterWidth[((unsigned char)*p)];
			curBlockLen++;
			p++;
		}
		//Check the length
		curLineWidth += curBlockWidth;
		if(curLineWidth < maxWidth){
			//Ok....proceed to next block
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_len   = curBlockLen;
			ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = curBlockWidth;
			curAttrBlock++;
			ptr->num_text_blocks++;
			ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_realloc(ptr->text_blocks_ptr,(ptr->num_text_blocks + 1) * sizeof(KviIrcViewTextBlock));
//			if(ptr->num_text_blocks >= KVI_IRCVIEW_MAX_TEXT_BLOCKS)return ptr->line_wraps;
			//Process the next block of data in the next loop or return if have no more blocks
			if(curAttrBlock < ptr->attr_len){
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr = &(ptr->data_ptr[ptr->attr_ptr[curAttrBlock].block_idx]);
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr  = &(ptr->attr_ptr[curAttrBlock]);
				maxBlockLen = ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr->block_len;
			} else return;
		} else {
			//Need word wrap
			//First go back to a admissible width
			while((curLineWidth >= maxWidth) && curBlockLen){
				p--;
				curBlockLen--;
				curLineWidth-=m_iFontCharacterWidth[((unsigned char)*p)];
			}
			//Now look for a space
			while((*p != ' ') && curBlockLen){ 
				p--;
				curBlockLen--;
				curLineWidth-=m_iFontCharacterWidth[((unsigned char)*p)];
			}
			//If we ran up to the beginning of the block....
			if(curBlockLen == 0){
				//Don't like it....forced wrap here...
				//Go ahead up to the biggest possible string
				do{
					curBlockLen++;
					p++;
					curLineWidth+=m_iFontCharacterWidth[((unsigned char)*p)];
				}while((curLineWidth < maxWidth) && (curBlockLen < maxBlockLen));
				//Now overrunned , go back 1 char
				p--;
				curBlockLen--;
				//K...wrap
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = curBlockLen;
				maxBlockLen-=curBlockLen;
				ptr->num_text_blocks++;
				ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_realloc(ptr->text_blocks_ptr,(ptr->num_text_blocks + 1) * sizeof(KviIrcViewTextBlock));

//				if(ptr->num_text_blocks >= KVI_IRCVIEW_MAX_TEXT_BLOCKS)return ptr->line_wraps;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr = p;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr  = 0;
			} else {
				//found a space...
				//include it in the first block
				p++;
				curBlockLen++;
				//block width is not important; we wrap
				//significate block width
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = curBlockLen;
				maxBlockLen-=curBlockLen;
				ptr->num_text_blocks++;
				ptr->text_blocks_ptr = (KviIrcViewTextBlock *)kvi_realloc(ptr->text_blocks_ptr,(ptr->num_text_blocks + 1) * sizeof(KviIrcViewTextBlock));
//				if(ptr->num_text_blocks >= KVI_IRCVIEW_MAX_TEXT_BLOCKS)return ptr->line_wraps;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_ptr = p;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_len = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].block_width = 0;
				ptr->text_blocks_ptr[ptr->num_text_blocks].attr_ptr  = 0;
			}
			curLineWidth = 0;
			ptr->line_wraps++;
			if(ptr->line_wraps == 1){
				if(g_pOptions->m_bWrapMargin)maxWidth-=m_iWrapMargin;
			}
		}

	}
	ptr->num_text_blocks++;
//	return ptr->line_wraps;
}

//================= calculateSelectionBounds ==================//

void KviIrcView::calculateSelectionBounds()
{
	m_iSelectionTop    = ((m_iMouseButtonPressY < m_iMouseButtonCurrentY) ? m_iMouseButtonPressY : m_iMouseButtonCurrentY);
	m_iSelectionBottom = ((m_iMouseButtonPressY > m_iMouseButtonCurrentY) ? m_iMouseButtonPressY : m_iMouseButtonCurrentY);
	if(m_iMouseButtonPressY < m_iMouseButtonCurrentY){
		m_iSelectionBegin   = m_iMouseButtonPressX;
		m_iSelectionEnd  = m_iMouseButtonCurrentX;
	} else {
		m_iSelectionBegin   = m_iMouseButtonCurrentX;
		m_iSelectionEnd  = m_iMouseButtonPressX;
	}
	m_iSelectionLeft = (m_iSelectionBegin < m_iSelectionEnd) ? m_iSelectionBegin : m_iSelectionEnd;
	m_iSelectionRight = (m_iSelectionBegin > m_iSelectionEnd) ? m_iSelectionBegin : m_iSelectionEnd;

}

//============== checkForDoubleClickedUrlOrEscape =================//

void KviIrcView::checkForDoubleClickedUrlOrEscape(KviIrcViewTextLine * line,int left,int bottom,int bufIndex)
{
	__range_valid(bufIndex >= 0);
	int top = bottom-m_iFontLineSpacing;
	int right  = (line->text_blocks_ptr[bufIndex].block_width ? \
					left+line->text_blocks_ptr[bufIndex].block_width : width()-KVI_IRCVIEW_SCROLLBAR_AND_HORIZONTAL_BORDER_WIDTH);
	if((left < m_iMouseButtonPressX)&&(right > m_iMouseButtonPressX)&&
		(bottom > m_iMouseButtonPressY)&&(top < m_iMouseButtonPressY)){
		//Yeah man! This block clicked...check if it is a part of an url
		if(line->text_blocks_ptr[bufIndex].attr_ptr==0){
			//Could be a word wrapped url...go back until we find a block with attributes
			while((line->text_blocks_ptr[bufIndex].attr_ptr==0)&&(bufIndex > 0))bufIndex--;
		}
		if(bufIndex == 0)return; //Can't be...the first is always a color block
		if(line->text_blocks_ptr[bufIndex].attr_ptr){
			if(line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ESCAPE)
//				(line->text_blocks_ptr[bufIndex].attr_ptr->attribute == KVI_TEXT_ESCAPE_UNDERLINE))
			{
				m_szLastDoubleClickedEscape = KviStr(line->text_blocks_ptr[bufIndex].block_ptr,line->text_blocks_ptr[bufIndex].block_len);
				m_szLastDoubleClickedEscapeCmd = line->text_blocks_ptr[bufIndex].attr_ptr->escape_cmd;
			} else return;
			//Continue while we do not find a non word wrap block block
			for(;;){
				bufIndex++;
				if(bufIndex == line->num_text_blocks)return;
				if(line->text_blocks_ptr[bufIndex].attr_ptr)return; //finished; not a word wrap
				KviStr szBlockData(line->text_blocks_ptr[bufIndex].block_ptr,line->text_blocks_ptr[bufIndex].block_len);
				m_szLastDoubleClickedEscape.append(szBlockData.ptr());
			}
		}
	}
}

//=============== checkSelectionBlock ===============//

bool KviIrcView::checkSelectionBlock(KviIrcViewTextLine * line,int left,int bottom,int bufIndex)
{
	register char *p=line->text_blocks_ptr[bufIndex].block_ptr;
	int top = bottom-m_iFontLineSpacing;
	int right  = (line->text_blocks_ptr[bufIndex].block_width ? \
					left+line->text_blocks_ptr[bufIndex].block_width : width()-KVI_IRCVIEW_SCROLLBAR_AND_HORIZONTAL_BORDER_WIDTH);
	if(bottom < m_iSelectionTop   )return false; //The selection starts under this line
	if(top    > m_iSelectionBottom)return false; //The selection ends over this line
	if((top    >= m_iSelectionTop)&&(bottom < m_iSelectionBottom)){
		//Whole line selected
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
		return true;
	}
	if((top    < m_iSelectionTop)&&(bottom >= m_iSelectionBottom)){
		//Selection begins and ends in this line
		if(right < m_iSelectionLeft)return false;
		if(left  > m_iSelectionRight)return false;
		if((right <= m_iSelectionRight) && (left > m_iSelectionLeft)){
			//Whole line selected
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
			return true;
		}
		if((right > m_iSelectionRight) && (left <= m_iSelectionLeft)){
			//Selection ends and begins in THIS BLOCK!
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_CENTRAL;
			m_TextBlockSelectionInfo.part_1_length = 0;
			m_TextBlockSelectionInfo.part_1_width  = 0;
			while((left <= m_iSelectionLeft) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len)){
				left += m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
				p++;
				m_TextBlockSelectionInfo.part_1_length++;
			}
			//Need to include the first character
			if(m_TextBlockSelectionInfo.part_1_length > 0){
				m_TextBlockSelectionInfo.part_1_length--;
				p--;
				left -= m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_1_width-=m_iFontCharacterWidth[(unsigned char) *p];
			}
			int maxLenNow = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
			int maxWidthNow = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
			m_TextBlockSelectionInfo.part_2_length = 0;
			m_TextBlockSelectionInfo.part_2_width  = 0;
			while((left < m_iSelectionRight) && (m_TextBlockSelectionInfo.part_2_length < maxLenNow)){
				left += m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_2_width+=m_iFontCharacterWidth[(unsigned char) *p];
				p++;
				m_TextBlockSelectionInfo.part_2_length++;
			}		
			m_TextBlockSelectionInfo.part_3_length = maxLenNow-m_TextBlockSelectionInfo.part_2_length;
			m_TextBlockSelectionInfo.part_3_width  = maxWidthNow-m_TextBlockSelectionInfo.part_2_width;
			return true;
		}
		if(right > m_iSelectionRight){
			//Selection ends in THIS BLOCK!
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_LEFT;
			m_TextBlockSelectionInfo.part_1_length = 0;
			m_TextBlockSelectionInfo.part_1_width  = 0;
			while((left < m_iSelectionRight) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len)){
				left += m_iFontCharacterWidth[(unsigned char) *p];
				m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
				p++;
				m_TextBlockSelectionInfo.part_1_length++;
			}
			m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
			m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
			return true;
		}
		//Selection begins in THIS BLOCK!
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_RIGHT;
		m_TextBlockSelectionInfo.part_1_length = 0;
		m_TextBlockSelectionInfo.part_1_width  = 0;
		while((left <= m_iSelectionLeft) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len)){
			left += m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
			p++;
			m_TextBlockSelectionInfo.part_1_length++;
		}
		//Need to include the first character
		if(m_TextBlockSelectionInfo.part_1_length > 0){
			m_TextBlockSelectionInfo.part_1_length--;
			p--;
			left -= m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width-=m_iFontCharacterWidth[(unsigned char) *p];
		}
		m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
		m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
		return true;
	}

	if(top < m_iSelectionTop){
		//Selection starts in this line
		if(right < m_iSelectionBegin)return false;
		if(left > m_iSelectionBegin){
			//Whole block selected
			m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
			return true;
		}
		//Selection begins in THIS BLOCK!
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_RIGHT;
		m_TextBlockSelectionInfo.part_1_length = 0;
		m_TextBlockSelectionInfo.part_1_width  = 0;
		while((left <= m_iSelectionBegin) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len)){
			left += m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
			p++;
			m_TextBlockSelectionInfo.part_1_length++;
		}
		//Need to include the first character
		if(m_TextBlockSelectionInfo.part_1_length > 0){
			m_TextBlockSelectionInfo.part_1_length--;
			p--;
			left -= m_iFontCharacterWidth[(unsigned char) *p];
			m_TextBlockSelectionInfo.part_1_width-=m_iFontCharacterWidth[(unsigned char) *p];
		}
		m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
		m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
		return true;
	}
	//Selection ends in this line
	if(left  > m_iSelectionEnd)return false;
	if(right < m_iSelectionEnd){
		//Whole block selected
		m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_TOTAL;
		return true;
	}
	//Selection ends in THIS BLOCK!
	m_TextBlockSelectionInfo.selection_type = KVI_IRCVIEW_BLOCK_SELECTION_LEFT;
	m_TextBlockSelectionInfo.part_1_length = 0;
	m_TextBlockSelectionInfo.part_1_width  = 0;
	while((left < m_iSelectionEnd) && (m_TextBlockSelectionInfo.part_1_length < line->text_blocks_ptr[bufIndex].block_len)){
		left += m_iFontCharacterWidth[(unsigned char) *p];
		m_TextBlockSelectionInfo.part_1_width+=m_iFontCharacterWidth[(unsigned char) *p];
		p++;
		m_TextBlockSelectionInfo.part_1_length++;
	}
	m_TextBlockSelectionInfo.part_2_length = line->text_blocks_ptr[bufIndex].block_len-m_TextBlockSelectionInfo.part_1_length;
	m_TextBlockSelectionInfo.part_2_width  = line->text_blocks_ptr[bufIndex].block_width-m_TextBlockSelectionInfo.part_1_width;
	return true;
}

//============ recalcFontVariables ==============//

void KviIrcView::recalcFontVariables(const QFont &fnt)
{
	QFontMetrics fm(fnt);
	m_iFontLineSpacing = fm.lineSpacing();
	if(m_iFontLineSpacing < 16)m_iFontLineSpacing = 16;
	m_iFontDescent     =fm.descent();
	m_iFontLineWidth   =fm.lineWidth();
	if(m_iFontLineWidth==0)m_iFontLineWidth=1;
	m_iWrapMargin = fm.width("wwww");
	for(int i=0;i<256;i++)m_iFontCharacterWidth[i]=fm.width((char)i);
}

//================ resizeEvent ===============//

void KviIrcView::resizeMemBuffer()
{
	// check if we can make the mem buffer a bit smaller (save some memory)
	int maxw = 16;
	int maxh = 16;
	for(KviIrcView *i=g_pIrcViewWidgetList->first();i;i=g_pIrcViewWidgetList->next()){
		if((i->width() - KVI_IRCVIEW_SCROLLBAR_WIDTH) > maxw)maxw = i->width() - KVI_IRCVIEW_SCROLLBAR_WIDTH;
		if(i->height() > maxh)maxh = i->height();
	}
	if((maxw != g_pIrcViewMemBuffer->width())||(maxh != g_pIrcViewMemBuffer->height())){
		g_pIrcViewMemBuffer->resize(maxw,maxh);
		g_hIrcViewMemBuffer = g_pIrcViewMemBuffer->handle(); // Qt may change it while resizing
	}

	// Ok....mem buffer is big enough for all the irc views alive
}

void KviIrcView::resizeEvent(QResizeEvent *)
{
	resizeMemBuffer();
	m_pScrollBar->setGeometry(width()-KVI_IRCVIEW_SCROLLBAR_WIDTH,0,KVI_IRCVIEW_SCROLLBAR_WIDTH,height());
}

//================ mousePressEvent ================//

void KviIrcView::mousePressEvent(QMouseEvent *e)
{
	m_iMouseButtonPressX=e->pos().x();
	m_iMouseButtonPressY=e->pos().y();
	m_iMouseButtonCurrentX=m_iMouseButtonPressX;
	m_iMouseButtonCurrentY=m_iMouseButtonPressY;
	if(e->button() & LeftButton){
		m_bSelecting=true;
		if(m_pKviWindow && (m_pKviWindow->type() == KVI_WND_TYPE_CHANNEL)){
			m_bDoubleClicked = true;
			paintEvent(0);
			m_bDoubleClicked = false;
			if(m_szLastDoubleClickedEscape.hasData() && m_pKviWindow->m_pListBox->findUser(m_szLastDoubleClickedEscape.ptr())){
//				int item = m_pKviWindow->m_pListBox->findUserPosition(m_szLastDoubleClickedEscape.ptr());
//				m_pKviWindow->output(1,__tr("WARNING: m_szLastDoubleClickedEscape.ptr() is %s, m_szLastDoubleClickedEscapeCmd.ptr() is %s, and item is %d"),m_szLastDoubleClickedEscape.ptr(),m_szLastDoubleClickedEscapeCmd.ptr(),item);
//				if (item > -1){
				m_pKviWindow->m_pListBox->deselectAll();
				m_pKviWindow->m_pListBox->select(m_szLastDoubleClickedEscape.ptr());
//				}
			}
		}
	}
	else if(e->button() & RightButton){

//		m_iMouseButtonPressX=e->pos().x();
//		m_iMouseButtonPressY=e->pos().y();

		m_bSelecting = true;
		m_bDoubleClicked = true;
		paintEvent(0);
		m_bDoubleClicked = false;
		m_bSelecting = false;
		KviStr tmp;
		getRightClickCommand(tmp,m_szLastDoubleClickedEscapeCmd.ptr());
		if(tmp.isEmpty())
		{
			// NO LINK UNDER MOUSE
			if(e->state() & ControlButton)m_pFrm->windowPopupRequested(this,m_pKviWindow);
			else emit contextPopupRequested(this);
		} else {
			if(m_pFrm && m_pKviWindow)m_pFrm->m_pUserParser->parseCommand(tmp.ptr(),m_pKviWindow,m_szLastDoubleClickedEscape.ptr());
		}

	} else if(e->button() & MidButton)m_pFrm->windowPopupRequested(this,m_pKviWindow);
}

//================ mouseReleaseEvent ===============//

void KviIrcView::mouseReleaseEvent(QMouseEvent *e)
{
	if(m_iSelectTimer){
		killTimer(m_iSelectTimer);
		m_iSelectTimer = 0;
		if(e->state() & ShiftButton)
			m_pFrm->ircViewTextSelected(this,m_pKviWindow,m_szLastStrippedSelection.ptr());
		else m_pFrm->ircViewTextSelected(this,m_pKviWindow,m_szLastSelection.ptr());
	}
	if(m_bSelecting){
		m_bSelecting=false;
		// Insert the lines blocked while selecting
		while(KviIrcViewTextLine * l = m_pMessagesStoppedWhileSelecting->first())
		{
			m_pMessagesStoppedWhileSelecting->removeFirst();
			appendLine(l,false);
		}

		paintEvent(0);
	}
}

void KviIrcView::findNext(const char * text)
{
	KviIrcViewTextLine * l = m_pCurLine;
	int curScr = m_pScrollBar->value();
	if(l){
		curScr++;
		l = l->next_line;
		if(!l){
			l = m_pFirstLine;
			curScr = 1;
		}
		KviIrcViewTextLine * start = l;
	
		do{
			__range_valid(l->data_ptr);
			KviStr tmp = l->data_ptr;
			int idx = tmp.findFirstIdx(text,false);
			if(idx != -1)
			{
				m_pScrollBar->setValue(curScr); // found
				return;
			}
			l = l->next_line;
			curScr++;
			if(!l){
				l = m_pFirstLine;
				curScr = 1;
			}
		} while(l != start);
	}

	QMessageBox::warning(this,_CHAR_2_QSTRING(__tr("Find")),_CHAR_2_QSTRING(__tr("Text not found")),QMessageBox::Ok | QMessageBox::Default,0);
}

void KviIrcView::findPrev(const char * text)
{
	KviIrcViewTextLine * l = m_pCurLine;
	int curScr = m_pScrollBar->value();
	if(l){
		curScr--;
		l = l->prev_line;
		if(!l){
			l = m_pLastLine;
			curScr = m_iNumLines;
		}
		KviIrcViewTextLine * start = l;
	
		do{
			__range_valid(l->data_ptr);
			KviStr tmp = l->data_ptr;
			int idx = tmp.findFirstIdx(text,false);
			if(idx != -1)
			{
				m_pScrollBar->setValue(curScr); // found
				return;
			}
			l = l->prev_line;
			curScr--;
			if(!l){
				l = m_pLastLine;
				curScr = m_iNumLines;
			}
		} while(l != start);
	}

	QMessageBox::warning(this,_CHAR_2_QSTRING(__tr("Find")),_CHAR_2_QSTRING(__tr("Text not found")),QMessageBox::Ok | QMessageBox::Default,0);

}

KviIrcViewTextBlock * KviIrcView::getLinkUnderMouse(int xPos,int yPos,int *rectTop,int *rectHeight)
{
	KviIrcViewTextLine * l = m_pCurLine;
	int iTop = height() - KVI_IRCVIEW_VERTICAL_BORDER;

	while(iTop > yPos)
	{
		if(l)
		{
			iTop -= ((l->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
			if(iTop <= yPos)
			{
				// got the right KviIrcViewTextLine
				int iLeft = KVI_IRCVIEW_HORIZONTAL_BORDER;
				if(m_bShowImages)iLeft += KVI_IRCVIEW_PIXMAP_AND_SEPARATOR;
				int firstRowTop = iTop;
				int i = 0;

				for(;;)
				{
					if(yPos <= iTop + m_iFontLineSpacing)
					{
						// this row!!!
						if(iTop != firstRowTop)if(g_pOptions->m_bWrapMargin)iLeft+=m_iWrapMargin;
						if(xPos < iLeft)return 0;
						for(;;)
						{
							if(i >= l->num_text_blocks)return 0;
							if(l->text_blocks_ptr[i].block_width)iLeft += l->text_blocks_ptr[i].block_width;
							else {
								if(i < (l->num_text_blocks - 1))
								{
									// There is another block...
									// Check if it is a wrap...
									if(l->text_blocks_ptr[i+1].attr_ptr == 0)iLeft = width();
									// else simply a zero characters block
								}
							}
							if(i < 0)return 0; // word wrap block; no link here!
							if(xPos < iLeft)
							{
								// Got it!
								// link ?
								bool bHadWordWraps = false;
								while(l->text_blocks_ptr[i].attr_ptr == 0)
								{
									// word wrap ?
									if(i >= 0)
									{
										i--;
										bHadWordWraps = true;
									} else return 0; // all word wraps ?!!!
								}
								if(l->text_blocks_ptr[i].attr_ptr->attribute == KVI_TEXT_ESCAPE)
								{
									*rectTop = bHadWordWraps ? firstRowTop : iTop;
									*rectHeight = ((l->line_wraps + 1) * m_iFontLineSpacing) + m_iFontDescent;
									return &(l->text_blocks_ptr[i]);
								}
								return 0;
							}
							i++;
						}
					} else {
						// run until a word wrap block
						i++; //at least one block!
						while(i < l->num_text_blocks)
						{
							// still ok to run right
							if(l->text_blocks_ptr[i].attr_ptr == 0)
							{
//								i++;
								break;
							} else i++;
						}
						if(i >= l->num_text_blocks)return 0;
						iTop += m_iFontLineSpacing;
					}
				}
			} else l = l->prev_line;
		} else return 0;
	}
	return 0;
}


void KviIrcView::mouseMoveEvent(QMouseEvent *e)
{
//	debug("Pos : %d,%d",e->pos().x(),e->pos().y());
	if(m_bSelecting){
		//height() - KVI_IRCVIEW_VERTICAL_BORDER;
		if(m_iSelectTimer == 0)m_iSelectTimer = startTimer(KVI_IRCVIEW_SELECT_REPAINT_INTERVAL);
/*		if(yPos > height()){
			nextLine();
			m_iSelectionBottom-(m_iFontDescent-m_iFontLineSpacing);
		}
		else if(yPos < 0){
			prevLine();
			m_iSelectionTop+(m_iFontDescent-m_iFontLineSpacing);
		}*/
	} else {
		if(m_iSelectTimer){
			killTimer(m_iSelectTimer);
			m_iSelectTimer = 0;
		}
		int yPos = e->pos().y();
		int rectTop;
		int rectHeight;
		KviIrcViewTextBlock * newLinkUnderMouse = getLinkUnderMouse(e->pos().x(),yPos,&rectTop,&rectHeight);
		if(newLinkUnderMouse != m_pLastLinkUnderMouse)
		{
			m_pLastLinkUnderMouse = newLinkUnderMouse;
			if(m_pLastLinkUnderMouse)
			{
				KviStr dbl,rght;
				getDoubleClickCommand(dbl,m_pLastLinkUnderMouse->attr_ptr->escape_cmd);
				getRightClickCommand(rght,m_pLastLinkUnderMouse->attr_ptr->escape_cmd);
				KviStr tmp(KviStr::Format,__tr("Link: Double-click: \"%s\" Right click: \"%s\""),
					dbl.ptr(),rght.ptr());
				m_pFrm->m_pStatusBar->tempText(tmp.ptr(),5000);

				if(rectTop < 0)rectTop = 0;
				if((rectTop + rectHeight) > height())rectHeight = height() - rectTop;

				if(m_iLastLinkRectHeight > -1)
				{
					// prev link
					int top = (rectTop < m_iLastLinkRectTop) ? rectTop : m_iLastLinkRectTop;
					int lastBottom = m_iLastLinkRectTop + m_iLastLinkRectHeight;
					int thisBottom = rectTop + rectHeight;
					QRect r(0,top,width(),((lastBottom > thisBottom) ? lastBottom : thisBottom) - top);
					QPaintEvent * pev = new QPaintEvent(r);
					paintEvent(pev);
					delete pev;
				} else {
					// no prev link
					QRect r(0,rectTop,width(),rectHeight);
					QPaintEvent * pev = new QPaintEvent(r);
					paintEvent(pev);
					delete pev;
				}
				m_iLastLinkRectTop = rectTop;
				m_iLastLinkRectHeight = rectHeight;
			} else {
				if(m_iLastLinkRectHeight > -1)
				{
					// There was a previous bottom rect
					QRect r(0,m_iLastLinkRectTop,width(),m_iLastLinkRectHeight);
					QPaintEvent * pev = new QPaintEvent(r);
					paintEvent(pev);
					delete pev;
					m_iLastLinkRectTop = -1;
					m_iLastLinkRectHeight = -1;
				}
			}

		}
	}
}

//=============== timerEvent ===============//

void KviIrcView::timerEvent(QTimerEvent *e)
{
	if(e->timerId() == m_iSelectTimer){
		QPoint pnt = mapFromGlobal(QCursor::pos());
		m_iMouseButtonCurrentX=pnt.x();
		m_iMouseButtonCurrentY=pnt.y();
		calculateSelectionBounds();
		paintEvent(0);
	}
}

//============= mouseDoubleClickEvent ===============//

void KviIrcView::mouseDoubleClickEvent(QMouseEvent *e)
{
	m_iMouseButtonPressX=e->pos().x();
	m_iMouseButtonPressY=e->pos().y();

	m_bSelecting = true;
	m_bDoubleClicked = true;
	paintEvent(0);
	m_bDoubleClicked = false;
	m_bSelecting = false;
	if(m_szLastDoubleClickedEscapeCmd.isEmpty())return;
	KviStr tmp;
	getDoubleClickCommand(tmp,m_szLastDoubleClickedEscapeCmd.ptr());
	if(tmp.isEmpty())return;
	if(m_pFrm && m_pKviWindow)m_pFrm->m_pUserParser->parseCommand(tmp.ptr(),m_pKviWindow,m_szLastDoubleClickedEscape.ptr());
}

//=============== fontChange ================//

void KviIrcView::fontChange(const QFont &oldFont)
{
	//Do not update
	recalcFontVariables(font());
	// force to recalculate all the wraps in the next repaint
	KviIrcViewTextLine * l = m_pFirstLine;
	while(l){
		l->max_line_width = -1;
		l = l->next_line;
	}
}

#include "m_kvi_ircview.moc"
