//
//   File : kvi_translate.cpp
//   Creation date : Fri May 26 2000 22:32:45 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//
// Many parts of this source code were 'inspired' by the ircII4.4 translat.c source.
//

#include <stdio.h>

#include "kvi_translate.h"

#include <qfile.h>

#ifdef COMPILE_NEED_CHARSET_TRANSLATION

//============ KviTranslator ============//

KviCharsetTranslator::KviCharsetTranslator()
{
}

//============ ~KviTranslator ============//

KviCharsetTranslator::~KviCharsetTranslator()
{
}

//============ setTranslationMap ============//

bool KviCharsetTranslator::setTranslationMap(const char *szMapFileName,bool bTestOnly)
{
	QFile mapFile(szMapFileName);

	if(!(mapFile.exists() && mapFile.open(IO_ReadOnly)) ){
		debug("Can't open the translation file for reading.");
		return false;
	}

	// translat.c :
	// Any problems in the translation tables between hosts are
	// almost certain to be caused here.
	// many scanf implementations do not work as defined. In particular,
	// scanf should ignore white space including new lines (many stop
	// at the new line character, hence the fgets and sscanf workaround),
	// many fail to read 0xab as a hexadecimal number (failing on the
	// x) despite the 0x being defined as optionally existing on input,
	// and others zero out all the output variables if there is trailing
	// non white space in the format string which doesn't appear on the
	// input. Overall, the standard I/O libraries have a tendancy not
	// to be very standard.

	char buffer[80];
	int inputs[8];
	unsigned char temp_table[512];
	int c=0;

	while((mapFile.readLine(buffer,80)>0)&&(c<512)){
		if(
				sscanf(buffer, "0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x,0x%x",
		    		inputs+0, inputs+1, inputs+2, inputs+3,
		    		inputs+4, inputs+5, inputs+6, inputs+7)   <8
		) {
			debug("Syntax error in translation file.");
			mapFile.close();
			return false;
		}
		for (int j = 0; j<8; j++)temp_table[c++] = (unsigned char) inputs[j];
	}

	mapFile.close();

	if(c==512){
		if(!bTestOnly)
		{
			for (c = 0; c < 256; c++)
			{
				serverToClientTab[c] = temp_table[c];
				clientToServerTab[c] = temp_table[c | 256];
			}
		}
	} else {
		debug("Translation file corrupted.");
		return false;
	}
	return true;
}

//============ translateToClient ============//

void KviCharsetTranslator::translateToClient(char * pC)
{
	while(*pC){
		(*pC)=serverToClientTab[(unsigned char)(*pC)];
		pC++;
	}
}

//============ translateToServer ============//

void KviCharsetTranslator::translateToServer(char * pC,int len)
{
	while(len){
		(*pC)=clientToServerTab[(unsigned char)(*pC)];
		len--;
		pC++;
	}
}

#endif

