#ifndef _KVI_THREAD_H_INCLUDED_
#define _KVI_THREAD_H_INCLUDED_

//
//   File : kvi_thread.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_thread.h)
//   Last major modification : Mon May 17 1999 04:26:41 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <pthread.h>


#include <qsocketnotifier.h>
#include <qlist.h>
#include <qobject.h>
#include <qevent.h>

#include "kvi_string.h"

typedef struct KviThreadEventStruct
{
	QEvent * pEvent;
	QObject * pReceiver;
};

#define KVI_DCC_EVENT_ERROR 1
#define KVI_DCC_EVENT_MSG 2
#define KVI_DCC_EVENT_DATA 3
#define KVI_DCC_EVENT_LISTENING 4
#define KVI_DCC_EVENT_DCCSENDSTATUS 5
#define KVI_DCC_EVENT_FINISHED 6
#define KVI_DCC_EVENT_ENABLETALK 7
#define KVI_DCC_EVENT_DISABLETALK 8
#define KVI_DCC_EVENT_BUFFEREDTIME 9
#define KVI_DCC_EVENT_CONNECTIONESTABILISHED 10

class KviDccEvent : public QEvent
{
public:
	KviDccEvent(int type,const char * data);
	~KviDccEvent();
public:
	KviStr m_dataString;
	int m_type;
	int m_param;
};

class KviThreadEventDispatcher : public QObject
{
	Q_OBJECT
public:
	KviThreadEventDispatcher();
	~KviThreadEventDispatcher();
public:
	pthread_mutex_t m_mutex;
	int m_pipe[2];
	QSocketNotifier *m_pSn;
	QList<QObject> *m_pReceiverList;
	QList<KviThreadEventStruct> *m_pEventList;
public:
	void registerObject(QObject * o);
	void unregisterObject(QObject * o);
	void postEvent(QEvent * e,QObject * r);
protected slots:
	void socketNotifierFired(int fd);
};

#define kvi_threadMutexLock(pMutex) pthread_mutex_lock(pMutex)
#define kvi_threadMutexUnlock(pMutex) pthread_mutex_unlock(pMutex)
#define kvi_threadMutexInit(pMutex,attr) pthread_mutex_init(pMutex,attr)
#define kvi_threadMutexDestroy(pMutex) pthread_mutex_destroy(pMutex)

#define kvi_threadCancel(thread) pthread_cancel(thread)
#define kvi_threadTestCancel pthread_testcancel

#define kvi_threadCleanupPush(function,data) pthread_cleanup_push(function,data)
#define kvi_threadCleanupPop(arg) pthread_cleanup_pop(arg)

#define kvi_threadExit(arg) pthread_exit(arg)

#define kvi_threadCreate(pThread,pAttr,pFunction,pArgs) pthread_create(pThread,pAttr,pFunction,pArgs)

#ifndef _KVI_THREAD_CPP_
	extern void kvi_threadInitialize();
#endif

#endif //!_KVI_THREAD_H_INCLUDED_
