//
//   File : kvi_mdibutton.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_mdibutton.cpp)
//   Last major modification : Sat Mar 27 1999 13:42:50 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_mdibutton.h"
#include <qpainter.h>


//////////////////////////////////////////////////////////////////////////////
// Class   : KdeMdiCaptionButton
// Purpose : A system button for the Mdi manager
//           Has 4 types : Maximize,Minimize,Close and Restore
//////////////////////////////////////////////////////////////////////////////

//============ KdeMdiCaptionButton ============//

KviMdiCaptionButton::KviMdiCaptionButton(QWidget *parent,MdiButtonType type,const char * name):
QFrame(parent,name)
{
	m_type       = type;
	m_bHighlight = false;
	m_bPressed   = false;
	setFrameStyle(QFrame::Panel|QFrame::Raised);
	setFocusPolicy(ClickFocus); //Huh ?
}

//============ ~KdeMdiCaptionButton ============//

KviMdiCaptionButton::~KviMdiCaptionButton()
{
}

//============ enterEvent ============//

void KviMdiCaptionButton::enterEvent(QEvent *)
{
	if(!isEnabled())return;
	m_bHighlight=true;
	repaint(false);
}

//============ leaveEvent ============//

void KviMdiCaptionButton::leaveEvent(QEvent *)
{
	if(!isEnabled())return;
	m_bHighlight=false;
	if(m_bPressed){
		m_bPressed=false;
		setFrameStyle(QFrame::Panel|QFrame::Raised);
	}
	repaint(false);
}

//============ setType ============//

void KviMdiCaptionButton::setType(MdiButtonType type)
{
	m_type=type;
	repaint(false);
}

//============ mousePressEvent ============//

void KviMdiCaptionButton::mousePressEvent(QMouseEvent *)
{
	if(!isEnabled())return;
	m_bPressed=true;
	setFrameStyle(QFrame::Panel|QFrame::Sunken);
	repaint(false);	
}

//============ mouseReleaseEvent ============//

void KviMdiCaptionButton::mouseReleaseEvent(QMouseEvent *e)
{
	if(!isEnabled())return;
	m_bPressed=false;
	setFrameStyle(QFrame::Panel|QFrame::Raised);
	repaint(false);
	if((e->x() >= 0) && (e->x() <= width()) &&
		(e->y() >= 0) && (e->y() <= height()))emit buttonPressed();
}

//============ drawContents ============//

void KviMdiCaptionButton::drawContents(QPainter *p)
{
	QRect rct=contentsRect();
	if(!isEnabled())p->setPen(darkGray);
	else if(m_bHighlight)p->setPen(red);
	else p->setPen(black);
	int l=rct.left()+2;
	int r=rct.right()-2;
	int t=rct.top()+2;
	int b=rct.bottom()-2;
	switch(m_type){
		case Close:
			p->drawLine(l,t,b,r);
			p->drawLine(l,t+1,b-1,r);
			p->drawLine(l+1,t,b,r-1);
			p->drawLine(l,b,r,t);
			p->drawLine(l,b-1,r-1,t);
			p->drawLine(l+1,b,r,t+1);
		break;
		case Maximize:
			{
				int wdth=(r-l);
				bool odd=((wdth % 2)==0);
				int lt=l+(wdth/2);
				int rt=(odd ? lt : lt+1);
				int tt=t;
				while(lt >= l){
					p->drawLine(lt,tt,rt,tt);
					lt--; rt++; tt++;
				}
				lt++; rt--; tt++;
				p->drawLine(lt,tt,rt,tt);
				tt++;
				p->drawLine(lt,tt,rt,tt);
			}
		break;
		case Minimize:
			{
				int wdth=(r-l);
				bool odd=((wdth % 2)==0);
				int lt=l+(wdth/2);
				int rt=(odd ? lt : lt+1);
				int bt=b;
				while(lt >= l){
					p->drawLine(lt,bt,rt,bt);
					lt--;
					rt++;
					bt--;
				}
				lt++;
				rt--;
				bt--;
				p->drawLine(lt,bt,rt,bt);
				bt--;
				p->drawLine(lt,bt,rt,bt);
			}
		break;
		case Restore:
			{
				int wdth=(r-l);
				bool odd=((wdth % 2)==0);
				int lt=l+(wdth/2);
				int rt=(odd ? lt : lt+1);
				int bt=b;
				while(lt > l){
					p->drawLine(lt,bt,rt,bt);
					lt--;
					rt++;
					bt--;
				}
				lt=l+(wdth/2);
				rt=(odd ? lt+1 : lt+1);
				int tt=t;
				while(lt > l){
					p->drawLine(lt,tt,rt,tt);
					lt--;
					rt++;
					tt++;
				}
			}
		break;
	}
}

#include "m_kvi_mdibutton.moc"
