//
//   File : kvi_colordialog.cpp (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_colordialog.cpp)
//   Last major modification : Sun Mar 21 1999 19:20:16 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_COLORDIALOG_CPP_

#include "kvi_colordialog.h"

#ifndef COMPILE_WITH_KDE

	#include <qcolordialog.h>


	bool kvi_selectColor(QColor &clr)
	{
		QColor c = QColorDialog::getColor(clr);
		if(c.isValid()){
			clr = c;
			return true;
		}
		return false;
	}
	
#else // COMPILE_WITH_KDE

	#include <kcolordlg.h>

	// KDE compilation...use the standard KDE dialog
	bool kvi_selectColor(QColor &clr)
	{
		return (KColorDialog::getColor(clr) == KColorDialog::Accepted);
	}

#endif
