//
//   File : kvi_netutlis.cpp (/usr/build/NEW_kvirc/kvirc/kvicore/kvi_netutlis.cpp)
//   Last major modification : Mon Jan 11 1999 21:07:07 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#define _KVI_NETUTILS_CPP_

#include "kvi_netutils.h"

//Check for inet aton
#ifndef HAVE_INET_ATON
	#ifndef COMPILE_NEED_OWN_INET_ATON
		#define COMPILE_NEED_OWN_INET_ATON
	#endif
#endif


#ifdef COMPILE_NEED_OWN_INET_ATON


#warning "Your system lacks the inet_aton function,"
#warning "you're trying to compile this file without"
#warning "the config.h created by the configure script,"
#warning "or you have passed the --with-own-inet-aton"
#warning "option to ./configure."
#warning "Using own internal implementation of inet_aton."

#include <ctype.h>

// Need own inet_aton implementation

// 
// Check whether "cp" is a valid ascii representation
// of an Internet address and convert to a binary address.
// Returns 1 if the address is valid, 0 if not.
// This replaces inet_addr, the return value from which
// cannot distinguish between failure and a local broadcast address.
//
// Original code comes from the ircd source.
//

bool kvi_stringIpToBinaryIp(const char *szIp,struct in_addr *address)
{
	register unsigned long val;
	register int base, n;
	register char c;
	unsigned int parts[4];
	register unsigned int *pp = parts;
	c = *szIp;
	for(;;){
		// Collect number up to ``.''.
		// Values are specified as for C:
		// 0x=hex, 0=octal, isdigit=decimal.
		if(!isdigit(c))return false;
		val  = 0;
		base = 10;
		if(c == '0'){
			c = *++szIp;
			if((c == 'x')||(c == 'X'))base = 16, c = *++szIp;
			else base = 8;
		}
		for (;;) {
			if(isascii(c) && isdigit(c)) {
				val = (val * base) + (c - '0');
				c   = *++szIp;
			} else if (base == 16 && isascii(c) && isxdigit(c)) {
				val = (val << 4) | (c + 10 - (islower(c) ? 'a' : 'A'));
				c   = *++szIp;
			} else break;
		}
		if(c == '.'){
			// Internet format:
			//	a.b.c.d
			//	a.b.c	(with c treated as 16 bits)
			//	a.b	(with b treated as 24 bits)
			if(pp >= (parts + 3)) return false;
			*pp++ = val;
			c     = *++szIp;
		} else break;
	}
	// Check for trailing characters.
	if ((c != '\0') && (!isascii(c) || !isspace(c)))return false;
	// Concact the address according to
	// the number of parts specified.
	n = pp - parts + 1;
	switch (n) {
	case 0: return false; // initial nondigit
	case 1:	break;        // a -- 32 bits 
	case 2:               // a.b -- 8.24 bits
		if(val > 0xffffff) return false;
		val |= parts[0] << 24;
		break;
	case 3:               // a.b.c -- 8.8.16 bits
		if(val > 0xffff)return false;
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;
	case 4:               // a.b.c.d -- 8.8.8.8 bits
		if(val > 0xff)return false;
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	if(address)address->s_addr = htonl(val);
	return true;
}

#else //!COMPILE_NEED_OWN_INET_ATON

bool kvi_stringIpToBinaryIp(const char *szIp,struct in_addr *address)
{
	return (inet_aton(szIp,address) != 0);
}

#endif //!COMPILE_NEED_OWN_INET_ATON


#ifndef HAVE_INET_NTOA
	#ifndef COMPILE_NEED_OWN_INET_NTOA
		#define COMPILE_NEED_OWN_INET_NTOA
	#endif
#endif

#ifdef COMPILE_NEED_OWN_INET_NTOA

#warning "Your system lacks the inet_ntoa function,"
#warning "you're trying to compile this file without"
#warning "the config.h created by the configure script,"
#warning "or you have passed the --with-own-inet-ntoa"
#warning "option to ./configure."
#warning "Using own internal implementation of inet_ntoa."

//
// Original code comes from the ircd source.
//

bool kvi_binaryIpToString(struct in_addr in,KviStr &szBuffer)
{
	unsigned char *s = (unsigned char *)&in;
	int	a,b,c,d;
	a = (int)*s++;
	b = (int)*s++;
	c = (int)*s++;
	d = (int)*s;
	szBuffer.sprintf("%d.%d.%d.%d", a,b,c,d );
	return true;
}

#else //COMPILE_NEED_OWN_INET_NTOA

bool kvi_binaryIpToString(struct in_addr in,KviStr &szBuffer)
{
	char * ptr = inet_ntoa(in);
	if(!ptr)return false;
	szBuffer = ptr;
	return true;
}

#endif //COMPILE_NEED_OWN_INET_NTOA

bool kvi_isValidStringIp(const char *szIp)
{
	struct in_addr address;
	if(!isdigit(*szIp))return false;
	return kvi_stringIpToBinaryIp(szIp,&address);
}


#ifdef COMPILE_NEED_IPV6

bool kvi_isValidStringIp_V6(const char *szIp)
{
	struct in6_addr address;
	return (inet_pton(AF_INET6,szIp,(void *)&address) == 1);
}

bool kvi_stringIpToBinaryIp_V6(const char *szIp,struct in6_addr *address)
{
	return (inet_pton(AF_INET6,szIp,(void *)address) == 1);	
}

bool kvi_binaryIpToString_V6(struct in6_addr in,KviStr &szBuffer)
{
	char buf[46];
	bool bRet =  inet_ntop(AF_INET6,(void *)&in,buf,46);
	szBuffer= buf;
	return bRet;
}


#endif
