/***************************************************************************
                          stuff.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stuff.h"
#include "qdir.h"
#include "qfile.h"
#include "qstringlist.h"
#include <arts/artsflow.h>
#include <arts/connect.h>
#include <arts/iomanager.h>
#include <arts/referenceclean.h>
#include <iostream.h>
#include <string>
#include <klocale.h>

#ifndef DONT_LOAD_ARTS

void sinus_wave(double frequency) {
	using namespace Arts;
	StdIOManager* limiter = new StdIOManager;
	Dispatcher dispatcher(limiter);
	MyTimeNotify* zeit = new MyTimeNotify(&dispatcher);
	Synth_FREQUENCY freq;
	Synth_WAVE_SIN sin;
	Synth_PLAY play;
	setValue(freq, frequency);
	connect(freq,sin);
	connect(sin, play, "invalue_left");
	freq.start();
	sin.start();
	play.start();
	limiter->addTimer(250,zeit);
	dispatcher.run();
	play.stop();
	sin.stop();
	freq.stop();
};

void MyTimeNotify::notifyTime(){	test->terminate();	};

#endif

int iw_getstats (const char *	ifname,  iwstats *	stats)
{
  FILE *	f=fopen("/proc/net/wireless","r");
  char		buf[256];
  char *	bp;
  int		t;
  if(f==NULL)
    return -1;
  /* Loop on all devices */
  while(fgets(buf,255,f))
    {
      bp=buf;
      while(*bp&&isspace(*bp))
	bp++;
      /* Is it the good device ? */
      if(strncmp(bp,ifname,strlen(ifname))==0 && bp[strlen(ifname)]==':')
  	{
	  /* Skip ethX: */
	  bp=strchr(bp,':');
	  bp++;
	  /* -- status -- */
	  bp = strtok(bp, " ");
	  sscanf(bp, "%X", &t);
	  stats->status = (unsigned short) t;
	  /* -- link quality -- */
	  bp = strtok(NULL, " ");
	  if(strchr(bp,'.') != NULL)
	    stats->qual.updated |= 1;
	  sscanf(bp, "%d", &t);
	  stats->qual.qual = (unsigned char) t;
	  /* -- signal level -- */
	  bp = strtok(NULL, " ");
	  if(strchr(bp,'.') != NULL)
	    stats->qual.updated |= 2;
	  sscanf(bp, "%d", &t);
	  stats->qual.level = (unsigned char) t;
	  /* -- noise level -- */
	  bp = strtok(NULL, " ");
	  if(strchr(bp,'.') != NULL)
	    stats->qual.updated += 4;
	  sscanf(bp, "%d", &t);
	  stats->qual.noise = (unsigned char) t;
	  /* -- discarded packets -- */
	  bp = strtok(NULL, " ");
	  sscanf(bp, "%d", &stats->discard.nwid);
	  bp = strtok(NULL, " ");
	  sscanf(bp, "%d", &stats->discard.code);
	  bp = strtok(NULL, " ");
	  sscanf(bp, "%d", &stats->discard.misc);
	  fclose(f);
	  return 0;
  	}
    }
  fclose(f);
  return -1;
}


int get_info (int skfd, const char * ifname, struct wireless_info *info)
{
  struct iwreq		wrq;

  memset((char *) info, 0, sizeof(struct wireless_info));

  /* Get wireless name */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWNAME, &wrq) < 0)
    /* If no wireless name : no wireless extensions */
    return(-1);
  else
    strcpy(info->name, wrq.u.name);

//  /* Get ranges */
//  if(get_range_info(skfd, ifname, &(info->range)) >= 0)
//    info->has_range = 1;

  /* Get network ID */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWNWID, &wrq) >= 0)
    {
      info->has_nwid = 1;
      memcpy(&(info->nwid), &(wrq.u.nwid), sizeof(iwparam));
    }

  /* Get frequency / channel */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWFREQ, &wrq) >= 0)
    {
      info->has_freq = 1;
      info->freq = freq2float(&(wrq.u.freq));
    }

  /* Get sensitivity */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWSENS, &wrq) >= 0)
    {
      info->has_sens = 1;
      memcpy(&(info->sens), &(wrq.u.sens), sizeof(iwparam));
    }

  /* Get encryption information */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  wrq.u.data.pointer = (caddr_t) info->key;
  wrq.u.data.length = 0;
  wrq.u.data.flags = 0;
  if(ioctl(skfd, SIOCGIWENCODE, &wrq) >= 0)
    {
      info->has_key = 1;
      info->key_size = wrq.u.data.length;
      info->key_flags = wrq.u.data.flags;
    }

  /* Get ESSID */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  wrq.u.essid.pointer = (caddr_t) info->essid;
  wrq.u.essid.length = 0;
  wrq.u.essid.flags = 0;
  if(ioctl(skfd, SIOCGIWESSID, &wrq) >= 0)
    {
      info->has_essid = 1;
      info->essid_on = wrq.u.data.flags;
    }

  /* Get AP address */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWAP, &wrq) >= 0)
    {
      info->has_ap_addr = 1;
      memcpy(&(info->ap_addr), &(wrq.u.ap_addr), sizeof (sockaddr));
    }

  /* Get NickName */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  wrq.u.essid.pointer = (caddr_t) info->nickname;
  wrq.u.essid.length = 0;
  wrq.u.essid.flags = 0;
  if(ioctl(skfd, SIOCGIWNICKN, &wrq) >= 0)
    if(wrq.u.data.length > 1)
      info->has_nickname = 1;

  /* Get bit rate */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWRATE, &wrq) >= 0)
    {
      info->has_bitrate = 1;
      memcpy(&(info->bitrate), &(wrq.u.bitrate), sizeof(iwparam));
    }

  /* Get RTS threshold */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWRTS, &wrq) >= 0)
    {
      info->has_rts = 1;
      memcpy(&(info->rts), &(wrq.u.rts), sizeof(iwparam));
    }

  /* Get fragmentation threshold */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWFRAG, &wrq) >= 0)
    {
      info->has_frag = 1;
      memcpy(&(info->frag), &(wrq.u.frag), sizeof(iwparam));
    }

  /* Get operation mode */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWMODE, &wrq) >= 0)
    {
      if(wrq.u.mode < 6)
	info->has_mode = 1;
      info->mode = wrq.u.mode;
    }

  /* Get Power Management settings */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  wrq.u.power.flags = 0;
  if(ioctl(skfd, SIOCGIWPOWER, &wrq) >= 0)
    {
      info->has_power = 1;
      memcpy(&(info->power), &(wrq.u.power), sizeof(iwparam));
    }

#if WIRELESS_EXT > 9
  /* Get Transmit Power */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWTXPOW, &wrq) >= 0)
    {
      info->has_txpower = 1;
      memcpy(&(info->txpower), &(wrq.u.txpower), sizeof(iwparam));
    }
#endif

#if WIRELESS_EXT > 10
  /* Get retry limit/lifetime */
  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  if(ioctl(skfd, SIOCGIWRETRY, &wrq) >= 0)
    {
      info->has_retry = 1;
      memcpy(&(info->retry), &(wrq.u.retry), sizeof(iwparam));
    }
#endif	/* WIRELESS_EXT > 10 */

  /* Get stats */
  if(iw_getstats(ifname, &(info->stats)) >= 0)
    {
      info->has_stats = 1;
    }

  return(0);

};

QString return_info(int socket, struct wireless_info * temp1, iwstats * temp2, QString intfc) {
if (intfc=="") {
	cerr << "Autodetecting... ";
	string if0 = "eth0";
	string if1 = "eth1";
	string if2 = "eth2";
	string if3 = "eth3";
	if (get_info(socket, if0.c_str(), temp1)!=-1)
	{	iw_getstats(if0.c_str(), temp2);
		cerr << "Found card for interface eth0\n";
		return "eth0";} else
	if (get_info(socket, if1.c_str(), temp1)!=-1)
	{	iw_getstats(if1.c_str(), temp2);
		cerr << "Found card for interface eth1\n";
		return "eth1";} else
	if (get_info(socket, if2.c_str(), temp1)!=-1)
	{	iw_getstats(if2.c_str(), temp2);
		cerr << "Found card for interface eth2\n";
		return "eth2";} else
	if (get_info(socket, if3.c_str(), temp1)!=-1)
	{	iw_getstats(if3.c_str(), temp2);
		cerr << "Found card for interface eth3\n";
		return "eth3";} else {
		cerr << "hmm. Found nothing. Ill try again in 250 ms.\n";
		temp2->qual.qual = 0;
		temp2->qual.noise = 154;
		temp2->qual.level = 154;
		if (intfc!="aironet") return intfc;
	  }
	} else if (intfc!="aironet")
	{
	if (get_info(socket, intfc.latin1(), temp1)!=-1) {
		iw_getstats(intfc.latin1(), temp2);
		return intfc;
	} else {
		cerr << "Looks like the card has been detached. Switching back to autodetect mode.\n";
		temp2->qual.qual = 0;
		temp2->qual.level = 154;
		temp2->qual.noise = 154;
		return "";
	}
	}
	else return intfc;
};

QString whois(char* MAC_ADR, QStringList APList)
{
    for (QStringList::Iterator it=APList.begin() ; it != APList.end() ; (it++)++ ) {
		if ( (*it)==(QString)MAC_ADR ) return *(++it);
	};
	return i18n("UNKNOWN");
};

extern "C" {

int sockets_open(void)
{
        int ipx_sock = -1;              /* IPX socket                   */
        int ax25_sock = -1;             /* AX.25 socket                 */
        int inet_sock = -1;             /* INET socket                  */
        int ddp_sock = -1;              /* Appletalk DDP socket         */
        inet_sock=socket(AF_INET, SOCK_DGRAM, 0);
        if(inet_sock!=-1)
                return inet_sock;
        ipx_sock=socket(AF_IPX, SOCK_DGRAM, 0);
        if(ipx_sock!=-1)
                return ipx_sock;
        ax25_sock=socket(AF_AX25, SOCK_DGRAM, 0);
        if(ax25_sock!=-1)
                return ax25_sock;
        ddp_sock=socket(AF_APPLETALK, SOCK_DGRAM, 0);
        return ddp_sock;
}

int
get_range_info(int		skfd,
	       const char *		ifname,
	       iwrange *	range)
{
  struct iwreq		wrq;
  char			buffer[sizeof(iwrange) * 2];	/* Large enough */

  memset(buffer, 0, sizeof(range));

  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  wrq.u.data.pointer = (caddr_t) buffer;
  wrq.u.data.length = 0;
  wrq.u.data.flags = 0;
  if(ioctl(skfd, SIOCGIWRANGE, &wrq) < 0)
    return(-1);

  memcpy((char *) range, buffer, sizeof(iwrange));

  if((WIRELESS_EXT > 10) && (wrq.u.data.length >= 300))
    {
#if WIRELESS_EXT > 10
      if(range->we_version_compiled != WIRELESS_EXT)
	{
	  fprintf(stderr, "Warning : Device %s has been compiled with version %d\n", ifname, range->we_version_compiled);
	  fprintf(stderr, "of Wireless Extension, while we are using version %d.\n", WIRELESS_EXT);
	  fprintf(stderr, "Some things may be broken...\n\n");
	}
#endif /* WIRELESS_EXT > 10 */
    }
  else
    {
      if(wrq.u.data.length != sizeof(iwrange))
	{
	  fprintf(stderr, "Warning : Device %s has been compiled with a different version\n", ifname);
	  fprintf(stderr, "of Wireless Extension than ours (we are using version %d).\n", WIRELESS_EXT);
	  fprintf(stderr, "Some things may be broken...\n\n");
	}
    }
  return(0);
}

int
get_priv_info(int		skfd,
	      char *		ifname,
	      iwprivargs *	priv)
{
  struct iwreq		wrq;

  strncpy(wrq.ifr_name, ifname, IFNAMSIZ);
  wrq.u.data.pointer = (caddr_t) priv;
  wrq.u.data.length = 0;
  wrq.u.data.flags = 0;
  if(ioctl(skfd, SIOCGIWPRIV, &wrq) < 0)
    return(-1);

  return(wrq.u.data.length);
}

void
float2freq(double	in,
	   iwfreq *	out)
{
  out->e = (short) (floor(log10(in)));
  if(out->e > 8)
    {
      out->m = ((long) (floor(in / pow(10,out->e - 6)))) * 100;
      out->e -= 8;
    }
  else
    {
      out->m = (__u32)in;
      out->e = 0;
    }
}

double
freq2float(iwfreq *	in)
{
  return ((double) in->m) * pow(10,in->e);
}

int
dbm2mwatt(int	in)
{
  return((int) (floor(pow(10.0, (((double) in) / 10.0)))));
}

int
mwatt2dbm(int	in)
{
  return((int) (ceil(10.0 * log10((double) in))));
}

void
print_pm_value(FILE *	stream,
	       int	value,
	       int	flags)
{
  /* Modifiers */
  if(flags & IW_POWER_MIN)
    fprintf(stream, " min");
  if(flags & IW_POWER_MAX)
    fprintf(stream, " max");

  /* Type */
  if(flags & IW_POWER_TIMEOUT)
    fprintf(stream, " timeout:");
  else
    fprintf(stream, " period:");

  /* Display value without units */
  if(flags & IW_POWER_RELATIVE)
    fprintf(stream, "%g  ", ((double) value) / MEGA);
  else
    {
      /* Display value with units */
      if(value >= (int) MEGA)
	fprintf(stream, "%gs  ", ((double) value) / MEGA);
      else
	if(value >= (int) KILO)
	  fprintf(stream, "%gms  ", ((double) value) / KILO);
	else
	  fprintf(stream, "%dus  ", value);
    }
}

/*------------------------------------------------------------------*/
/*
 * Output a power management mode
 */
void
print_pm_mode(FILE *	stream,
	      int	flags)
{
  /* Print the proper mode... */
  switch(flags & IW_POWER_MODE)
    {
    case IW_POWER_UNICAST_R:
      fprintf(stream, " mode:Unicast only received");
      break;
    case IW_POWER_MULTICAST_R:
      fprintf(stream, " mode:Multicast only received");
      break;
    case IW_POWER_ALL_R:
      fprintf(stream, " mode:All packets received");
      break;
    case IW_POWER_FORCE_S:
      fprintf(stream, " mode:Force sending");
      break;
    case IW_POWER_REPEATER:
      fprintf(stream, " mode:Repeat multicasts");
      break;
    }
}

/***************** RETRY LIMIT/LIFETIME SUBROUTINES *****************/

#if WIRELESS_EXT > 10
/*------------------------------------------------------------------*/
/*
 * Output a retry value with all attributes...
 */
void
print_retry_value(FILE *	stream,
		  int		value,
		  int		flags)
{
  /* Modifiers */
  if(flags & IW_RETRY_MIN)
    fprintf(stream, " min");
  if(flags & IW_RETRY_MAX)
    fprintf(stream, " max");

  /* Type lifetime of limit */
  if(flags & IW_RETRY_LIFETIME)
    {
      fprintf(stream, " lifetime:");

      /* Display value without units */
      if(flags & IW_POWER_RELATIVE)
	fprintf(stream, "%g", ((double) value) / MEGA);
      else
	{
	  /* Display value with units */
	  if(value >= (int) MEGA)
	    fprintf(stream, "%gs", ((double) value) / MEGA);
	  else
	    if(value >= (int) KILO)
	      fprintf(stream, "%gms", ((double) value) / KILO);
	    else
	      fprintf(stream, "%dus", value);
	}
    }
  else
    fprintf(stream, " limit:%d", value);
}
#endif	/* WIRELESS_EXT > 10 */

/*********************** ADDRESS SUBROUTINES ************************/
/*
 * This section is mostly a cut & past from net-tools-1.2.0
 * manage address display and input...
 */

/*------------------------------------------------------------------*/
/*
 * Check if interface support the right address types...
 */
int
check_addr_type(int	skfd,
		const char *	ifname)
{
  struct ifreq		ifr;

  /* Get the type of interface address */
  strncpy(ifr.ifr_name, ifname, IFNAMSIZ);
  if((ioctl(skfd, SIOCGIFADDR, &ifr) < 0) ||
     (ifr.ifr_addr.sa_family !=  AF_INET))
    {
      /* Deep trouble... */
      fprintf(stderr, "Interface %s doesn't support IP addresses\n", ifname);
      return(-1);
    }

#ifdef DEBUG
  printf("Interface : %d - 0x%lX\n", ifr.ifr_addr.sa_family,
	 *((unsigned long *) ifr.ifr_addr.sa_data));
#endif

  /* Get the type of hardware address */
  strncpy(ifr.ifr_name, ifname, IFNAMSIZ);
  if((ioctl(skfd, SIOCGIFHWADDR, &ifr) < 0) ||
     (ifr.ifr_hwaddr.sa_family != ARPHRD_ETHER))
    {
      /* Deep trouble... */
      fprintf(stderr, "Interface %s doesn't support MAC addresses\n",
	     ifname);
      return(-1);
    }

  return(0);
}


/*------------------------------------------------------------------*/
/*
 * Display an Ethernet address in readable format.
 */
char *
pr_ether(unsigned char *ptr)
{
  static char buff[64];

  sprintf(buff, "%02X:%02X:%02X:%02X:%02X:%02X",
	(ptr[0] & 0xFF), (ptr[1] & 0xFF), (ptr[2] & 0xFF),
	(ptr[3] & 0xFF), (ptr[4] & 0xFF), (ptr[5] & 0xFF)
  );
  return(buff);
}

/*------------------------------------------------------------------*/
/*
 * Input an Ethernet address and convert to binary.
 */
int
in_ether(const char *bufp, struct sockaddr *sap)
{
  char *ptr;
  char c;
  const char *orig;
  int i, val;

  sap->sa_family = ARPHRD_ETHER;
  ptr = sap->sa_data;

  i = 0;
  orig = bufp;
  while((*bufp != '\0') && (i < ETH_ALEN)) {
	val = 0;
	c = *bufp++;
	if (isdigit(c)) val = c - '0';
	  else if (c >= 'a' && c <= 'f') val = c - 'a' + 10;
	  else if (c >= 'A' && c <= 'F') val = c - 'A' + 10;
	  else {
#ifdef DEBUG
		fprintf(stderr, "in_ether(%s): invalid ether address!\n", orig);
#endif
		errno = EINVAL;
		return(-1);
	}
	val <<= 4;
	c = *bufp++;
	if (isdigit(c)) val |= c - '0';
	  else if (c >= 'a' && c <= 'f') val |= c - 'a' + 10;
	  else if (c >= 'A' && c <= 'F') val |= c - 'A' + 10;
	  else {
#ifdef DEBUG
		fprintf(stderr, "in_ether(%s): invalid ether address!\n", orig);
#endif
		errno = EINVAL;
		return(-1);
	}
	*ptr++ = (unsigned char) (val & 0377);
	i++;

	/* We might get a semicolon here - not required. */
	if (*bufp == ':') {
		if (i == ETH_ALEN) {
#ifdef DEBUG
			fprintf(stderr, "in_ether(%s): trailing : ignored!\n",
				orig)
#endif
						; /* nothing */
		}
		bufp++;
	}
  }

  /* That's it.  Any trailing junk? */
  if ((i == ETH_ALEN) && (*bufp != '\0')) {
#ifdef DEBUG
	fprintf(stderr, "in_ether(%s): trailing junk!\n", orig);
	errno = EINVAL;
	return(-1);
#endif
  }

  return(0);
}

/*------------------------------------------------------------------*/
/*
 * Input an Internet address and convert to binary.
 */
int
in_inet(char *bufp, struct sockaddr *sap)
{
  struct hostent *hp;
  struct netent *np;
  char *name = bufp;
  struct sockaddr_in *sin = (struct sockaddr_in *) sap;

  /* Grmpf. -FvK */
  sin->sin_family = AF_INET;
  sin->sin_port = 0;

  /* Default is special, meaning 0.0.0.0. */
  if (!strcmp(name, "default")) {
	sin->sin_addr.s_addr = INADDR_ANY;
	return(1);
  }

  /* Try the NETWORKS database to see if this is a known network. */
  if ((np = getnetbyname(name)) != (struct netent *)NULL) {
	unsigned long int temp = np->n_net;
	unsigned long int temp2 = htonl(temp);
	sin->sin_addr.s_addr = temp2;
	strcpy(name, np->n_name);
	return(1);
  }

  if ((hp = gethostbyname(name)) == (struct hostent *)NULL) {
	errno = h_errno;
	return(-1);
  }
  memcpy((char *) &sin->sin_addr, (char *) hp->h_addr_list[0], hp->h_length);
  strcpy(name, hp->h_name);
  return(0);
}

/*------------------------------------------------------------------*/
/*
 * Input an address and convert to binary.
 */
int
in_addr(int		skfd,
	const char *		ifname,
	char *		bufp,
	struct sockaddr *sap)
{
  /* Check if it is a hardware or IP address */
  if(index(bufp, ':') == NULL)
    {
      struct sockaddr	if_address;
      struct arpreq	arp_query;

      /* Read interface address */
      if(in_inet(bufp, &if_address) < 0)
	{
	  fprintf(stderr, "Invalid interface address %s\n", bufp);
	  return(-1);
	}

      /* Translate IP addresses to MAC addresses */
      memcpy((char *) &(arp_query.arp_pa),
	     (char *) &if_address,
	     sizeof(struct sockaddr));
      arp_query.arp_ha.sa_family = 0;
      arp_query.arp_flags = 0;
      /* The following restrict the search to the interface only */
      /* For old kernels which complain, just comment it... */
      strncpy(arp_query.arp_dev, ifname, IFNAMSIZ);
      if((ioctl(skfd, SIOCGARP, &arp_query) < 0) ||
	 !(arp_query.arp_flags & ATF_COM))
	{
	  fprintf(stderr, "Arp failed for %s on %s... (%d)\nTry to ping the address before setting it.\n",
		  bufp, ifname, errno);
	  return(-1);
	}

      /* Store new MAC address */
      memcpy((char *) sap,
	     (char *) &(arp_query.arp_ha),
	     sizeof(struct sockaddr));

    }
  else	/* If it's an hardware address */
    /* Get the hardware address */
    if(in_ether(bufp, sap) < 0)
      {
	fprintf(stderr, "Invalid hardware address %s\n", bufp);
	return(-1);
      }

  return(0);
}

/************************* MISC SUBROUTINES **************************/

/*------------------------------------------------------------------*/
/*
 */
int
byte_size(int	args)
{
  int	ret = args & IW_PRIV_SIZE_MASK;

  if(((args & IW_PRIV_TYPE_MASK) == IW_PRIV_TYPE_INT) ||
     ((args & IW_PRIV_TYPE_MASK) == IW_PRIV_TYPE_FLOAT))
    ret <<= 2;

  if((args & IW_PRIV_TYPE_MASK) == IW_PRIV_TYPE_NONE)
    return 0;

  return ret;
}

}
