/***************************************************************************
                          korinoco.cpp  -  description
                             -------------------
    begin                : Sam Apr  7 11:44:20 CEST 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

// include files for QT
#include <qdatetime.h>
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qtabdialog.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kstddirs.h>

// application specific includes
#include "korinoco.h"

#define ID_STATUS_MSG 1

KOrinocoApp::KOrinocoApp(QWidget* , const char* name):KMainWindow(0, name)
{
	cerr << "This is KOrinoco, version 0.2-glibc2.2\n";
	tricorder = false;
	timeisup = 0;
	old_net_name = "Softdrinks rule!";
	cerr << "Initializing AccessPoint WHOIS database..." << endl;
	init_whois_db();
	proxwarncounter=0;
	skfd = -1;
  	if((skfd = sockets_open()) < 0)
    {
      perror("Error opening socket!");
      exit(-1);
    };

	setFixedSize(440,220);
	infocontainer = new (wireless_info);
	infocontainer2 = new (iwstats);
	
	for (int i=0; i<240; i++) {
		daten.sigLevel[i] = -102;
		daten.noiseLevel[i] = -102;
		daten.qual[i]=0;
		daten.current = 0;
	}

	statistik = 0;

	used_interface = "";

	used_interface = return_info(skfd, infocontainer, infocontainer2, used_interface);
	if (used_interface=="") { this->setCaption(i18n("No Interface")); }
	else this->setCaption(i18n("Interface %1").arg(used_interface.latin1()));

  initActions();
  initView();

	fileDisableRadio->setEnabled(true);

  QTimer * counter = new QTimer( this );
  connect( counter, SIGNAL(timeout()),
           this, SLOT(slotTheEvilLoop()) );
  counter->start( 250 );

}

void KOrinocoApp::init_whois_db() {
  KStandardDirs finder;
  QString kdedir=finder.findResourceDir("data","korinoco/config/locations/NOWHERE.loc");
  kdedir+="korinoco/config/locations/";
	QDir *locations = new QDir(kdedir);
	if (!locations->exists()) cerr << "GIBTS NET!";
	QStringList *entries = new QStringList(locations->entryList());
	QString content;
	QString content2;
	for (QStringList::Iterator it = entries->begin() ; it != entries->end() ; it++) {
		if ((*it)!="." && (*it)!="..") {
			QFile datei(kdedir+(*it));
			datei.open(IO_ReadOnly);
			while (datei.readLine(content, 255)!=-1) {
				QString temp(content);
				content.truncate(content.find(' '));
				content2 = temp.right(temp.length()-temp.find(' ')-1);
				content2.truncate(content2.length()-1);
				APs << content << content2;
			};
			datei.close();
		};
	};
delete entries;
delete locations;
}

void KOrinocoApp::slotTheEvilLoop() {
	if (proxwarncounter>0) { proxwarncounter--; };
	QString temp = used_interface;
	 used_interface = return_info(skfd, infocontainer, infocontainer2, used_interface);

// experimental checking for the Aironet 4500 (non-wireless extensions)
/*
	if (!used_interface.startsWith("eth")) {
		QDir aironet("/proc/sys/aironet4500/");
		if (aironet.exists()) {
			used_interface = "aironet";
			// check the proc filesystem
			QStringList entries = aironet.entryList("*").grep("eth");
			if (entries.isEmpty()) { used_interface = "";} // driver present, but no interface
				else {
					QString airo_interface = entries.first();
					cerr << "Found an Aironet 4500 in interface " << airo_interface <<  endl;
					QFile quality("/proc/sys/aironet4500/"+airo_interface+"/Status/CurrentSignalQuality");
					if (!quality.exists()) cerr << "Oops, where is the QualityFile?\n";
					char *rawText;
					quality.readLine(rawText,5);
					QString qualConv = rawText;
					infocontainer2->qual.qual = qualConv.toInt();
					cerr << "Quality is " << infocontainer2->qual.qual << endl;
				};
   			};
	};
*/
// end Aironet


	if (used_interface != temp) {
		if (!used_interface.startsWith("eth")) { this->setCaption(i18n("No Interface")); }
		else { this->setCaption(i18n("Interface %1").arg(used_interface));
		}
	};
	if (timeisup==0) {
		if (infocontainer2->qual.qual>0) {
			if (old_net_name!=infocontainer->essid && old_net_name!="Softdrinks rule!") {
				old_net_name=infocontainer->essid;
				QString kdedir=getenv("HOME");
				kdedir+="/.wireless-log";
				QFile ausgabe2(kdedir);
				if (!ausgabe2.open(IO_Append)) cerr << "Loggen fehlgeschlagen!\n";
				QDateTime zeit;
				ausgabe2.writeBlock(zeit.toString().latin1(), 255);
				ausgabe2.writeBlock(" Entering network: ",255);
				ausgabe2.writeBlock(infocontainer->essid,255);
				ausgabe2.writeBlock(" Strength: ",255);
				ausgabe2.writeBlock((char*)infocontainer2->qual.qual,255);
				ausgabe2.writeBlock("\n",2);
				ausgabe2.close();
			};
		};
		if (tricorder) sinus_wave(150.0+infocontainer2->qual.qual*20);
		if (infocontainer2->qual.qual ==0) { timeisup = 8;} else
		if (infocontainer2->qual.qual <10) { timeisup = 4;} else
		if (infocontainer2->qual.qual <20) { timeisup = 2; } else
		if (infocontainer2->qual.qual< 30) { timeisup = 1; };
	} else timeisup--;
    status->repaint();
	strength->repaint();
	pictogram->repaint();
	location->repaint();
	daten.sigLevel[daten.current]=infocontainer2->qual.level - 0x100;
	daten.noiseLevel[daten.current]=infocontainer2->qual.noise - 0x100;
	daten.qual[daten.current]=infocontainer2->qual.qual;

	if (statistik != 0) if (statistik->isVisible()) statistik->repaint();
	daten.current < 239 ? daten.current+=1 : daten.current=0;
	if ((infocontainer2->qual.qual>55) && (proxwarncounter==0) && (infocontainer->freq/1000000.>=2400)) {
		proxwarncounter=240;
		KMessageBox* proxwarn = new KMessageBox;
		proxwarn->sorry(0,i18n("You should not be THAT close to the access point.\nMicrowave radiation is not very healthy :-)"), i18n("PROXIMITY ALERT"), false);
	};
	
}

KOrinocoApp::~KOrinocoApp()
{

cerr << "Thank you for using KOrinoco. You have made a simple program very happy.\n";
}
	
void KOrinocoApp::initActions()
{
  fileDisableRadio = new KToggleAction(i18n("&Disable radio"), 0, 0, this, SLOT(slotDisableRadio()), actionCollection(),"file_new_window" );
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
	KAction* conf = new KAction(i18n("Configuration &Editor"), 0, this, SLOT(slotStartConfigEditor()), this);
	KAction* stat = new KAction(i18n("Connection &Statistics"), 0, this, SLOT(slotStartStatViewer()), this);
	KAction* tric = new KToggleAction(i18n("&Acoustic Scanning"),0,0, this, SLOT(slotToggleTric()), actionCollection(), "file_new_window" );
	KPopupMenu* help = helpMenu(QString::null,false);
	QPopupMenu* filemenu = new QPopupMenu;
	QPopupMenu* editmenu = new QPopupMenu;
	conf->plug(editmenu);
	tric->plug(editmenu);
	fileDisableRadio->plug(filemenu);
	stat->plug(filemenu);
	fileQuit->plug(filemenu);
	menuBar()->insertItem(i18n("&File"),filemenu);
	menuBar()->insertItem(i18n("&Config"),editmenu);
	menuBar()->insertItem(i18n("&Help"),help);
}


void KOrinocoApp::initView()
{ 
  	view = new QWidget(this,"mainwidget");
	view->setBackgroundMode(PaletteBase);
  	setCentralWidget(view);	
	QGridLayout* zentrallayout = new QGridLayout(view);
	profilmaster = new QWidget(view);
// profilmaster is unused at the moment
 	status = new Status(this,view);
 	location = new Locator(this, view);
 	strength = new Strength(this,view);
 	pictogram = new Picture(this,view);
	pictogram->setFixedSize(150,55);
	strength->setFixedSize(150,120);
	profilmaster->setFixedSize(290,55);
	status->setFixedSize(290,120);
	location->setFixedSize(440,20);
	zentrallayout->addWidget(pictogram,0,0);
 	zentrallayout->addWidget(strength,1,0 );
	zentrallayout->addWidget(profilmaster,0,1);
	zentrallayout->addWidget(status,1,1);
  zentrallayout->addMultiCellWidget(location,2,2,0,1);
}

void KOrinocoApp::slotStartStatViewer()
{
	if (statistik != 0) delete statistik;
	statistik = new Statistics(this);
	statistik->setFixedSize(590,300);
	statistik->show();
}

void KOrinocoApp::slotDisableRadio()
{
	cerr << "Later, this will deactivate the cards radio.\n";
}

void KOrinocoApp::slotToggleTric()
{
	if (tricorder) {tricorder = false;} else tricorder = true;
}

void KOrinocoApp::slotFileQuit()
{
	delete status;
	delete strength;
  KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      if(!w->close())
			break;
    }
  }	
}

void KOrinocoApp::slotStartConfigEditor()
{
	  KProcess startConf;
	  startConf << "kdesu" << "kcmshell" << "korinoco_kcmodule";
	  startConf.start(KProcess::DontCare);
}


Status::Status(KOrinocoApp* siff, QWidget* parent) : QWidget(parent, "status"){
  referenz=siff;
	};

void Status::paintEvent (QPaintEvent *) {
	QPainter* statuspainter = new QPainter(this);
	QString temp1="%1";
	QString temp1a="%1";
	QString temp2="%1";
	QString temp3=i18n("%1 GHz [%2]");
	QString temp4="%1";
	referenz->infocontainer2->qual.qual==0 ? temp1 = temp1.arg(i18n("Searching for network: ")) : temp1 = temp1.arg(i18n("Connected to network: "));
	temp1a = temp1a.arg(referenz->infocontainer->essid);
	unsigned char* temp = (unsigned char*)referenz->infocontainer->ap_addr.sa_data;
    temp2 = temp2.arg(pr_ether(temp));
	temp3 = temp3.arg(referenz->infocontainer->freq/1000000000.);
	if (referenz->infocontainer->freq/1000000.>=2472.) {temp3 = temp3.arg(14);} else
	if (referenz->infocontainer->freq/1000000.>=2467.) {temp3 = temp3.arg(13);} else
	if (referenz->infocontainer->freq/1000000.>=2462.) {temp3 = temp3.arg(12);} else
	if (referenz->infocontainer->freq/1000000.>=2457.) {temp3 = temp3.arg(11);} else
	if (referenz->infocontainer->freq/1000000.>=2452.) {temp3 = temp3.arg(10);} else
	if (referenz->infocontainer->freq/1000000.>=2447.) {temp3 = temp3.arg(9);} else
	if (referenz->infocontainer->freq/1000000.>=2442.) {temp3 = temp3.arg(8);} else
	if (referenz->infocontainer->freq/1000000.>=2437.) {temp3 = temp3.arg(7);} else
	if (referenz->infocontainer->freq/1000000.>=2432.) {temp3 = temp3.arg(6);} else
	if (referenz->infocontainer->freq/1000000.>=2427.) {temp3 = temp3.arg(5);} else
	if (referenz->infocontainer->freq/1000000.>=2422.) {temp3 = temp3.arg(4);} else
	if (referenz->infocontainer->freq/1000000.>=2417.) {temp3 = temp3.arg(3);} else
	if (referenz->infocontainer->freq/1000000.>=2412.) {temp3 = temp3.arg(2);} else
	if (referenz->infocontainer->freq/1000000.>=2400.) {temp3 = temp3.arg(1);} else
  temp3 = temp3.arg("?");
	if (referenz->infocontainer->has_key) {
		if 	((referenz->infocontainer->key_flags & IW_ENCODE_DISABLED) || (referenz->infocontainer->key_size==0)) { temp4 = temp4.arg(i18n("inactive")); } else temp4 = temp4.arg(i18n("active")); }
		else temp4 = temp4.arg(i18n("off"));
	

	statuspainter->drawText(22,15,i18n("Status of active connection"));
	statuspainter->drawText(5,35,temp1);
	statuspainter->drawText(173,35,temp1a);
	statuspainter->drawText(5,50,i18n("Access point: "));
	statuspainter->drawText(173,50,temp2);
	statuspainter->drawText(5,80,i18n("Frequency [Channel]: "));
	statuspainter->drawText(173,80,temp3);
	statuspainter->drawText(5,95,i18n("Encryption: "));
	statuspainter->drawText(173,95,temp4);
	statuspainter->drawLine(17,10,0,10);
	statuspainter->drawLine(0,10,0,105);
	statuspainter->drawLine(0,105,285,105);
	statuspainter->drawLine(285,105,285,10);
	statuspainter->drawLine(285,10,267,10);
	delete statuspainter;
};

Locator::Locator(KOrinocoApp *anw, QWidget* parent) : QWidget(parent, "locator") {
	anwend = anw;
};

void Locator::paintEvent (QPaintEvent *) {
	QPainter* locatorpainter = new QPainter(this);
	QString sentence = i18n("AccessPoint: %1");
    sentence=sentence.arg(whois(pr_ether((unsigned char*)anwend->infocontainer->ap_addr.sa_data),APs));
	locatorpainter->drawText(5,10,sentence);
    delete locatorpainter;
}

Strength::Strength(KOrinocoApp* siff, QWidget* parent) : QWidget(parent, "strength"){
	referenz=siff;
  KStandardDirs finder;
  kdedir=finder.findResourceDir("data","korinoco/pics/no_card.png");
  kdedir+="korinoco/pics/";
	bild = new QPixmap();
	};

void Strength::paintEvent (QPaintEvent *) {
	QPainter* strengthpainter = new QPainter(this);
	delete bild;
  QString sstrength1="%1";
	QString sstrength2=i18n("Signal strength: %1");
	if (referenz->infocontainer->freq/1000000.<=2399.) {sstrength1 = sstrength1.arg(i18n("NOT CONNECTED")); bild = new QPixmap(kdedir+"offline.png");} else
	if (referenz->infocontainer->mode==1) {sstrength1 = sstrength1.arg(i18n("AD-HOC MODE")); bild = new QPixmap(kdedir+"offline.png");} else
  if (referenz->infocontainer2->qual.qual>55) {sstrength1 = sstrength1.arg(i18n("! PROXIMITY ALERT !")); bild = new QPixmap(kdedir+"excellent.png");} else
  if (referenz->infocontainer2->qual.qual>45) {sstrength1 = sstrength1.arg(i18n("ULTIMATE")); bild = new QPixmap(kdedir+"excellent.png");} else
  if (referenz->infocontainer2->qual.qual>35) {sstrength1 = sstrength1.arg(i18n("TOP")); bild = new QPixmap(kdedir+"excellent.png");} else
  if (referenz->infocontainer2->qual.qual>25) {sstrength1 = sstrength1.arg(i18n("EXCELLENT")); bild = new QPixmap(kdedir+"excellent.png");} else
  if (referenz->infocontainer2->qual.qual>15) {sstrength1 = sstrength1.arg(i18n("GOOD"));	bild = new QPixmap(kdedir+"good.png");} else
  if (referenz->infocontainer2->qual.qual>5) {sstrength1 = sstrength1.arg(i18n("WEAK")); bild = new QPixmap(kdedir+"marginal.png");} else
  if (referenz->infocontainer2->qual.qual>0) {sstrength1 = sstrength1.arg(i18n("MINIMUM")); bild = new QPixmap(kdedir+"oor_minimum.png");} else
  if ((referenz->infocontainer2->qual.qual==0)&&(referenz->infocontainer->mode==2)) {sstrength1 = sstrength1.arg(i18n("OUT OF RANGE")); bild = new QPixmap(kdedir+"oor_down.png");} else
	 { sstrength1 = sstrength1.arg(i18n("N/A"));
		 bild = new QPixmap(kdedir+"offline.png");
	 };
  if (referenz->infocontainer->freq/1000000.>2399.) {
		if (referenz->infocontainer->mode==2) { sstrength2 = sstrength2.arg(referenz->infocontainer2->qual.qual);}
		else sstrength2 = sstrength2.arg(i18n("N/A"));
	} else sstrength2 = sstrength2.arg(i18n("N/A"));
	strengthpainter->drawPixmap(50,20,*bild);
	strengthpainter->drawText(5,70,sstrength1);
	strengthpainter->drawText(5,90,sstrength2);
	delete strengthpainter;
}

Picture::Picture(KOrinocoApp* siff, QWidget* parent) : QWidget(parent, "picture"){
  referenz=siff;
	pic = new QPixmap();
  KStandardDirs finder;
  kdedir=finder.findResourceDir("data","korinoco/pics/no_card.png");
  kdedir+="korinoco/pics/";
}

void Picture::paintEvent (QPaintEvent *) {
	delete pic;
	QPainter* picturepainter = new QPainter(this);
  if (referenz->infocontainer->freq/1000000.<2399.) {pic = new QPixmap(kdedir+"no_card.png");} else
	if (referenz->infocontainer->mode==1) { pic = new QPixmap(kdedir+"ad_hoc.png");} else
	if (referenz->infocontainer2->qual.qual==0) { pic = new QPixmap(kdedir+"all_alone.png");} else
	if (referenz->infocontainer2->qual.qual>0) { pic = new QPixmap(kdedir+"ap_connect.png");} else
	pic = new QPixmap(kdedir+"no_card.png");
	picturepainter->drawPixmap(20,10,*pic);
	delete picturepainter;
}

Statistics::Statistics(KOrinocoApp* siff) : QWidget(0,"KOrinoco") {
  referenz=siff;
		this->setCaption(i18n("Statistics - KOrinoco"));
}

void Statistics::paintEvent(QPaintEvent *) {
   statpainter = new QPainter(this);
	QColor farbe(255,255,255);
	statpainter->drawText(40,30,i18n("Noise/Signal Level Statistics"));
	statpainter->drawText(150,260,i18n("BLUE = signal level, RED = noise level"));
	statpainter->drawText(25,50,"0");
	statpainter->drawText(5,234,"-102");
	statpainter->drawText(5,250,i18n("[dBm]"));
	statpainter->drawLine(41,244,41,260);
	statpainter->drawLine(520,244,520,260);
	statpainter->drawText(21,274,i18n("-60 s"));
	statpainter->drawText(510,274,i18n("now"));
	statpainter->fillRect(41,41,480,204,farbe);
	QPointArray datensatz(240);
	QPointArray datensatz2(240);
	int i=0;
	for (int j=referenz->daten.current; j<referenz->daten.current+240;j++) {
		datensatz.setPoint(i,40+(i*2),40-(referenz->daten.sigLevel[j%240]*2));
		datensatz2.setPoint(i,40+(i*2),40-(referenz->daten.noiseLevel[j%240]*2));
		i++;
	};
	statpainter->setPen(red);
	statpainter->drawPolyline(datensatz2,1);
	statpainter->setPen(blue);
	statpainter->drawPolyline(datensatz,1);
	delete statpainter;	
}
