
#include <kore/version.h>
#include <kore/servicemanager.h>

#include <gtk/gtk.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>

#include "koredlg_gnome.h"

#define KDG_MAJOR 0
#define KDG_MINOR 0
#define KDG_REVISION 1
#define KDG_VERSION "0.0.1"
#define KDG_API_MAJOR 0
#define KDG_API_MINOR 0
#define KDG_API_REVISION 2
#define KDG_API_VERSION "0.0.2"
#define KDG_NAME "KoreDialog <Gnome>"
#define KDG_TYPE KOREDLG_TYPE
#define KDG_DESCRIPTION "Gnome-based implementation for KoreDialog"
#define KDG_SERVICE KOREDLG_SERVICE "/gnome"
#define KDG_SERVICE_DESCRIPTION "Gnome-based '" KOREDLG_SERVICE "' service"

KoreDlg_gnome::KoreDlg_gnome()
{
    _kdgVersion = new Version(KDG_MAJOR,KDG_MINOR,KDG_REVISION,KDG_VERSION);
    _kdgAPIVersion = new Version(KDG_API_MAJOR,KDG_API_MINOR,KDG_API_REVISION,KDG_API_VERSION);
    _kdgInfo = new Info(this, KDG_NAME, KDG_TYPE, KDG_DESCRIPTION, _kdgVersion, _kdgAPIVersion);
    setInfo(_kdgInfo);
    _kdgService = new Service(this, KDG_SERVICE, KDG_SERVICE_DESCRIPTION);
    addService(_kdgService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDG_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_gnome::~KoreDlg_gnome()
{
    delete _kdgInfo;
    delete _kdgVersion;
    delete _kdgAPIVersion;
    delete _kdgService;
    delete _kdService;
}

void KoreDlg_gnome::showMessage(const char *msg)
{
    char* argv[] = { KDG_NAME };
    gnome_init( KDG_NAME, KDG_VERSION, 1, argv );
    GtkWidget* dlg = gnome_ok_dialog( msg );
    gnome_dialog_run_and_close( GNOME_DIALOG(dlg) );
}
