
#include <kore/version.h>
#include <kore/servicemanager.h>

#include <gui/application.h>
#include <gui/requesters.h>

#include "koredlg_atheos.h"

#define KDATH_MAJOR 0
#define KDATH_MINOR 0
#define KDATH_REVISION 1
#define KDATH_VERSION "0.0.1"
#define KDATH_API_MAJOR 0
#define KDATH_API_MINOR 0
#define KDATH_API_REVISION 2
#define KDATH_API_VERSION "0.0.2"
#define KDATH_NAME "KoreDialog <AtheOS>"
#define KDATH_TYPE KOREDLG_TYPE
#define KDATH_DESCRIPTION "AtheOS-based implementation for KoreDialog"
#define KDATH_SERVICE KOREDLG_SERVICE "/atheos"
#define KDATH_SERVICE_DESCRIPTION "AtheOS-based '" KOREDLG_SERVICE "' service"

using namespace os;

KoreDlg_ath::KoreDlg_ath()
{
    _kdathVersion = new Version(KDATH_MAJOR,KDATH_MINOR,KDATH_REVISION,KDATH_VERSION);
    _kdathAPIVersion = new Version(KDATH_API_MAJOR,KDATH_API_MINOR,KDATH_API_REVISION,KDATH_API_VERSION);
    _kdathInfo = new Info(this, KDATH_NAME, KDATH_TYPE, KDATH_DESCRIPTION, _kdathVersion, _kdathAPIVersion);
    setInfo(_kdathInfo);
    _kdathService = new Service(this, KDATH_SERVICE, KDATH_SERVICE_DESCRIPTION);
    addService(_kdathService);
    _kdService = new Service(this, KOREDLG_SERVICE, KDATH_SERVICE_DESCRIPTION);
    addService(_kdService);
}
KoreDlg_ath::~KoreDlg_ath()
{
    delete _kdathInfo;
    delete _kdathVersion;
    delete _kdathAPIVersion;
    delete _kdathService;
    delete _kdService;
}

void KoreDlg_ath::showMessage(const char *msg)
{
    new Application("application/x-vnd.koredlg-atheos");
    Alert *dlg = new Alert(KDATH_NAME, msg, 0,"Ok", NULL);
    dlg->Go();
}
