/* @(#) dbmysql.c 1.6 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_DBMYSQL_C "@(#) nitehawk@localhost.1ststep.net|lib/vm/dbmysql.c|20000823031749|28409 @(#)"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"

/* This file implements the linkage between koala and mysql.  The API in this
 * file should *NOT* be called from outside of the VM library.
 */

/* Global variables */

/* Module data */
module_t dbmysqlmodule =
{
	"DB Mysql",
	"@(#) dbmysql.c 1.6 @(#)",
	MODSTATE_UNDEFINED,
	dbmysqlstartup,
	dbmysqllinkup,
	dbmysqlshutdown
};

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* dbstartup - Startup db driver.  This should do things like prepare the
 * variables that connect us to an external SQL server.
 */
int dbmysqlstartup(void)
{
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
	if (!(dbmysqlmodule.state == MODSTATE_UNDEFINED ||
			dbmysqlmodule.state == MODSTATE_STOPPED))
		return VMBADSTATE;
	/* Reflect that we are starting up */
	dbmysqlmodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Log a message */
	logmsg(LOGINFO, "Starting mysql client driver");

	/* All done with startup */
	dbmysqlmodule.state = MODSTATE_STARTED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* vmlinkup - Create connection to external database or load disk indexes and
 * hashtables
 */
int dbmysqllinkup(void)
{
	char *mysqlhost = NULL;	// Will be null if connecting to localhost
	char *mysqluser = NULL;
	char *mysqlpass = NULL;
	char *mysqldb = NULL;
	bool enablemysql = FALSE;
	int mysqlport = 0;
	/* Casts in this definition are just to prevent compiler warnings */
	confoption_t copt[] =
	{
		{"ENABLE", OPT_BOOL, {(char**)&enablemysql}},
		{"HOST", OPT_STRING, {&mysqlhost}},
		{"USER", OPT_STRING, {&mysqluser}},
		{"PASSWORD", OPT_STRING, {&mysqlpass}},
		{"DATABASE", OPT_STRING, {&mysqldb}},
		{"PORT", OPT_UINT, {(char **)&mysqlport}},
	};
	int numopts = 1;
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
	if (dbmysqlmodule.state != MODSTATE_STARTED)
		return VMBADSTATE;
	/* show that we are doing linkup */
	dbmysqlmodule.state = MODSTATE_LINKUPINPROGRESS;

	/* Get mysql options from config file */
	confgetoptionsfromsection("KDBMySQL", copt, numopts);

	if (enablemysql)
	{
		/* Since the mysql database is enabled, we need to connect to the
		 * server.  If we can connect successfully, then we can now use the
		 * mysql database as our backend database */
		logmsg(LOGINFO, "Connecting to database");
	}

	/* Linkup complete */
	dbmysqlmodule.state = MODSTATE_LINKED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbshutdown - close off the database and clean up any external connections
 */
int dbmysqlshutdown(void)
{
	/* Can't shutdown unless we are currently 'linked' */
	if (dbmysqlmodule.state != MODSTATE_LINKED)
		return VMBADSTATE;
	/* show that we are doing shutdown */
	dbmysqlmodule.state = MODSTATE_SHUTDOWNINPROGRESS;

	/* shutdown complete */
	dbmysqlmodule.state = MODSTATE_STOPPED;

	/* Everything Happy :) */
	return VMSUCCESS;
}

/* dbmysqlbuilddb - Builds mysql object tables
 * 	Should only be called to entirely wipe out the object database
 * 	This should not be called unless we have already done linkup to the
 * 	database server */
int dbmysqlbuilddb(void)
{
	char dropobjtable1[] = "drop table if exists mainobjtable";
	char dropobjtable2[] = "drop table if exists largeobjtable";
	char dropobjtable3[] = "drop table if exists objtracker";
	char mainobjtablestmt[] = "create table mainobjtable (objhash int unsigned"
		" primary key,  obj mediumblob not null)";
	char largeobjtablestmt[] = "create table largeobjtable (objhash int"
		" unsigned primary key,  obj longblob not null)";
	char objtrackerstmt[] = "create table objtracker (objhash int unsigned"
		" primary key );";

	return VMSUCCESS;
}
