h53566
s 00000/00000/00119
d D 1.11 00/11/04 19:13:56 nitehawk 12 11
c Rename: src/client/commandcomms.c -> lib/basecommand/comms.c
cC
cK30753
cPlib/basecommand/comms.c
e
s 00000/00097/00119
d D 1.10 00/11/04 19:07:45 nitehawk 11 10
c remove defunct command handlers
cC
cK15092
e
s 00099/00001/00117
d D 1.9 00/11/04 18:51:42 nitehawk 10 9
c Clone old command handlers into new prototypes which include
c argument list.
cC
cHwinghove.1ststep.net
cK55546
cZ-08:00
e
s 00003/00003/00115
d D 1.8 00/08/26 19:52:49 nitehawk 9 8
c convert all logging calls into logmsg
cC
cHlocalhost.1ststep.net
cK11338
cZ-07:00
e
s 00000/00000/00118
d D 1.7 00/03/07 11:48:10 nitehawk 8 7
c Turn on SCCS flag
cC
cK15821
cX0xa1
e
s 00007/00006/00111
d D 1.6 00/02/23 23:34:58 nitehawk 7 6
c Convert direct memory calls to wrapper functions
cC
cHwinghove.1ststep.net
cK09520
cZ-08:00
e
s 00001/00001/00116
d D 1.5 00/02/21 17:38:20 nitehawk 6 5
c Fix off by one bug in do_say
cC
cHparanor.1ststep.net
cK01093
cZ+00:00
e
s 00000/00000/00117
d D 1.4 00/02/10 09:21:12 nitehawk 5 4
c Rename: src/commandcomms.c -> src/client/commandcomms.c
cC
cK13258
cPsrc/client/commandcomms.c
e
s 00011/00008/00106
d D 1.3 00/02/04 12:36:12 nitehawk 4 3
c Say now echo's say text back to player
cC
cK01251
e
s 00093/00000/00021
d D 1.2 00/02/01 18:42:58 nitehawk 3 2
c Added say command
cC
cK62493
e
s 00021/00000/00000
d D 1.1 00/02/01 15:50:53 nitehawk 2 1
cF1
cK35392
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/01 15:50:53 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/commandcomms.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK22604
cPsrc/commandcomms.c
cR47ce32e9c2bfeafd
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDCOMMS_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "memory.h"
#include "llist.h"
I 3
#include "log.h"
I 10
#include "kparser.h"
E 10
E 3

I 3
/* Handler for 'say' command */
D 10
koalaerror do_say(pdescriptor desc)
E 10
I 10
koalaerror do_say(pdescriptor desc, argument *arglist[])
{
	char linemods[] = " says, ''\r\n";
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	char *sayline;
	char *linecur;
	int len = LINELENSTEP;
	koalaerror kerr;
	int saylen;
	char *output;

	/* Read the line from the buffer */
	sayline = kmalloc(len, ALLOC_TEMP);
	if (sayline == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for line");
		return KENOMEM;
	}
	linecur = sayline;

	/* Loop until we have the entire line */
	while ((kerr = buffer_readline(desc, linecur, LINELENSTEP)) == KENOMEM)
	{
		linecur = krealloc(sayline, len + LINELENSTEP, ALLOC_TEMP);
		if (sayline == NULL)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line");
			return KENOMEM;
		}
		sayline = linecur;
		linecur = sayline + len;
		len += LINELENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* No data buffered, fall out */
		kmfree(sayline, ALLOC_TEMP);
		return KESUCCESS;
	}

	/* Did we actually get something to say? */
	if (strlen(sayline) == 0)
	{
		kmfree(sayline, ALLOC_TEMP);
		buffer_queue(desc, "What do you want to say?\r\n",
				strlen("What do you want to say?\r\n"));
		return KESUCCESS;
	}

	/* Figure out how much space we need in the string we are sending out */
	saylen = strlen(linemods) + 30 /*(max player name)*/
		+ strlen(sayline);

	/* Allocate memory for the output string */
	output = kmalloc(saylen + 2, ALLOC_TEMP);
	if (output == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for line");
		return KENOMEM;
	}

	/* Get master list head */
	tmplist = getdescriptorlist();
	for (; tmplist; tmplist = listnextnode(tmplist))
	{
		tmpdesc = tmplist->data.desc;

		if (tmpdesc == desc)
		{
			/* Prepare output string */
			snprintf(output, saylen + 1, "You say, '%s'\r\n",
					sayline);
		}
		else
		{
			/* Prepare output string */
			snprintf(output, saylen + 1, "%s says, '%s'\r\n",
					desc->data.character->name, sayline);
		}

		if (tmpdesc->type != DESCRIPTOR_PLAYER)
		{
			continue;
		}

		/* This descriptor is a player, send the message to them */
		buffer_queue(tmpdesc, output, saylen);
	}

	kmfree(output, ALLOC_TEMP);
	kmfree(sayline, ALLOC_TEMP);

	return KESUCCESS;
}
D 11

/* Handler for 'say' command */
koalaerror do_oldsay(pdescriptor desc)
E 10
{
	char linemods[] = " says, ''\r\n";
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	char *sayline;
	char *linecur;
	int len = LINELENSTEP;
	koalaerror kerr;
	int saylen;
	char *output;

	/* Read the line from the buffer */
D 7
	sayline = malloc(len);
E 7
I 7
	sayline = kmalloc(len, ALLOC_TEMP);
E 7
	if (sayline == NULL)
	{
D 9
		logerr("Unable to allocate memory for line");
E 9
I 9
		logmsg(LOGCRIT, "Unable to allocate memory for line");
E 9
		return KENOMEM;
	}
	linecur = sayline;

	/* Loop until we have the entire line */
	while ((kerr = buffer_readline(desc, linecur, LINELENSTEP)) == KENOMEM)
	{
D 7
		linecur = realloc(sayline, len + LINELENSTEP);
E 7
I 7
		linecur = krealloc(sayline, len + LINELENSTEP, ALLOC_TEMP);
E 7
		if (sayline == NULL)
		{
D 9
			logerr("Unable to allocate memory for line");
E 9
I 9
			logmsg(LOGCRIT, "Unable to allocate memory for line");
E 9
			return KENOMEM;
		}
		sayline = linecur;
D 6
		linecur = sayline + len - 1;
E 6
I 6
		linecur = sayline + len;
E 6
		len += LINELENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* No data buffered, fall out */
D 7
		free(sayline);
E 7
I 7
		kmfree(sayline, ALLOC_TEMP);
E 7
		return KESUCCESS;
	}

	/* Did we actually get something to say? */
	if (strlen(sayline) == 0)
	{
D 7
		free(sayline);
E 7
I 7
		kmfree(sayline, ALLOC_TEMP);
E 7
		buffer_queue(desc, "What do you want to say?\r\n",
				strlen("What do you want to say?\r\n"));
		return KESUCCESS;
	}

	/* Figure out how much space we need in the string we are sending out */
D 4
	saylen = strlen(linemods) + strlen(desc->data.character->name)
		+ strlen(sayline) - 1;
E 4
I 4
	saylen = strlen(linemods) + 30 /*(max player name)*/
		+ strlen(sayline);
E 4

	/* Allocate memory for the output string */
D 7
	output = malloc(saylen + 2);
E 7
I 7
	output = kmalloc(saylen + 2, ALLOC_TEMP);
E 7
	if (output == NULL)
	{
D 9
		logerr("Unable to allocate memory for line");
E 9
I 9
		logmsg(LOGCRIT, "Unable to allocate memory for line");
E 9
		return KENOMEM;
	}

D 4
	/* Prepare output string */
	snprintf(output, saylen + 1, "%s says, '%s'\r\n",
			desc->data.character->name, sayline + 1);
	free(sayline);

E 4
	/* Get master list head */
	tmplist = getdescriptorlist();
	for (; tmplist; tmplist = listnextnode(tmplist))
	{
		tmpdesc = tmplist->data.desc;

		if (tmpdesc == desc)
		{
D 4
			continue;
E 4
I 4
			/* Prepare output string */
			snprintf(output, saylen + 1, "You say, '%s'\r\n",
					sayline);
		}
		else
		{
			/* Prepare output string */
			snprintf(output, saylen + 1, "%s says, '%s'\r\n",
					desc->data.character->name, sayline);
E 4
		}

		if (tmpdesc->type != DESCRIPTOR_PLAYER)
		{
			continue;
		}

		/* This descriptor is a player, send the message to them */
		buffer_queue(tmpdesc, output, saylen);
	}

D 7
	free(output);
E 7
I 7
	kmfree(output, ALLOC_TEMP);
	kmfree(sayline, ALLOC_TEMP);
E 7

	return KESUCCESS;
}
E 11
E 3
E 2
I 1
E 1
