/***************************************************************************
 *
 * knetworkmanager.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Timo Hoenig     <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson <wstephenson@suse.de>, <wstephenson@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_DIALOGFAB_H
#define KNETWORKMANAGER_DIALOGFAB_H

#include <kdialogbase.h>

#include "knetworkmanager.h"

class NetworkChoiceWidget;
class NetworkLabelWidget;
class CryptoWidget;
class DeviceStore;

class WirelessDialog : public KDialogBase
{
	Q_OBJECT

	public:
	  WirelessDialog  (QWidget * parent = 0, const char *name = 0, bool modal = FALSE, WFlags fl = 0, KNetworkManager* ctx = NULL);
	  virtual ~WirelessDialog ();

	protected slots:
	  void slotChangeSecretEchoMode  (bool);
	  void slotEncryptionToggled     (bool);
	  void leditSecret_textChanged   (const QString &);
	  void comboEncryption_activated (int);
	
	  /* WEP */
	  void groupWEPAdvanced_toggled      (bool);
	  void comboAuthentication_activated (int);

	  /* WPA Personal */
	  void groupWPAAdvanced_toggled   (bool);
	  void comboWPAProtocol_activated (int);
	  void radioButtonWPA1_toggled    (bool);
	  void radioButtonWPA2_toggled    (bool);

	  /* WPA Enterprise */
	  void groupWPAEAPAdvanced_toggled (bool);
	  void EAPrbWPA1_toggled (bool);
	  void EAPrbWPA2_toggled (bool);
	  void EAPcomboMethod_activated (int);
	  void EAPleditIdentity_textChanged (const QString &);
	  void EAPleditPassword_textChanged (const QString &);
	  void EAPleditAnonIdentity_textChanged (const QString &);
	  void EAPurlClient_textChanged (const QString &);
	  void EAPurlCA_textChanged (const QString &);
	  void EAPurlPrivate_textChanged (const QString &);
	  void EAPleditPrivatePassword_textChanged (const QString &);
	  void EAPcbShow_toggled (bool);

	protected:
	  void connectCryptoWidget (void);
	  virtual void updateModel (void);
	  
	  QMap<int, Encryption*> _encryptionMap;
	  int _id_disabled;
	  int _id_wep_passphrase;
	  int _id_wep_hex;
	  int _id_wep_ascii;
	  int _id_wpa_wpa2personal;
	  int _id_wpa_wpa2enterprise;

	  int _id_wpa_personal_auto;
	  int _id_wpa_personal_tkip;
	  int _id_wpa_personal_ccmp;

	  Device*  _dev;
	  Network* _net;

	  KNetworkManager* _ctx;

	  CryptoWidget* cryptoWidget;
};


class AcquirePasswordDialog : public WirelessDialog
{
	Q_OBJECT

	public:
	  AcquirePasswordDialog (QWidget * parent = 0, const char *name = 0,
				 bool modal = false, WFlags fl = 0,
				 KNetworkManager* ctx = NULL,
				 QString obj_path = NULL, QString net_path = NULL,
				 QString essid = NULL);
	
	  virtual ~AcquirePasswordDialog ();

	signals:
	  void destroyActivationStage (void);
	  void sendPassphrase         (Network*);
	  void sendPassphraseError    (void);

	protected slots:
	  void slotDeviceStoreChanged(DeviceStore *);
	  void comboEncryptionFill (void);
	  void slotOk();
	  void invalidateSecretMap    (void);
	  
	protected:  
	  void configureCryptoWidget();
	  
	  QString _obj_path;
	  QString _net_path;
	  QString _essid;
};

/**
 * This is the dialog that shows when you 'Connect to other wireless network' 
 */
class NewWirelessNetworkDialog : public WirelessDialog
{
	Q_OBJECT

	public:
	  NewWirelessNetworkDialog  (QWidget * parent = 0,
				     const char *name = "newnetworkdialog",
				     bool modal = FALSE, WFlags fl = 0,
				     KNetworkManager* ctx = NULL);
	  virtual ~NewWirelessNetworkDialog ();

	signals:
	  void activateNetwork (Network*, Device*); 

	protected:
	  void comboDeviceFill (void);
	  void comboEncryptionFill (void);
	  virtual void updateModel();

	  QMap<int, Device*> _deviceMap;

	protected slots:
	  void leditEssid_textChanged    (const QString &);

	  void slotOk();
	private:
	  NetworkChoiceWidget* netWidget;
};

#endif /* KNETWORKMANAGER_DIALOGFAB_H */
