/***************************************************************************
                                 knetload.cpp
                             -------------------                                         
    begin                : Mon Aug  9 14:30:56 GMT+1 1999
                                           
    copyright            : (C) 1999 by Markus Gustavsson                         
    email                : mighty@fragzone.se                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knetload.h"

KNETLoad::KNETLoad(QWidget *parent, const char *name) : KTMainWindow(name)
{
	parent = (QWidget *) 0;

	/* Alloc memory for some strings. */

	device = (char *) calloc(64, sizeof(char));
	tmp = (char *) calloc(256, sizeof(char));

	/* Create the /proc reading class. */

	proc = new Proc();

	/* QTimer for update interval. */

	t = new QTimer(this);
	connect(t, SIGNAL(timeout()), this, SLOT(step()));

	/* Create tooltip lookalike popup window. */

	popup = new PopUp();
	connect(popup, SIGNAL(clicked()), this, SLOT(hidePopUp()));
	connect(popup, SIGNAL(savePos()), this, SLOT(savePopUpPos()));

	/* Create the Panel Docking diagrams. */

	dockIn = new Dock(this);
	dockOut = new Dock(this);

	dockIn->setDirection(FALSE);
	dockOut->setDirection(TRUE);

	connect(dockIn, SIGNAL(mouseClick(QMouseEvent *)), this, SLOT(activateMenu(QMouseEvent *)));
	connect(dockOut, SIGNAL(mouseClick(QMouseEvent *)), this, SLOT(activateMenu(QMouseEvent *)));

	/* Initialize Config system. */

	config = KGlobal::config();
	config->setGroup("General Options");

	colorIn = config->readNumEntry("ColorIn", 1);
	colorOut = config->readNumEntry("ColorOut", 3);
	speed = config->readNumEntry("Speed", 1000);
	scale = config->readNumEntry("Scale", 10000000);
	scaleOut = config->readNumEntry("ScaleOut", 0); // Zero = Same as In
	diagram = config->readNumEntry("Diagram", 2);
	strcpy(device, config->readEntry("Device", "eth0").latin1());
	grid = config->readBoolEntry("Grid", TRUE);
	active = config->readBoolEntry("Active", TRUE);
	text = config->readBoolEntry("Text", TRUE);
	soft = config->readBoolEntry("Soft", FALSE);
	popupX = config->readNumEntry("PopupX", 0);
	popupY = config->readNumEntry("PopupY", 0);
	popupOn = config->readBoolEntry("PopupActive", FALSE);

	/* Load Icons for menues. */

	KStandardDirs *stddirs = KGlobal::dirs();

		/* Color Nyances Pixmaps. */

	PixBlue.load(stddirs->findResource("data", "knetload/icons/blue.xpm"));
	PixBlueOn.load(stddirs->findResource("data", "knetload/icons/blueon.xpm"));
	PixGreen.load(stddirs->findResource("data", "knetload/icons/green.xpm"));
	PixGreenOn.load(stddirs->findResource("data", "knetload/icons/greenon.xpm"));
	PixOrange.load(stddirs->findResource("data", "knetload/icons/orange.xpm"));
	PixOrangeOn.load(stddirs->findResource("data", "knetload/icons/orangeon.xpm"));
	PixPurple.load(stddirs->findResource("data", "knetload/icons/purple.xpm"));
	PixPurpleOn.load(stddirs->findResource("data", "knetload/icons/purpleon.xpm"));
	PixRed.load(stddirs->findResource("data", "knetload/icons/red.xpm"));
	PixRedOn.load(stddirs->findResource("data", "knetload/icons/redon.xpm"));
	PixTurquoise.load(stddirs->findResource("data", "knetload/icons/turquoise.xpm"));
	PixTurquoiseOn.load(stddirs->findResource("data", "knetload/icons/turquoiseon.xpm"));
	PixYellow.load(stddirs->findResource("data", "knetload/icons/yellow.xpm"));
	PixYellowOn.load(stddirs->findResource("data", "knetload/icons/yellowon.xpm"));

		/* Diagram Styles Pixmaps. */

	PixLines.load(stddirs->findResource("data", "knetload/icons/lines.xpm"));
	PixLinesOn.load(stddirs->findResource("data", "knetload/icons/lineson.xpm"));
	PixBars.load(stddirs->findResource("data", "knetload/icons/bars.xpm"));
	PixBarsOn.load(stddirs->findResource("data", "knetload/icons/barson.xpm"));
	PixShaded.load(stddirs->findResource("data", "knetload/icons/shaded.xpm"));
	PixShadedOn.load(stddirs->findResource("data", "knetload/icons/shadedon.xpm"));

		/* Input Device Pixmaps. */

	Pixlo.load(stddirs->findResource("data", "knetload/icons/devlo.xpm"));
	PixloOn.load(stddirs->findResource("data", "knetload/icons/devloon.xpm"));
	Pixeth0.load(stddirs->findResource("data", "knetload/icons/deveth0.xpm"));
	Pixeth0On.load(stddirs->findResource("data", "knetload/icons/deveth0on.xpm"));
	Pixippp0.load(stddirs->findResource("data", "knetload/icons/devippp0.xpm"));
	Pixippp0On.load(stddirs->findResource("data", "knetload/icons/devippp0on.xpm"));
	Pixppp0.load(stddirs->findResource("data", "knetload/icons/devppp0.xpm"));
	Pixppp0On.load(stddirs->findResource("data", "knetload/icons/devppp0on.xpm"));
	PixOther.load(stddirs->findResource("data", "knetload/icons/devother.xpm"));
	PixOtherOn.load(stddirs->findResource("data", "knetload/icons/devotheron.xpm"));

		/* Brother Pixmaps. */

	PixLabels.load(stddirs->findResource("data", "knetload/icons/labels.xpm"));
	PixLabelsOn.load(stddirs->findResource("data", "knetload/icons/labelson.xpm"));
	PixGrid.load(stddirs->findResource("data", "knetload/icons/grid.xpm"));
	PixGridOn.load(stddirs->findResource("data", "knetload/icons/gridon.xpm"));
	PixAct.load(stddirs->findResource("data", "knetload/icons/active.xpm"));
	PixActOn.load(stddirs->findResource("data", "knetload/icons/activeon.xpm"));
	PixSoft.load(stddirs->findResource("data", "knetload/icons/soft.xpm"));
	PixSoftOn.load(stddirs->findResource("data", "knetload/icons/softon.xpm"));
	PixColIn.load(stddirs->findResource("data", "knetload/icons/colorin.xpm"));
	PixColOut.load(stddirs->findResource("data", "knetload/icons/colorout.xpm"));
	PixArrow.load(stddirs->findResource("data", "knetload/icons/arrow.xpm"));
	PixTrans.load(stddirs->findResource("data", "knetload/icons/trans.xpm"));

		/* Other mixed settings Pixmaps. */

	PixClear.load(stddirs->findResource("data", "knetload/icons/clear.xpm"));
	PixQuit.load(stddirs->findResource("data", "knetload/icons/exit.xpm"));
	PixAbout.load(stddirs->findResource("data", "knetload/icons/about.xpm"));
	PixHelp.load(stddirs->findResource("data", "knetload/icons/help.xpm"));
	PixSpeedArrow.load(stddirs->findResource("data", "knetload/icons/speedarrow.xpm"));
	PixStyle.load(stddirs->findResource("data", "knetload/icons/style.xpm"));
	PixDevice.load(stddirs->findResource("data", "knetload/icons/device.xpm"));
	PixScaling.load(stddirs->findResource("data", "knetload/icons/scaling.xpm"));


	/* Menu System Initializing. */

	ColorIn = new QPopupMenu();

	colorIdBlueIn = ColorIn->insertItem(PixBlue, "Blue ", this, SLOT(setColBlueIn()));
	colorIdGreenIn = ColorIn->insertItem(PixGreen, "Green ", this, SLOT(setColGreenIn()));
	colorIdOrangeIn = ColorIn->insertItem(PixOrange, "Orange ", this, SLOT(setColOrangeIn()));
	colorIdPurpleIn = ColorIn->insertItem(PixPurple, "Purple ", this, SLOT(setColPurpleIn()));
	colorIdRedIn = ColorIn->insertItem(PixRed, "Red ", this, SLOT(setColRedIn()));
	colorIdTurquoiseIn = ColorIn->insertItem(PixTurquoise, "Turquo ", this, SLOT(setColTurquoiseIn()));
	colorIdYellowIn = ColorIn->insertItem(PixYellow, "Yellow ", this, SLOT(setColYellowIn()));

	ColorOut = new QPopupMenu();

	colorIdBlueOut = ColorOut->insertItem(PixBlue, "Blue ", this, SLOT(setColBlueOut()));
	colorIdGreenOut = ColorOut->insertItem(PixGreen, "Green ", this, SLOT(setColGreenOut()));
	colorIdOrangeOut = ColorOut->insertItem(PixOrange, "Orange ", this, SLOT(setColOrangeOut()));
	colorIdPurpleOut = ColorOut->insertItem(PixPurple, "Purple ", this, SLOT(setColPurpleOut()));
	colorIdRedOut = ColorOut->insertItem(PixRed, "Red ", this, SLOT(setColRedOut()));
	colorIdTurquoiseOut = ColorOut->insertItem(PixTurquoise, "Turquo ", this, SLOT(setColTurquoiseOut()));
	colorIdYellowOut = ColorOut->insertItem(PixYellow, "Yellow ", this, SLOT(setColYellowOut()));

	Device = new QPopupMenu();

	deviceIdlo = Device->insertItem(Pixlo, "lo ", this, SLOT(setDevicelo()));
	deviceIdeth0 = Device->insertItem(Pixeth0, "eth0 ", this, SLOT(setDeviceeth0()));
	deviceIdippp0 = Device->insertItem(Pixippp0, "ippp0 ", this, SLOT(setDeviceippp0()));
	deviceIdppp0 = Device->insertItem(Pixppp0, "ppp0 ", this, SLOT(setDeviceppp0()));
	Device->insertSeparator();
	deviceIduser = Device->insertItem(PixOther, "Other ", this, SLOT(setDeviceuser()));

	Speed = new QPopupMenu();

	speedId100 = Speed->insertItem(PixTrans, "100ms ", this, SLOT(setSpeed100()));
	speedId150 = Speed->insertItem(PixTrans, "150ms ", this, SLOT(setSpeed150()));
	speedId200 = Speed->insertItem(PixTrans, "200ms ", this, SLOT(setSpeed200()));
	speedId250 = Speed->insertItem(PixTrans, "250ms ", this, SLOT(setSpeed250()));
	speedId300 = Speed->insertItem(PixTrans, "300ms ", this, SLOT(setSpeed300()));
	speedId400 = Speed->insertItem(PixTrans, "400ms ", this, SLOT(setSpeed400()));
	speedId600 = Speed->insertItem(PixTrans, "600ms ", this, SLOT(setSpeed600()));
	speedId800 = Speed->insertItem(PixTrans, "800ms ", this, SLOT(setSpeed800()));
	speedId1000 = Speed->insertItem(PixTrans, "1000ms ", this, SLOT(setSpeed1000()));
	speedId1200 = Speed->insertItem(PixTrans, "1200ms ", this, SLOT(setSpeed1200()));
	speedId1500 = Speed->insertItem(PixTrans, "1500ms ", this, SLOT(setSpeed1500()));
	speedId2000 = Speed->insertItem(PixTrans, "2000ms ", this, SLOT(setSpeed2000()));
	speedId2500 = Speed->insertItem(PixTrans, "2500ms ", this, SLOT(setSpeed2500()));
	speedId3000 = Speed->insertItem(PixTrans, "3000ms ", this, SLOT(setSpeed3000()));
	speedId4000 = Speed->insertItem(PixTrans, "4000ms ", this, SLOT(setSpeed4000()));
	speedId5000 = Speed->insertItem(PixTrans, "5000ms ", this, SLOT(setSpeed5000()));

	Scale = new QPopupMenu();

	scaleId288K = Scale->insertItem(PixTrans, "28.8KBit ", this, SLOT(setScale288K()));
	scaleId336K = Scale->insertItem(PixTrans, "33.6KBit ", this, SLOT(setScale336K()));
	scaleId56K = Scale->insertItem(PixTrans, "56KBit ", this, SLOT(setScale56K()));
	scaleId64K = Scale->insertItem(PixTrans, "64KBit ", this, SLOT(setScale64K()));
	scaleId128K = Scale->insertItem(PixTrans, "128KBit ", this, SLOT(setScale128K()));
	scaleId256K = Scale->insertItem(PixTrans, "256KBit ", this, SLOT(setScale256K()));
	scaleId512K = Scale->insertItem(PixTrans, "512KBit ", this, SLOT(setScale512K()));
	scaleId1M = Scale->insertItem(PixTrans, "1MBit ", this, SLOT(setScale1M()));
	scaleId2M = Scale->insertItem(PixTrans, "2MBit ", this, SLOT(setScale2M()));
	scaleId10M = Scale->insertItem(PixTrans, "10MBit ", this, SLOT(setScale10M()));
	Scale->insertSeparator();
	scaleIduser = Scale->insertItem(PixOther, "Other ", this, SLOT(setScaleuser()));

	ScaleOut = new QPopupMenu();

	scaleOutId288K = ScaleOut->insertItem(PixTrans, "28.8KBit ", this, SLOT(setScaleOut288K()));
	scaleOutId336K = ScaleOut->insertItem(PixTrans, "33.6KBit ", this, SLOT(setScaleOut336K()));
	scaleOutId56K = ScaleOut->insertItem(PixTrans, "56KBit ", this, SLOT(setScaleOut56K()));
	scaleOutId64K = ScaleOut->insertItem(PixTrans, "64KBit ", this, SLOT(setScaleOut64K()));
	scaleOutId128K = ScaleOut->insertItem(PixTrans, "128KBit ", this, SLOT(setScaleOut128K()));
	scaleOutId256K = ScaleOut->insertItem(PixTrans, "256KBit ", this, SLOT(setScaleOut256K()));
	scaleOutId512K = ScaleOut->insertItem(PixTrans, "512KBit ", this, SLOT(setScaleOut512K()));
	scaleOutId1M = ScaleOut->insertItem(PixTrans, "1MBit ", this, SLOT(setScaleOut1M()));
	scaleOutId2M = ScaleOut->insertItem(PixTrans, "2MBit ", this, SLOT(setScaleOut2M()));
	scaleOutId10M = ScaleOut->insertItem(PixTrans, "10MBit ", this, SLOT(setScaleOut10M()));
	ScaleOut->insertSeparator();
	scaleOutIduser = ScaleOut->insertItem(PixOther, "Other ", this, SLOT(setScaleOutuser()));
	ScaleOut->insertSeparator();
	scaleOutIdSame = ScaleOut->insertItem(PixTrans, "Same as In ", this, SLOT(setScaleOutSame()));

	// Add ScaleOut to end of Scale
	Scale->insertSeparator();
	Scale->insertItem(PixScaling, "Scale Out", ScaleOut);

	Diagram = new QPopupMenu();

	diagramIdLines = Diagram->insertItem(PixLines, "Lines ", this, SLOT(setDiagramLines()));
	diagramIdBars = Diagram->insertItem(PixBars, "Bars ", this, SLOT(setDiagramBars()));
	diagramIdShaded = Diagram->insertItem(PixShaded, "Shade ", this, SLOT(setDiagramShaded()));

	Menu = new QPopupMenu();

	HelpMenu = new KHelpMenu(qApp->desktop(), kapp->aboutData());

	menuIdSoft = Menu->insertItem((soft) ? PixSoftOn : PixSoft, "Soft", this, SLOT(setSoft()));
	menuIdText = Menu->insertItem((text) ? PixLabelsOn : PixLabels, "Labels", this, SLOT(setText()));
	menuIdGrid = Menu->insertItem((grid) ? PixGridOn : PixGrid, "Grid", this, SLOT(setGrid()));
	menuIdActive = Menu->insertItem((active) ? PixActOn : PixAct, "Active", this, SLOT(setActive()));
	Menu->insertItem(PixClear, "Clear", this, SLOT(clear()));
	Menu->insertSeparator();
	Menu->insertItem(PixColIn, "Col In", ColorIn);
	Menu->insertItem(PixColOut, "Col Out", ColorOut);
	Menu->insertItem(PixSpeedArrow, "Speed", Speed);
	Menu->insertItem(PixStyle, "Style", Diagram);
	Menu->insertItem(PixScaling, "Scaling", Scale);
	Menu->insertItem(PixDevice, "Device", Device);
	Menu->insertSeparator();
	Menu->insertItem(PixHelp, "Help", this, SLOT(showHelp()));
	Menu->insertItem(PixAbout, "About", HelpMenu, SLOT(aboutApplication()));
	Menu->insertItem(PixQuit, "Quit", kapp, SLOT(quit()));

	/* initialize configuration settings. */

	setColIn(colorIn);
	setColOut(colorOut);
	setSpeed(speed);
	setScale(scale);
	setScaleOut(scaleOut);
	setDiagram(diagram);
	setDevice(device);

	dockIn->setGrid(grid);
	dockOut->setGrid(grid);

	dockIn->setOn(active);
	dockOut->setOn(active);

	dockIn->setText(text);
	dockOut->setText(text);

	dockIn->setSoft(soft);
	dockOut->setSoft(soft);

	if(popupOn) showPopUp(QPoint(0, 0));

	/* Create the input dialogs. */

		/* User Specified Scaling Widgets. */

	scaleInput = new QWidget();
	scaleInput->setCaption("Scale");
	scaleInput->setIcon(QPixmap(stddirs->findResource("data", "knetload/icons/purple.xpm")));
	scaleInput->setMaximumSize(140, 70);
	scaleInput->setMinimumSize(140, 70);
	scaleEdit = new QLineEdit(scaleInput);
	scaleEdit->setGeometry(10, 10, 80, 20);
	scaleLabel = new QLabel(" KBit/s.", scaleInput);
	scaleLabel->setGeometry(93, 10, 44, 20);
	scaleBut = new QPushButton("Ok", scaleInput);
	scaleBut->setGeometry(10, 40, 55, 22);
	scaleButC = new QPushButton("Cancel", scaleInput);
	scaleButC->setGeometry(75, 40, 55, 22);

	connect(scaleBut, SIGNAL(clicked()), this, SLOT(readScale()));
	connect(scaleButC, SIGNAL(clicked()), this, SLOT(cancelScale()));

	scaleOutInput = new QWidget();
	scaleOutInput->setCaption("Scale Out");
	scaleOutInput->setIcon(QPixmap(stddirs->findResource("data", "knetload/icons/purple.xpm")));
	scaleOutInput->setMaximumSize(140, 70);
	scaleOutInput->setMinimumSize(140, 70);
	scaleOutEdit = new QLineEdit(scaleOutInput);
	scaleOutEdit->setGeometry(10, 10, 80, 20);
	scaleOutLabel = new QLabel(" KBit/s.", scaleOutInput);
	scaleOutLabel->setGeometry(93, 10, 44, 20);
	scaleOutBut = new QPushButton("Ok", scaleOutInput);
	scaleOutBut->setGeometry(10, 40, 55, 22);
	scaleOutButC = new QPushButton("Cancel", scaleOutInput);
	scaleOutButC->setGeometry(75, 40, 55, 22);

	connect(scaleOutBut, SIGNAL(clicked()), this, SLOT(readScaleOut()));
	connect(scaleOutButC, SIGNAL(clicked()), this, SLOT(cancelScaleOut()));

		/* User specified Device Widget. */

	deviceInput = new QWidget();
	deviceInput->setCaption("Device");
	deviceInput->setIcon(QPixmap(stddirs->findResource("data", "knetload/icons/purple.xpm")));
	deviceInput->setMaximumSize(140, 70);
	deviceInput->setMinimumSize(140, 70);
	deviceEdit = new QLineEdit(deviceInput);
	deviceEdit->setGeometry(43, 10, 87, 20);
	deviceLabel = new QLabel("Dev:", deviceInput);
	deviceLabel->setGeometry(10, 10, 30, 20);
	deviceBut = new QPushButton("Ok", deviceInput);
	deviceBut->setGeometry(10, 40, 55, 22);
	deviceButC = new QPushButton("Cancel", deviceInput);
	deviceButC->setGeometry(75, 40, 55, 22);

	connect(deviceBut, SIGNAL(clicked()), this, SLOT(readDevice()));
	connect(deviceButC, SIGNAL(clicked()), this, SLOT(cancelDevice()));

	/* Get the Desktop widget, w/h is used for popup positions of User input Boxes. */

	desk = QApplication::desktop();

	deskX = desk->width();
	deskY = desk->height();
}

KNETLoad::~KNETLoad()
{
	free(device);
	free(tmp);
}

void KNETLoad::activateMenu(QMouseEvent *Event)
{
	if(Event->button() == RightButton) Menu->popup(Event->globalPos());
	if(Event->button() == LeftButton) {
		if(!popupOn) showPopUp(Event->globalPos());
		else hidePopUp();
	}
}

void KNETLoad::setColIn(int set)
{
	colorIn = set;

	config->writeEntry("ColorIn", colorIn);
	config->sync();

	dockIn->setCol(colorIn);

	ColorIn->changeItem(PixBlue, "Blue ", colorIdBlueIn);
	ColorIn->changeItem(PixGreen, "Green ", colorIdGreenIn);
	ColorIn->changeItem(PixOrange, "Orange ", colorIdOrangeIn);
	ColorIn->changeItem(PixPurple, "Purple ", colorIdPurpleIn);
	ColorIn->changeItem(PixRed, "Red ", colorIdRedIn);
	ColorIn->changeItem(PixTurquoise, "Turquo ", colorIdTurquoiseIn);
	ColorIn->changeItem(PixYellow, "Yellow ", colorIdYellowIn);

	switch(colorIn) {
		case 0: ColorIn->changeItem(PixBlueOn, "Blue ", colorIdBlueIn);
		break;
		case 1: ColorIn->changeItem(PixGreenOn, "Green ", colorIdGreenIn);
		break;
		case 2: ColorIn->changeItem(PixOrangeOn, "Orange ", colorIdOrangeIn);
		break;
		case 3: ColorIn->changeItem(PixPurpleOn, "Purple ", colorIdPurpleIn);
		break;
		case 4: ColorIn->changeItem(PixRedOn, "Red ", colorIdRedIn);
		break;
		case 5: ColorIn->changeItem(PixTurquoiseOn, "Turquo ", colorIdTurquoiseIn);
		break;
		case 6: ColorIn->changeItem(PixYellowOn, "Yellow ", colorIdYellowIn);
		break;
	}
}

void KNETLoad::setColBlueIn(void) { setColIn(0); }
void KNETLoad::setColGreenIn(void) { setColIn(1); }
void KNETLoad::setColOrangeIn(void) { setColIn(2); }
void KNETLoad::setColPurpleIn(void) { setColIn(3); }
void KNETLoad::setColRedIn(void) { setColIn(4); }
void KNETLoad::setColTurquoiseIn(void) { setColIn(5); }
void KNETLoad::setColYellowIn(void) { setColIn(6); }

void KNETLoad::setColOut(int set)
{
	colorOut = set;

	config->writeEntry("ColorOut", colorOut);
	config->sync();

	dockOut->setCol(colorOut);

	ColorOut->changeItem(PixBlue, "Blue ", colorIdBlueOut);
	ColorOut->changeItem(PixGreen, "Green ", colorIdGreenOut);
	ColorOut->changeItem(PixOrange, "Orange ", colorIdOrangeOut);
	ColorOut->changeItem(PixPurple, "Purple ", colorIdPurpleOut);
	ColorOut->changeItem(PixRed, "Red ", colorIdRedOut);
	ColorOut->changeItem(PixTurquoise, "Turquo ", colorIdTurquoiseOut);
	ColorOut->changeItem(PixYellow, "Yellow ", colorIdYellowOut);

	switch(colorOut) {
		case 0: ColorOut->changeItem(PixBlueOn, "Blue ", colorIdBlueOut);
		break;
		case 1: ColorOut->changeItem(PixGreenOn, "Green ", colorIdGreenOut);
		break;
		case 2: ColorOut->changeItem(PixOrangeOn, "Orange ", colorIdOrangeOut);
		break;
		case 3: ColorOut->changeItem(PixPurpleOn, "Purple ", colorIdPurpleOut);
		break;
		case 4: ColorOut->changeItem(PixRedOn, "Red ", colorIdRedOut);
		break;
		case 5: ColorOut->changeItem(PixTurquoiseOn, "Turquo ", colorIdTurquoiseOut);
		break;
		case 6: ColorOut->changeItem(PixYellowOn, "Yellow ", colorIdYellowOut);
		break;
	}

}

void KNETLoad::setColBlueOut(void) { setColOut(0); }
void KNETLoad::setColGreenOut(void) { setColOut(1); }
void KNETLoad::setColOrangeOut(void) { setColOut(2); }
void KNETLoad::setColPurpleOut(void) { setColOut(3); }
void KNETLoad::setColRedOut(void) { setColOut(4); }
void KNETLoad::setColTurquoiseOut(void) { setColOut(5); }
void KNETLoad::setColYellowOut(void) { setColOut(6); }

void KNETLoad::setSpeed(int set)
{
	speed = set;

	config->writeEntry("Speed", speed);
	config->sync();

	dockIn->setSpd(speed);
	dockOut->setSpd(speed);

	if(active) t->changeInterval(speed);

	Speed->changeItem(PixTrans, "100ms ", speedId100);
	Speed->changeItem(PixTrans, "150ms ", speedId150);
	Speed->changeItem(PixTrans, "200ms ", speedId200);
	Speed->changeItem(PixTrans, "250ms ", speedId250);
	Speed->changeItem(PixTrans, "300ms ", speedId300);
	Speed->changeItem(PixTrans, "400ms ", speedId400);
	Speed->changeItem(PixTrans, "600ms ", speedId600);
	Speed->changeItem(PixTrans, "800ms ", speedId800);
	Speed->changeItem(PixTrans, "1000ms ", speedId1000);
	Speed->changeItem(PixTrans, "1200ms ", speedId1200);
	Speed->changeItem(PixTrans, "1500ms ", speedId1500);
	Speed->changeItem(PixTrans, "2000ms ", speedId2000);
	Speed->changeItem(PixTrans, "2500ms ", speedId2500);
	Speed->changeItem(PixTrans, "3000ms ", speedId3000);
	Speed->changeItem(PixTrans, "4000ms ", speedId4000);
	Speed->changeItem(PixTrans, "5000ms ", speedId5000);

	switch(speed) {
	case 100: Speed->changeItem(PixArrow, "100ms ", speedId100);
	break;
	case 150: Speed->changeItem(PixArrow, "150ms ", speedId150);
	break;
	case 200: Speed->changeItem(PixArrow, "200ms ", speedId200);
	break;
	case 250: Speed->changeItem(PixArrow, "250ms ", speedId250);
	break;
	case 300: Speed->changeItem(PixArrow, "300ms ", speedId300);
	break;
	case 400: Speed->changeItem(PixArrow, "400ms ", speedId400);
	break;
	case 600: Speed->changeItem(PixArrow, "600ms ", speedId600);
	break;
	case 800: Speed->changeItem(PixArrow, "800ms ", speedId800);
	break;
	case 1000: Speed->changeItem(PixArrow, "1000ms ", speedId1000);
	break;
	case 1200: Speed->changeItem(PixArrow, "1200ms ", speedId1200);
	break;
	case 1500: Speed->changeItem(PixArrow, "1500ms ", speedId1500);
	break;
	case 2000: Speed->changeItem(PixArrow, "2000ms ", speedId2000);
	break;
	case 2500: Speed->changeItem(PixArrow, "2500ms ", speedId2500);
	break;
	case 3000: Speed->changeItem(PixArrow, "3000ms ", speedId3000);
	break;
	case 4000: Speed->changeItem(PixArrow, "4000ms ", speedId4000);
	break;
	case 5000: Speed->changeItem(PixArrow, "5000ms ", speedId5000);
	break;
	}
}

void KNETLoad::setSpeed100(void) { setSpeed(100); }
void KNETLoad::setSpeed150(void) { setSpeed(150); }
void KNETLoad::setSpeed200(void) { setSpeed(200); }
void KNETLoad::setSpeed250(void) { setSpeed(250); }
void KNETLoad::setSpeed300(void) { setSpeed(300); }
void KNETLoad::setSpeed400(void) { setSpeed(400); }
void KNETLoad::setSpeed600(void) { setSpeed(600); }
void KNETLoad::setSpeed800(void) { setSpeed(800); }
void KNETLoad::setSpeed1000(void) { setSpeed(1000); }
void KNETLoad::setSpeed1200(void) { setSpeed(1200); }
void KNETLoad::setSpeed1500(void) { setSpeed(1500); }
void KNETLoad::setSpeed2000(void) { setSpeed(2000); }
void KNETLoad::setSpeed2500(void) { setSpeed(2500); }
void KNETLoad::setSpeed3000(void) { setSpeed(3000); }
void KNETLoad::setSpeed4000(void) { setSpeed(4000); }
void KNETLoad::setSpeed5000(void) { setSpeed(5000); }

void KNETLoad::setScale(int set)
{
	scale = set;

	config->writeEntry("Scale", scale);
	config->sync();

	dockIn->setScale(scale);
	if(!scaleOut) dockOut->setScale(scale);

	Scale->changeItem(PixTrans, "28.8Kbit ", scaleId288K);
	Scale->changeItem(PixTrans, "33.6Kbit ", scaleId336K);
	Scale->changeItem(PixTrans, "56Kbit ", scaleId56K);
	Scale->changeItem(PixTrans, "64Kbit ", scaleId64K);
	Scale->changeItem(PixTrans, "128Kbit ", scaleId128K);
	Scale->changeItem(PixTrans, "256Kbit ", scaleId256K);
	Scale->changeItem(PixTrans, "512Kbit ", scaleId512K);
	Scale->changeItem(PixTrans, "1Mbit ", scaleId1M);
	Scale->changeItem(PixTrans, "2Mbit ", scaleId2M);
	Scale->changeItem(PixTrans, "10Mbit ", scaleId10M);
	Scale->changeItem(PixOther, "Other ", scaleIduser);

	switch(scale) {
		case 28800: Scale->changeItem(PixArrow, "28.8KBit ", scaleId288K);
		break;
		case 33600: Scale->changeItem(PixArrow, "33.6KBit ", scaleId336K);
		break;
		case 56000: Scale->changeItem(PixArrow, "56KBit ", scaleId56K);
		break;
		case 64000: Scale->changeItem(PixArrow, "64KBit ", scaleId64K);
		break;
		case 128000: Scale->changeItem(PixArrow, "128KBit ", scaleId128K);
		break;
		case 256000: Scale->changeItem(PixArrow, "256KBit ", scaleId256K);
		break;
		case 512000: Scale->changeItem(PixArrow, "512KBit ", scaleId512K);
		break;
		case 1000000: Scale->changeItem(PixArrow, "1MBit ", scaleId1M);
		break;
		case 2000000: Scale->changeItem(PixArrow, "2MBit ", scaleId2M);
		break;
		case 10000000: Scale->changeItem(PixArrow, "10MBit ", scaleId10M);
		break;
		default: {
			sprintf(tmp, "%dKBit ", scale / 1000);
			Scale->changeItem(PixOtherOn, tmp, scaleIduser);
		}
	}
}

void KNETLoad::setScale288K(void) { setScale(28800); }
void KNETLoad::setScale336K(void) { setScale(33600); }
void KNETLoad::setScale56K(void) { setScale(56000); }
void KNETLoad::setScale64K(void) { setScale(64000); }
void KNETLoad::setScale128K(void) { setScale(128000); }
void KNETLoad::setScale256K(void) { setScale(256000); }
void KNETLoad::setScale512K(void) { setScale(512000); }
void KNETLoad::setScale1M(void) { setScale(1000000); }
void KNETLoad::setScale2M(void) { setScale(2000000); }
void KNETLoad::setScale10M(void) { setScale(10000000); }

void KNETLoad::setScaleuser(void)
{
	scaleInput->show();
	scaleInput->move(deskX - 280, deskY - 280);
}

void KNETLoad::setScaleOut(int set)
{
	scaleOut = set;

	config->writeEntry("ScaleOut", scaleOut);
	config->sync();

	if(scaleOut) dockOut->setScale(scaleOut);
	else dockOut->setScale(scale);

	ScaleOut->changeItem(PixTrans, "28.8Kbit ", scaleOutId288K);
	ScaleOut->changeItem(PixTrans, "33.6Kbit ", scaleOutId336K);
	ScaleOut->changeItem(PixTrans, "56Kbit ", scaleOutId56K);
	ScaleOut->changeItem(PixTrans, "64Kbit ", scaleOutId64K);
	ScaleOut->changeItem(PixTrans, "128Kbit ", scaleOutId128K);
	ScaleOut->changeItem(PixTrans, "256Kbit ", scaleOutId256K);
	ScaleOut->changeItem(PixTrans, "512Kbit ", scaleOutId512K);
	ScaleOut->changeItem(PixTrans, "1Mbit ", scaleOutId1M);
	ScaleOut->changeItem(PixTrans, "2Mbit ", scaleOutId2M);
	ScaleOut->changeItem(PixTrans, "10Mbit ", scaleOutId10M);
	ScaleOut->changeItem(PixOther, "Other ", scaleOutIduser);
	ScaleOut->changeItem(PixTrans, "Same as In ", scaleOutIdSame);

	switch(scaleOut) {
		case 28800: ScaleOut->changeItem(PixArrow, "28.8KBit ", scaleOutId288K);
		break;
		case 33600: ScaleOut->changeItem(PixArrow, "33.6KBit ", scaleOutId336K);
		break;
		case 56000: ScaleOut->changeItem(PixArrow, "56KBit ", scaleOutId56K);
		break;
		case 64000: ScaleOut->changeItem(PixArrow, "64KBit ", scaleOutId64K);
		break;
		case 128000: ScaleOut->changeItem(PixArrow, "128KBit ", scaleOutId128K);
		break;
		case 256000: ScaleOut->changeItem(PixArrow, "256KBit ", scaleOutId256K);
		break;
		case 512000: ScaleOut->changeItem(PixArrow, "512KBit ", scaleOutId512K);
		break;
		case 1000000: ScaleOut->changeItem(PixArrow, "1MBit ", scaleOutId1M);
		break;
		case 2000000: ScaleOut->changeItem(PixArrow, "2MBit ", scaleOutId2M);
		break;
		case 10000000: ScaleOut->changeItem(PixArrow, "10MBit ", scaleOutId10M);
		break;
		case 0: ScaleOut->changeItem(PixArrow, "Same as In ", scaleOutIdSame);
		break;
		default: {
			sprintf(tmp, "%dKBit ", scaleOut / 1000);
			ScaleOut->changeItem(PixOtherOn, tmp, scaleOutIduser);
		}
	}
}

void KNETLoad::setScaleOut288K(void) { setScaleOut(28800); }
void KNETLoad::setScaleOut336K(void) { setScaleOut(33600); }
void KNETLoad::setScaleOut56K(void) { setScaleOut(56000); }
void KNETLoad::setScaleOut64K(void) { setScaleOut(64000); }
void KNETLoad::setScaleOut128K(void) { setScaleOut(128000); }
void KNETLoad::setScaleOut256K(void) { setScaleOut(256000); }
void KNETLoad::setScaleOut512K(void) { setScaleOut(512000); }
void KNETLoad::setScaleOut1M(void) { setScaleOut(1000000); }
void KNETLoad::setScaleOut2M(void) { setScaleOut(2000000); }
void KNETLoad::setScaleOut10M(void) { setScaleOut(10000000); }
void KNETLoad::setScaleOutSame(void) { setScaleOut(0); }

void KNETLoad::setScaleOutuser(void)
{
	scaleOutInput->show();
	scaleOutInput->move(deskX - 280, deskY - 280);
}

void KNETLoad::setDiagram(int set)
{
	diagram = set;

	config->writeEntry("Diagram", diagram);
	config->sync();

	dockIn->setFill(diagram);
	dockOut->setFill(diagram);

	Diagram->changeItem(PixLines, "Lines ", diagramIdLines);
	Diagram->changeItem(PixBars, "Bars ", diagramIdBars);
	Diagram->changeItem(PixShaded, "Shade ", diagramIdShaded);

	switch(diagram) {
		case 0: Diagram->changeItem(PixLinesOn, "Lines ", diagramIdLines);
		break;
		case 1: Diagram->changeItem(PixBarsOn, "Bars ", diagramIdBars);
		break;
		case 2: Diagram->changeItem(PixShadedOn, "Shade ", diagramIdShaded);
		break;
	}

}

void KNETLoad::setDiagramLines(void) { setDiagram(0); }
void KNETLoad::setDiagramBars(void) { setDiagram(1); }
void KNETLoad::setDiagramShaded(void) { setDiagram(2); }

void KNETLoad::setDevice(const char *set)
{
	strcpy(device, set);

	config->writeEntry("Device", device);
	config->sync();

	proc->setDev(device);

	Device->changeItem(Pixlo, "lo ", deviceIdlo);
	Device->changeItem(Pixeth0, "eth0 ", deviceIdeth0);
	Device->changeItem(Pixippp0, "ippp0 ", deviceIdippp0);
	Device->changeItem(Pixppp0, "ppp0 ", deviceIdppp0);
	Device->changeItem(PixOther, "Other ", deviceIduser);

	if(!strcmp(device, "lo")) Device->changeItem(PixloOn, "lo ", deviceIdlo);
	else if(!strcmp(device, "eth0")) Device->changeItem(Pixeth0On, "eth0 ", deviceIdeth0);
	else if(!strcmp(device, "ippp0")) Device->changeItem(Pixippp0On, "ippp0 ", deviceIdippp0);
	else if(!strcmp(device, "ppp0")) Device->changeItem(Pixppp0On, "ppp0 ", deviceIdppp0);
	else Device->changeItem(PixOtherOn, device, deviceIduser);
}

void KNETLoad::setDevicelo(void) { setDevice("lo"); }
void KNETLoad::setDeviceeth0(void) { setDevice("eth0"); }
void KNETLoad::setDeviceippp0(void) { setDevice("ippp0"); }
void KNETLoad::setDeviceppp0(void) { setDevice("ppp0"); }

void KNETLoad::setDeviceuser(void)
{
	deviceInput->show();
	deviceInput->move(deskX - 280, deskY - 280);
}

void KNETLoad::clear(void)
{
	dockIn->setClr();
	dockOut->setClr();
}

void KNETLoad::setGrid(void)
{
	grid = (grid) ? FALSE : TRUE;

	config->writeEntry("Grid", grid);
	config->sync();

	dockIn->setGrid(grid);
	dockOut->setGrid(grid);

	Menu->changeItem((grid) ? PixGridOn : PixGrid, "Grid", menuIdGrid);
}

void KNETLoad::setActive(void)
{
	active = (active) ? FALSE : TRUE;

	config->writeEntry("Active", active);
	config->sync();

	if(active) t->start(speed, FALSE);
	else t->stop();

	dockIn->setOn(active);
	dockOut->setOn(active);

	Menu->changeItem((active) ? PixActOn : PixAct, "Active", menuIdActive);
}

void KNETLoad::setText(void)
{
	text = (text) ? FALSE : TRUE;

	config->writeEntry("Text", text);
	config->sync();

	dockIn->setText(text);
	dockOut->setText(text);

	Menu->changeItem((text) ? PixLabelsOn : PixLabels, "Labels", menuIdText);
}

void KNETLoad::setSoft(void)
{
	soft = (soft) ? FALSE : TRUE;

	config->writeEntry("Soft", soft);
	config->sync();

	dockIn->setSoft(soft);
	dockOut->setSoft(soft);

	Menu->changeItem((soft) ? PixSoftOn : PixSoft, "Soft", menuIdSoft);
}

void KNETLoad::readScale(void)
{
	scaleInput->hide();
	setScale((int) atol(scaleEdit->text().latin1()) * 1000);
}

void KNETLoad::readScaleOut(void)
{
	scaleOutInput->hide();
	setScaleOut((int) atol(scaleOutEdit->text().latin1()) * 1000);
}

void KNETLoad::readDevice(void)
{
	deviceInput->hide();
	strcpy(tmp, deviceEdit->text().latin1());
	setDevice(tmp);
}

void KNETLoad::cancelScale(void)
{
	scaleInput->hide();
}

void KNETLoad::cancelScaleOut(void)
{
	scaleOutInput->hide();
}

void KNETLoad::cancelDevice(void)
{
	deviceInput->hide();
}

void KNETLoad::showPopUp(QPoint Point)
{
	popupOn = TRUE;

	config->writeEntry("PopupActive", popupOn);
	config->sync();

	if(popupX == 0 && popupY == 0) {
		popupX = Point.x() - 220;
		popupY = Point.y() - 100;
	}

	popup->show();
	popup->move(popupX, popupY);
}

void KNETLoad::hidePopUp(void)
{
	popupOn = FALSE;

	savePopUpPos();

	popup->hide();
}

void KNETLoad::savePopUpPos(void)
{
	popupX = popup->x();
	popupY = popup->y();

	config->writeEntry("PopupActive", popupOn);
	config->writeEntry("PopupX", popupX);
	config->writeEntry("PopupY", popupY);
	config->sync();
}

void KNETLoad::step(void)
{
	nVal = proc->readLoad();

	dockIn->step(nVal[0]);
	dockOut->step(nVal[1]);

	if(popupOn) {
	sprintf(tmp, "Current In: %.0fKBit/s, Total In: %.2fMB.\nCurrent Out: %.0fKBit/s, Total Out: %.2fMB.",
		(nVal[0] * (float) 8) / (float) speed, proc->totalIn(), (nVal[1] * (float) 8) / (float) speed, proc->totalOut());
	popup->setText(tmp);
	}
}

void KNETLoad::showHelp(void)
{
	KStandardDirs *stddirs = KGlobal::dirs();
	kapp->invokeBrowser(QString("file:") + stddirs->findResource("data", "knetload/docs/index.html"));
}






