/* -*- c++ -*-
 *
 * kmldonkey.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@kmldonkey.org>
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_kmldonkey_h__
#define __kmldonkey_kmldonkey_h__

#include <kmainwindow.h>
#include <kshortcut.h>
#include <qptrlist.h>
#include <qmap.h>
#include <qdict.h>
#include <kdeversion.h>

#include <donkeytypes.h>
#include "kmldonkeyiface.h"
#include "page.h"

#if KDE_IS_VERSION(3,1,90)
class KTabWidget;
#else
class QTabWidget;
#endif

class QLabel;
class QSignalMapper;
class QTimer;

class KToggleAction;

class DonkeyProtocol;
class HostManager;
class HostSelectAction;

class SystemTray;
class KMLDonkeyPreferences;
class ServerPage;
class SearchPage;
class StatsPage;
class DownloadPage;
class SharePage;
class FriendPage;
class RoomPage;
class ConsolePage;
class DebugPage;

extern void enableActionList(QPtrList<KAction> list, bool enable);

class KMLDonkey : public KMainWindow, virtual public KMLDonkeyIface
{
    Q_OBJECT
public:
    KMLDonkey();
    ~KMLDonkey();

    static KMLDonkey *App;
    DonkeyProtocol* donkey;
    HostManager* hostManager;

    // Configuration variables
    bool humanReadableSizes, displayProgressbar;

    bool enableAutorename;
    QValueList<QStringList> autorenameList;

    bool coloredViews;
    QColor colorServerNotConnected, colorServerBlacklisted, colorServerConnecting, colorServerConnected;
    QColor colorSearchFewSources, colorSearchManySources, colorSearchAlreadyDone;
    int searchThreshold;
    QColor colorDownloadDownloading, colorDownloadPaused, colorDownloadLooking, colorDownloadNotAvailable, colorDownloadQueued;
    QColorGroup availabilityColours;
    int availabilityThreshold, availabilityShadingDepth;
    bool availabilityShading;
    QColor colorSourceNotConnected, colorSourceBlacklisted, colorSourceConnecting, colorSourceQueued, colorSourceDownloading;

    QFont listFont, consoleFont;

    bool debugEnabled, advancedConfig;

    QString lastHost;

    bool sortDownloadingFirst();
    bool sortPausedLast();

    void addGenericAction(const char* name, KAction* action);
    void addGenericAction(const char* name, const QString& label, const QString& icon, const KShortcut& shortcut);
    void addCoreAction(KAction* action);

    // DCOP methods
    virtual void submitURL(QString url);
    virtual void consoleCommand(QString command);

protected:
    virtual bool queryClose();
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

    void restoreState(KConfig* conf);
    void saveState(KConfig* conf);

#if KDE_IS_VERSION(3,1,90)
    KTabWidget* pageTab;
#else
    QTabWidget* pageTab;
#endif

public slots:
    void sendConsoleMessage(const QString& txt);

    void show();
    void hide();

    void enableDebugConsole(bool enable);

    void activatePage(KMLDonkeyPage* page);
    void activatePage(int page);
    void activateNextPage();
    void activatePreviousPage();

    void showBadInstallDialog();

    void finalise();
    bool queryExit();

    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsConfigureConnection();
    void optionsConfigureMLDonkey();
    void optionsPreferences();
    void newToolbarConfig();
    void optionsNotifications();

    void launchSetupWizard();

    void applyPreferences();

    void actionConnectCore();
    void actionConnectCore(const QString& host);
    void actionDisconnectCore();
    void actionKillCore();
    void actionSubmitURL();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);

    void connectToCore();
    void disconnectFromCore();
    void coreConnected();
    void coreDisconnected(int);
    void checkReconnect();

    void updateStatus(int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp, QMap<int,int>*);

    void hostListUpdated();

    void handleGenericAction(const QString&);
    void pageActionsChanged(KMLDonkeyPage*);
    void currentPageChanged(QWidget*);

    void coreVersionReceived(const QString&);

private:
    void setupAccel();
    void setupActions();
    QWidget* buildInterface();
    void addPage(KMLDonkeyPage* page, const QIconSet& iconset, const QString& label);
    void removePage(KMLDonkeyPage* page);
    void updateSupportedActions(KMLDonkeyPage*);
    void updateTrayIcon();
    void updateStatusBarTooltip();

    KConfig* conf;
    SystemTray* tray;

    int reconnect;

    HostSelectAction* m_connectAction;
    KToggleAction* m_toolbarAction;
    KToggleAction* m_statusbarAction;
    bool showStatusbarLabels;
    bool saveStateOnExit, persistentReconnect, hideMainWin;
    QString coreCharset, coreVersion;
    bool showTrayIcon, closeToTrayIcon;

    QPtrList<KMLDonkeyPage> pages;

    ConsolePage* consolePage;
    ServerPage* serverPage;
    DownloadPage* downloadPage;
    SharePage* sharePage;
    FriendPage* friendPage;
    RoomPage* roomPage;
    SearchPage *searchPage;
    StatsPage *statsPage;
    DebugPage *debugPage;

    QLabel *statInfo, *statServer, *statFiles, *statShare, *statTransfer, *statRate;

    KMLDonkeyPreferences* prefs;

    QTimer* timer;

    QSignalMapper* pageMapper;

    QSignalMapper* actionMapper;
    QDict<KAction> genericActions;
    QPtrList<KAction> coreActions;

    KMLDonkeyPage* m_currentPage;
};

#endif // __kmldonkey_h__
