#ifndef LINT_H
#define LINT_H


#define LINT_SINGLE_SIZE 32
#define LINT_BIT_COUNT 1024  // Must be a multiple of LINT_SINGLE_SIZE

typedef unsigned int LintSingle;    // single unsigned
typedef long long LintDouble;       // double signed

#define LINT_SINGLE_MASK (((LintDouble)1<<LINT_SINGLE_SIZE)-1)
#define LINT_ARRAY_COUNT (LINT_BIT_COUNT/LINT_SINGLE_SIZE)


typedef struct{
 LintSingle data[LINT_ARRAY_COUNT];
 } Lint;

typedef enum {
 LINT_MUL, LINT_DIV, LINT_MOD,
 LINT_ADD, LINT_SUB,
 LINT_SL,  LINT_SR,
 LINT_XOR,
 LINT_AND,
 LINT_OR,
 LINT_BIC
 } LintSymbolType;




Lint lint_new(long long value);
Lint lint_from_chararr(int count, unsigned char* ptr);
void lint_to_chararr(int count, unsigned char* ptr, Lint number);
unsigned char* lint_to_new_chararr(int count, Lint number);
Lint lint_from_string(char* ptr, char** endptr);
long long lint_to_longlong(Lint value);
int lint_compare (Lint a, Lint b);
int lint_test (Lint a, Lint b);
Lint lint_operate (Lint a, Lint b, LintSymbolType type);


#endif
