\ quadratic.4th
\
\ Solve for the two complex solutions of the quadratic equation:
\
\   a*x^2 + b*x + c = 0
\
\ Assume a, b, and c are real. The two complex roots are 
\ x1r + i*x1i and x2r + i*x2i
\
\ K. Myneni, 2-11-2002
\
\ Revised: 2003-10-25, fixed problem with calculation of complex roots, 
\		       Christopher Brannon
\

fvariable qa
fvariable qb
fvariable qc
fvariable square_root_term
fvariable first_term
fvariable |second_term|

: solve_quadratic ( qa qb qc -- x1r x1i x2r x2i )
	qc f! qb f! qa f!
	qb f@ fdup f* 4e qa f@ f* qc f@ f* f- square_root_term f!
	qb f@ fnegate qa f@ 2e f* f/ first_term f!
	square_root_term f@ fdup f0< 
	if fabs then fsqrt 2e qa f@ f* f/ |second_term| f!
	
	square_root_term f@ f0<
	if
	  \ complex conjugate roots 
	  first_term f@ |second_term| f@
	  first_term f@ |second_term| f@ fnegate
	else
	  \ two real roots
	  first_term f@ |second_term| f@ f+ 0e
	  first_term f@ |second_term| f@ f- 0e
	then ;
