/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : Main window,create menu,main widget,status bar
 *
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include <kconfig.h>
#include <klocale.h>
#include <kshortcut.h>
#include <kstatusbar.h>
#include <kstdaction.h>
#include <klibloader.h>
#include <kmainwindow.h>
#include <kmessagebox.h>
#include <kactioncollection.h>

#include "kflickr.h"
#include "kflickrwidget.h"

/*!
    \fn kflickr::kflickr()
 */
kflickr::kflickr()
    : KParts::MainWindow( 0L, "kflickr" )
{
    // Set the shell's ui resource file.
    setXMLFile("kflickrshell.rc");

    // Setup our actions and status bar.
    setupActions();
    statusBar()->show();

    // Load our Part.  It finds the Part by name which is a bad idea
    // usually.. but it's alright in this case since our Part is made
    // for this Shell.
    KLibFactory *factory = KLibLoader::self()->factory("libkflickrpart");
    if (factory)
    {
        // Now that the Part is loaded, we cast it to a Part to get
        // our hands on it
        m_part = static_cast<KParts::ReadWritePart*>(factory->create(this,
                                "kflickrpart", "KParts::ReadWritePart" ));

        if (m_part)
        {
            // tell the KParts::MainWindow that this is indeed the main widget
            setCentralWidget(m_part->widget());

            // and integrate the part's GUI with the shell's
            createGUI(m_part);
        }
    }
    else
    {
        // If we couldn't find our Part, notify user, initiate exit.
        KMessageBox::error(this, i18n("Could not find kflickr part."));
        kapp->quit();

        // We return here, cause kapp->quit() only means "exit the
        // next time we enter the event loop...
        return;
    }

    // Apply the saved mainwindow settings, if any.
    setAutoSaveSettings();
}

/*!
    \fn kflickr::~kflickr()
 */
kflickr::~kflickr()
{
}

/*!
    \fn kflickr::load(const KURL& url)
 */
void kflickr::load(const KURL& url)
{
    m_part->openURL(url);
}

/*!
    \fn kflickr::setupActions()
 */
void kflickr::setupActions()
{
    KStdAction::quit(kapp, SLOT(quit()), actionCollection());
}

#include "kflickr.moc"
