/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#include <kerryapp.h>
#include <qobject.h>
#include <qdir.h>
#include <qdom.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfig.h>
#include <qfileinfo.h>
#include <qstringlist.h>
#include <kconfig.h>
#include <kstandarddirs.h>
#include <kdeversion.h>
#include <kconfig.h>
#include <unistd.h>

static const char *description =
    I18N_NOOP("KDE Frontend to Beagle");

static const char *version = "0.2";

static KCmdLineOptions options[] =
{
  { "+term", I18N_NOOP("A term to search"), 0 },
  { "show-searchdialog", I18N_NOOP( "Show search dialog on startup" ), 0},
  { 0, 0, 0 }
};

bool KSessionManaged::saveState(QSessionManager&)
{
//  KConfig* config = kapp->sessionConfig();
//  config->setGroup("General");
//  config->writeEntry("LastSearches", "foobar");

    return true;
}

bool KSessionManaged::commitData(QSessionManager&)
{
    return true;
}

extern "C" KDE_EXPORT int kdemain(int argc, char **argv)
{
    if (!getuid()) {
      QFile file( "/root/.beagle/config/daemon.xml" );
      bool fail = true;
      if ( file.open( IO_ReadOnly ) ) {
        QDomDocument doc( "mydocument" );
        if ( doc.setContent( &file ) ) {
          QDomElement docElem = doc.documentElement();
          QDomNode n = docElem.firstChild();
          while( !n.isNull() ) {
            QDomElement e = n.toElement();
            if( !e.isNull() && e.tagName()=="AllowRoot")
                 fail = e.text()!="true";
            n = n.nextSibling();
          }
        }
        file.close();
      }
      if (fail) {
        printf("beagled will not run as root. Kerry will quit now because of that.\n");
        return 1;
      }
    }

    KAboutData about("kerry", I18N_NOOP("Kerry Beagle Search"),
                     version, description,
                     KAboutData::License_GPL,
                     "(c) 2005,2006 Novell, Inc.",
                     0, "http://opensuse.org/kerry");
    about.addAuthor("Stephan Binner", 0, "binner@kde.org");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();

    KSessionManaged ksm;

    KerryApplication app;
    KGlobal::locale()->insertCatalogue("libkonq");

    return app.exec();
}
