/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#ifndef __SEARCH_H__
#define __SEARCH_H__

#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qspinbox.h>
#include <qwhatsthis.h>
#include <kcmodule.h>
#include <qcombobox.h>
#include <kglobalaccel.h>
#include <kkeydialog.h>
#include <klocale.h>

class KCMKerrySearch : public KCModule
{
  Q_OBJECT

public:
  KCMKerrySearch(QWidget *parent=0, const char *name=0);
  ~KCMKerrySearch();

  virtual void load();
  virtual void load( bool useDefaults );
  virtual void save();
  virtual void defaults();

protected slots:
  void changedValue();

private:
    QSpinBox *maxResultsDisplayed;
    QComboBox* combo_order;
    QCheckBox* showBigTiles;
    KKeyChooser *keysWidget;
    KGlobalAccel *globalKeys;
};

#endif
