/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */


#ifndef PREFERENCESWIDGET_H
#define PREFERENCESWIDGET_H

#include "searchengine.h"

class PWidget;

class PreferencesWidget : public PrefWidget
{
	Q_OBJECT

public:
	PreferencesWidget(QWidget *parent=0, const char* name=0);
	virtual ~PreferencesWidget();

	virtual void apply();
	virtual void cancel();
	virtual void standard();

	void setURL(const QString url);
	void setMatchEqual(bool);
	void setMatchNGram(bool);
	void setMatchIsContained(bool);
	void setMatchContains(bool);
	void setIgnoreFuzzy(bool);
	void setMatchWords(bool);
	void setWholeWords(bool);
	void setCaseSensitive(bool);
	
	QString url();
	bool matchEqual();
	bool matchNGram();
	bool matchIsContained();
	bool matchContains();
	bool ignoreFuzzy();
	bool matchWords();
	bool wholeWords();
    bool caseSensitive();


	bool settingsChanged() const;
	
signals:
	void restoreSettings();
	void applySettings();
	
public:
	PWidget *prefWidget;

protected slots:
	void setChanged();
	void equalBtnToggled(bool);
	void ngramBtnToggled(bool);
	void isContainedBtnToggled(bool);
	void containsBtnToggled(bool);
	void hasWordBtnToggled(bool);

private:
	bool changed;

};

#endif
