//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "checkdaemon.h"
#include <dcopclient.h>
#include <kapplication.h>
#include <kmessagebox.h>
#include <qwidget.h>
#include <klocale.h>

namespace KBluetoothd {

bool checkDaemon(bool autoStart, bool msgBox)
{
    DCOPClient* dc = KApplication::dcopClient();
    if (dc->isApplicationRegistered("kbluetoothd") == false) {
        if (autoStart == true) {
            QWidget *mainWidget = NULL;
            QString URL, errorStr;
            int ret = KApplication::startServiceByDesktopName(
                "kbluetoothd", URL, &errorStr);

            if (ret == 0) {
                if (msgBox == true) {
                    if (KApplication::kApplication() != NULL) {
                        mainWidget = KApplication::kApplication()->mainWidget();
                    }
                    KMessageBox::information(mainWidget,
                        i18n("<p>The KDE Bluetooth Daemon (<i>kbluetoothd</i>) is \
needed and was started.</p>"),
                        i18n("KDE Bluetooth Framework"),
                    "kbluetoothd_autostart_msgbox");
                }
                return true;
            }
            else {
                if (msgBox == true) {
                    KMessageBox::detailedSorry(mainWidget,
                        i18n("The KDE Bluetooth Daemon (<i>kbluetoothd</i>) \
could not be started. Please make sure it is installed correctly."),
                        i18n("The error message was: %1").arg(errorStr),
                        i18n("KDE Bluetooth Framework"));
                }
                return false;
            }
        }
    }
    return true;
}

};
