/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef SCANTAB_H
#define SCANTAB_H

#include <scantabbase.h>
#include "dcopcall.h"
#include <map>

class ScanJobBase;
class KDialogBase;
class PagedDevicesWidget;

/**
@author Fred Schaettgen
*/
class ScanTab : public ScanTabBase
{
Q_OBJECT
public:
    ScanTab(QWidget *parent, const char* name);
    ~ScanTab();
public slots:
    void apply();
    void defaults();
signals:
    void dirty();
private:
    ScanJobBase *job;
    DCOPCall server;
    KDialogBase *pagedDevicesDlg;
    PagedDevicesWidget* pagedDevicesWidget;
    
    struct JobInfo {
        QString name;
        //bool enabled;
        QStringList deviceList;
        bool useJobList;
        bool isWhitelist;
        //bool notifyFound;
        //bool notifyLost;
        int notifyInterval;
        int minExecInterval;
    };
    std::map<QString, JobInfo> jobInfos;
    QString currentJobName;
    
    void reloadDiscoverySettings();
    void updateJobUIFromData();
    void updateJobDataFromUI();
    //void setJobData(QString jobname);
        
private slots:
    void updateJobUIfromUI();
    void slotJobSelected();
    //void slotUseWhiteList();
    void addJobDevice();
    void removeJobDevice();
    void executeJobNow();
    void addJob();
    void removeJob();
    void configureJob();
    void showPagedDevices();
    void showScriptFolder();
    void showTemplateFolder();
};

#endif
