/***************************************************************************
                          obexclient.cpp  -  description
                             -------------------
    begin                : Sat Feb 14 2003
    copyright            : (C) 2003 by Simone Gotti
    email                : simone.gotti@email.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>
#include <qfile.h>
#include <kdebug.h>

#include <qobex/qobexintransport.h>
#include <qobex/qobexserialtransport.h>
#include <qobex/qobexbfbtransport.h>
#include <qobex/qobexericssontransport.h>
#ifdef HAVE_QOBEX_BLUETOOTH
#include <qobex/qobexbttransport.h>
#endif
#ifdef HAVE_QOBEX_IRDA
#include <qobex/qobexirdatransport.h>
#endif
#include <qobex/qobexclient.h>
#include <qobex/qobexuuid.h>

#define ARGV0 "qobexclient"

#include "obexclient.h"

Client::Client( QObexTransport * transport, bool verbose )
		: QObexClient( transport ), mVerbose( verbose )
{
	//Init the buffer
	mData.resize(0);
	mBuffer.close();
	mBuffer.setBuffer(mData);
	mBuffer.open( IO_WriteOnly );
	mBodyStart = true;
}

void Client::response( const QObexObject& resp )
{
	mHeaders = resp.getHeaders();
	
	if ( mVerbose ) {
		fprintf( stderr, "Got Response Packet\n   %s\n",
		         (const char *)QFile::encodeName( resp.stringCode() ) );
		QValueList<QObexHeader> hdrs = resp.getHeaders();
		QValueList<QObexHeader>::Iterator it;
		for ( it = hdrs.begin(); it != hdrs.end(); ++it )
			fprintf( stderr, "        %s\n",
			         (const char *)QFile::encodeName( (*it).stringHeaderId() ) );
	}
	
}

bool Client::dataReq( QByteArray& data, size_t max )
{
	kdDebug() << "Client::dataReq() "<< endl;
	data.resize( max );
	int ret = mBuffer.readBlock( data.data(), max );
	if(ret >= 0)
		data.resize( ret );
	kdDebug() << "Client::dataReq() end.  ret= " << ret << endl;
	return ret >= 0;
}

bool Client::data( const QValueList<QByteArray>& data )
{
	kdDebug() << "Client::data() "<< endl;
	if(mBodyStart) {
		mData.resize(0);
		mBuffer.close();
		mBuffer.setBuffer(mData);
		mBuffer.open( IO_WriteOnly );
		mBodyStart = false;
	}

	if ( !data.isEmpty() ) {
		QValueList<QByteArray>::ConstIterator it;
		for ( it = data.begin(); it != data.end(); ++it ) {
			if ( (*it).size() > 0 ) {
				if ( mBuffer.writeBlock((*it).data(), (*it).size()) < 0 ) {
					return false;
				}
			}
		}
	}
	return true;
}

void Client::authenticationRequired( const QString& realm )
{
	if ( mVerbose ) {
		fprintf( stderr, "Got Authentication Required with realm \"%s\"\n",
		         (const char *)QFile::encodeName( realm ) );
	}
}


QByteArray Client::getData()
{
	mBodyStart = true;
	return mBuffer.buffer();
}

void Client::setData(QByteArray& data)
{
	mData = data; 
	mBuffer.close();
	mBuffer.setBuffer(mData);
	mBuffer.open( IO_ReadOnly );
}

QValueList<QObexHeader> Client::getHeaders()
{
	kdDebug() << "Client::getHeaders() "<< endl;
	return mHeaders;
}


