/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen <kdebluetooth@schaettgen.de>    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <libkbluetooth/configinfo.h>

#include "kbemusedsrv.h"
#include "maindialogbase.h"
#include "dcopcall.h"

static const char description[] =
    I18N_NOOP("KDE Bemused Server");

static const char* version = KDEBluetoothConfig::version;

static KCmdLineOptions options[] =
    {
        {"rfcommconnection <sockfd>", I18N_NOOP("Used by kbluetoothd"), 0},
        {"peeraddr <addr>", I18N_NOOP("Used by kbluetoothd"), 0},
        {"peername <name>", I18N_NOOP("Used by kbluetoothd"), 0},
        {"configure", I18N_NOOP("Launch configuration window"), 0},
        KCmdLineLastOption
    };

using namespace KBluetooth;

bool isRunning()
{
    bool ret = false;
    DCOPClient* dcopClient = KApplication::dcopClient();
    QString myAppId = QString(dcopClient->registerAs("kbemusedsrv-config"));
    QCStringList apps = dcopClient->registeredApplications();
    for (uint n=0; n<apps.count(); ++n) {
        QString app = apps[n];
        if (app.startsWith("kbemusedsrv-") && app != myAppId) {
            ret = true;
            break;
        }
    }
    return ret;
}

int main(int argc, char **argv)
{
    KAboutData about("kbemusedsrv",
        I18N_NOOP("KDE Bemused Server"),
        version, description,
        KAboutData::License_GPL,
        "(C) 2003-2005 KDE Bluetooth Framework Project\n"
        "(C) 2003-2005 Fred Schaettgen, Alex Ibrado",
        0, 0,
        "kbemusedsrv@schaettgen.de"
        );
    about.addAuthor("Fred Schaettgen", I18N_NOOP("Author"), "kbemusedsrv@schaettgen.de");
    about.addAuthor("Alex Ibrado", I18N_NOOP("Maintainer"), "alex@kdex.org");
    about.addCredit("Ashley Montanaro", I18N_NOOP("Bemused Author"), "ashley_montanaro@hotmail.com");
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if (args->isSet("rfcommconnection") && args->isSet("peeraddr") &&
        args->isSet("peername")) {
        int socket = QString(args->getOption("rfcommconnection")).toInt();
        QString name = QString(args->getOption("peername"));
        QString addr = QString(args->getOption("peeraddr"));

        MainDialog *mainDialog = new MainDialog(socket, addr, name);
        app.setMainWidget(mainDialog);
        mainDialog->show();
        return app.exec();
    } else if(args->isSet("configure")) {
        if (isRunning()) {
            DCOPCall relayConfig(KApplication::dcopClient(), 
                "kbemusedsrv-", "kbemusedsrv");
            relayConfig.broadcast("configure()", false, true);
            // Check if failed?
            exit(0);
        }

        MainDialog *mainDialog = new MainDialog(0, "", "");
        app.setTopWidget(mainDialog);
        return app.exec();
    }
    else {
        KMessageBox::information(NULL,
            "kbemusedsrv is a server application that is supposed \
            to be called by the kbluetoothd meta-server. You may \
            specify --configure at the command line to launch the \
            configuration window.", "kbemusedsrv");
        
    }
    return 0;
}

