/* This file is part of the KDE project
   Copyright (C) 2001 Carsten Pfeiffer <pfeiffer@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef SETTINGS_PLUGIN
#define SETTINGS_PLUGIN

#include <kparts/plugin.h>
#include <klibloader.h>


class SettingsPlugin : public KParts::Plugin
{
    Q_OBJECT
public:
    SettingsPlugin( QObject* parent = 0, const char* name = 0 );
    virtual ~SettingsPlugin();

private:
    bool cookiesEnabled( const QString& url );

private slots:
    void toggleJavascript();
    void toggleJava();
    void toggleCookies();
    void togglePlugins();
    void toggleImageLoading();
    void toggleCache();
    void cachePolicyChanged( int p );

    void showPopup();
};

class KHTMLSettingsFactory : public KLibFactory
{
    Q_OBJECT
public:
    KHTMLSettingsFactory( QObject* parent = 0, const char* name = 0 );
    virtual ~KHTMLSettingsFactory();

    virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

private:
    static KInstance* s_instance;
};

#endif // SETTINGS_PLUGIN
