#!/bin/sh

#
# This is the boot script for the `kbd' package.
# It loads parameters from /etc/kbd/config, maybe loads
# default font and map, and maybe start "vcstime"
# (c) 1997 Yann Dirson

if [ "$0" = stop ]
then
    exit
fi

if [ -r /etc/kbd/config ] ; then
    . /etc/kbd/config
fi

SETFONT="/usr/bin/setfont"
SETFONT_OPT="-v"
VCSTIME="/usr/sbin/vcstime"

# start vcstime
if [ "${DO_VCSTIME}" = "yes" -a -x ${VCSTIME} ] ; then
    echo -n Starting clock on text console: `basename ${VCSTIME}`
    ${VCSTIME} &
    echo .
fi

# load font if asked for
if [ x$CONSOLE_FONT != x -a -x ${SETFONT} ] ; then
    ${SETFONT} ${SETFONT_OPT} ${CONSOLE_FONT}
fi

# load map if asked for
if [ x$CONSOLE_MAP != x -a -x ${SETFONT} ] ; then
    ${SETFONT} ${SETFONT_OPT} -m ${CONSOLE_MAP}
fi
