#include <qlabel.h>
#include <qwidget.h>
#include <qevent.h>
#include <qmainwindow.h>
#include <stdio.h>
#include <qstatusbar.h>
#include <iostream>

#include "category.h"
#include "categorylabel.h"
#include "globals.h"
#include "browser.h"
#include "utility.h"

CategoryLabel::CategoryLabel( QWidget *parent, Category *category, string memory = "" ) : QLabel( parent )
{
	this->category = category;
	this->memory = memory;

//	int i;
//	if( ( i = text().find( ";" ) ) != -1 )
//		printf( "bledder\n" );
	
//	if( category )
//		cout << category->title << endl;

	extension = FALSE;

	setMouseTracking( TRUE );

	show();
}

void CategoryLabel::mousePressEvent( QMouseEvent *event )
{
	if( event->button() == LeftButton ) 
	{
		if( !category )
		{
			emit LeftMouseButtonClicked( memory );
			emit LeftMouseButtonClicked( (const char *)text(), memory ); 
		}	
		else
			emit LeftMouseButtonClicked( category );
	}	

	else if( extension )
		emit rightMenuExtension( event->globalX(), event->globalY(), category );
	else
		emit rightMenu( event->globalX(), event->globalY() );
}

