/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "lastpage.h"
#include "kalleryglobals.h"

#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

//Qt includes
#include <qlabel.h>


LastPage::LastPage(QWidget *parent, const char *name)
    :KLastPage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));
}

void LastPage::setupPage()
{
  QString tmpString;

  GalleryTitleTxt->setText(i18n("<qt>Gallery title: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.galleryTitle));
  GalleryTxt->setText(i18n("<qt>Gallery file: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.galleryFile));
  LanguageTxt->setText(i18n("<qt>Country: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.language));

  EncodingTxt->setText(i18n("<qt>Encoding: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.encoding));

  switch (KalleryGlobals::ref()->options.thumbSetting)
  {
    case OptionType::NoThumbnails:
      tmpString = i18n("No thumbnail generation (ignore the next item).");
      break;
    case OptionType::GenerateThumbnails:
      tmpString = i18n("Generate thumbnails.  [ %1 / %2 x %3 ]").arg(KalleryGlobals::ref()->options.thumbFormat).arg(KalleryGlobals::ref()->options.thumbWidth)\
      .arg(KalleryGlobals::ref()->options.thumbHeight);
      break;
    case OptionType::LoadThumbnails:
      tmpString = i18n("Load thumbnails from a list.");
      break;
  }
  ThumbOptionsTxt->setText(tmpString);
  ThumbTxt->setText(i18n("<qt>Thumbnails: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.thumbDestDir));
  FullsizeTxt->setText(i18n("<qt>Images: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.imageDestDir));

  if (KalleryGlobals::ref()->options.relativePaths)
  {
    tmpString  = i18n("Use relative paths.");
  }
  else
  {
    tmpString = i18n("Use absolute paths. (Not recommended.)");
  }
  RelativeTxt->setText(tmpString);
  ColumnNumTxt->setText(i18n("<qt>Columns: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.columnNum));

  tmpString = i18n("%1 images. ").arg(KalleryGlobals::ref()->options.imageList.count());
  if (KalleryGlobals::ref()->options.convertImages == OptionType::Convert)
  {
    if (KalleryGlobals::ref()->options.resize)
    {
      tmpString +=i18n("[ %1 / %2 x %3 ]").arg(KalleryGlobals::ref()->options.fullFormat).arg(KalleryGlobals::ref()->options.fullWidth).arg(KalleryGlobals::ref()->options.fullHeight);
    }
    else
    {
      tmpString +=i18n("[ %1 / No resize ]").arg(KalleryGlobals::ref()->options.fullFormat);
    }

    if (KalleryGlobals::ref()->options.insertCopyright)
    {
      CopyrightTxt->setText(i18n("Copyright: %1").arg(KalleryGlobals::ref()->options.copyright));
    }
    else
    {
      CopyrightTxt->setText(i18n("No copyright info inserted"));
    }
  }

  if (KalleryGlobals::ref()->options.convertImages == OptionType::CopyOnly) 
      tmpString += i18n("[Copy the images]");
   ImageNumTxt->setText(tmpString);

   if (KalleryGlobals::ref()->options.galleryCSSFile.isEmpty())
   {
     tmpString = i18n("CSS is not used for the main gallery.");
   } else
   {
     tmpString = i18n("<qt>Gallery CSS file: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.galleryCSSFile);
   }
   GalleryCSSTxt->setText(tmpString);

   if (KalleryGlobals::ref()->options.imageCSSFile.isEmpty())
   {
     tmpString = i18n("CSS is not used for the fullsize image htmls.");
   } else
   {
     tmpString = i18n("<qt>Image CSS file: <i>%1</i></qt>").arg(KalleryGlobals::ref()->options.imageCSSFile);
   }
   ImageCSSTxt->setText(tmpString);

   if (KalleryGlobals::ref()->options.useHtmlImages)
   {
     tmpString  = i18n("Generate image html pages.");
   }
   else
   {
     tmpString = i18n("Do not generate html page for each image.");
   }
   ImageHtmlTxt->setText(tmpString);

   if (KalleryGlobals::ref()->options.textButtons)
   {
     tmpString  = i18n("Generate text navigation buttons.");
   }
   else
   {
     tmpString = i18n("Generate bitmap navigation buttons.");
   }
   ButtonsTxt->setText(tmpString);
}

void LastPage::invokeHelp()
{
  kapp->invokeHelp("last-page","kallery");
}

bool LastPage::processPage()
{
  return true;
}

#include "lastpage.moc"
