/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEHTMLPAGE_H
#define IMAGEHTMLPAGE_H

#include "kimagehtmlpage.h"
#include "wizardpagebase.h"

/**
 * @short
 * Fullsize image HTML options page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class ImageHtmlPage: public KImageHtmlPage, public WizardPageBase {
Q_OBJECT
public:
  ImageHtmlPage(QWidget *parent = 0, const char *name = 0);
  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:
  
  /**
   * Select the picture for the Back button.
   */
  void slotSelectBackPic();
  
  /**
   * Select the picture for the Previous button.
   */
  void slotSelectPrevPic();
  
  /**
   * Select the picture for the Next button.
   */
  void slotSelectNextPic();
  
  /**
   * Select the background color.
   */
  void slotSelectImageBackColor();  
  /**
   * Select the text and link color.
   */
  void slotSelectImageTextColor();
  /**
   * Select the visited link color.
   */
  void slotSelectImageVisitedColor();  
  /**
   * Select a CSS file for the images.
   */
  void slotSelectImageCSS();

private:
  /**
   * Load the image html templates.
   */
  void loadTemplates();

  QStringList fullsizeTemplateList; ///< store the fullsize templates here
};

#endif
