/***************************************************************************
    copyright            : (C) 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FIRSTPAGE_H
#define FIRSTPAGE_H

#include "kfirstpage.h"
#include "wizardpagebase.h"

/**
 * @short
 * First page.
 * 
 * @author Andras Mantia <amantia@kdewebdev.org>
 */
class FirstPage: public KFirstPage, public WizardPageBase {
  Q_OBJECT
public:
  FirstPage(QWidget *parent = 0, const char *name = 0);

  void invokeHelp();
  bool processPage();
  void setupPage();

private slots:

  /**
   * Called when the user selects to open an existing project. 
   */
  void slotOpenProject();

signals:
  /**
   * Emitted when an existing project was loaded.
   */
  void projectLoaded();
};

#endif
