/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "descsourcepage.h"
#include "kalleryglobals.h"
#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

//Qt includes
#include <qcheckbox.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qradiobutton.h>
#include <qwidgetstack.h>

DescSourcePage::DescSourcePage(QWidget *parent, const char *name)
    :KDescSourcePage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));
  NextDescBtn->setIconSet(BarIconSet("forward"));
  PrevDescBtn->setIconSet(BarIconSet("back"));
  DescSelBtn->setIconSet(BarIconSet("fileopen"));
  
  connect(EnterDescBtn,SIGNAL(clicked()),this,SLOT(slotDescSettingsChanged()));
  connect(LoadDescBtn,SIGNAL(clicked()),this,SLOT(slotDescSettingsChanged()));
  connect(ImageInfoDescBtn,SIGNAL(clicked()),this,SLOT(slotDescSettingsChanged()));
  connect(NoDescBtn,SIGNAL(clicked()),this,SLOT(slotDescSettingsChanged()));

  connect(DescSelBtn,SIGNAL(clicked()),this,SLOT(slotLoadDescriptions()));
  connect(LoadDescBtn,SIGNAL(clicked()),this,SLOT(slotLoadDescriptions()));
  connect(NextDescBtn,SIGNAL(clicked()),this,SLOT(slotNextDescription()));
  connect(PrevDescBtn,SIGNAL(clicked()),this,SLOT(slotPreviousDescription()));
}

void DescSourcePage::slotDescSettingsChanged()
{
  if (ImageInfoDescBtn->isChecked())
    widgetStack->raiseWidget(1);
  else
    widgetStack->raiseWidget(0);
}

void DescSourcePage::slotLoadDescriptions()
{
  QString tempStr;

  tempStr = KFileDialog::getOpenFileName(QFileInfo(KalleryGlobals::ref()->options.fileName).dirPath(),"*",this,i18n("Select a description file"));
  if(!tempStr.isEmpty())
  {
    KalleryFunctions::ref()->readDescriptions(tempStr,KalleryGlobals::ref()->options.descList);
    for (uint i = KalleryGlobals::ref()->options.descList.count(); i < KalleryGlobals::ref()->options.imageList.count(); i ++)
    {
      KalleryGlobals::ref()->options.descList.append(OptionType::Description());
    }
    KalleryGlobals::ref()->options.descSetting = OptionType::LoadDescriptions;
    setupPage();
  }
}

void DescSourcePage::slotNextDescription()
{
  QValueList<OptionType::Description>::Iterator it;
  OptionType::Description desc;
  PrevDescBtn->setEnabled(true);
  
  if (DescPosition + 1 > KalleryGlobals::ref()->options.descList.count())
  {
    desc.comment = DescEdit->text();
    KalleryGlobals::ref()->options.descList.append(desc);
  }
  else
  {
    desc.comment = DescEdit->text();
    it = KalleryGlobals::ref()->options.descList.at(DescPosition);
    it = KalleryGlobals::ref()->options.descList.remove(it);
    KalleryGlobals::ref()->options.descList.insert(it, desc);
  }

  DescPosition++;
  if (DescPosition + 1 == KalleryGlobals::ref()->options.imageList.count())
  {
    NextDescBtn->setEnabled(false);
  }

  if (DescPosition < KalleryGlobals::ref()->options.descList.count())
  {
    DescEdit->setText(KalleryGlobals::ref()->options.descList[DescPosition].comment);
  }
  else
  {
    DescEdit->clear();
  }
  ImageNameTxt->setText(i18n("Describe the image: %1").arg(QFileInfo(KalleryGlobals::ref()->options.imageList[DescPosition]).fileName()));
  pm.load(KalleryGlobals::ref()->options.imageList[DescPosition]);
  dx = double(descPixmap->width() - 5) / double(pm.width());
  matrix.reset();
  matrix.scale(dx, dx);
  pm_scale = pm.xForm(matrix);
//  DescPic->setPaletteBackgroundPixmap(pm_scale);
  descPixmap->setPixmap(pm_scale);
}


void DescSourcePage::slotPreviousDescription()
{
  QValueList<OptionType::Description>::Iterator it;

  OptionType::Description desc;
  NextDescBtn->setEnabled(true);
  if (DescPosition +1 > KalleryGlobals::ref()->options.descList.count())
  {
    desc.comment = DescEdit->text();
    KalleryGlobals::ref()->options.descList.append(desc);
  }
  else
  {
    desc.comment = DescEdit->text();
    it = KalleryGlobals::ref()->options.descList.at(DescPosition);
    it = KalleryGlobals::ref()->options.descList.remove(it);
    KalleryGlobals::ref()->options.descList.insert(it, desc);
  }
  DescPosition --;
  if (DescPosition == 0)
  {
    PrevDescBtn->setEnabled(false);
  }
  DescEdit->setText(KalleryGlobals::ref()->options.descList[DescPosition].comment);
  ImageNameTxt->setText(i18n("Describe the image: %1").arg(QFileInfo(KalleryGlobals::ref()->options.imageList[DescPosition]).fileName()));
  pm.load(KalleryGlobals::ref()->options.imageList[DescPosition]);
  dx = double(descPixmap->width() - 5) / double(pm.width());
  matrix.reset();
  matrix.scale(dx, dx);
  pm_scale = pm.xForm(matrix);
//  DescPic->setPaletteBackgroundPixmap(pm_scale);
  descPixmap->setPixmap(pm_scale);
}


void DescSourcePage::invokeHelp()
{
  kapp->invokeHelp("description-page","kallery");
}

bool DescSourcePage::processPage()
{
  slotNextDescription();
  if (NoDescBtn->isChecked()) KalleryGlobals::ref()->options.descSetting = OptionType::NoDescriptions;
  if (ImageInfoDescBtn->isChecked()) 
  {
    KalleryGlobals::ref()->options.descSetting = OptionType::LoadImageInfo;
    KalleryGlobals::ref()->options.infoSetting = 0;
    if (FileSize->isChecked())
      KalleryGlobals::ref()->options.infoSetting |= OptionType::ImageInfoFileSize;
    if (ImageDimension->isChecked())
      KalleryGlobals::ref()->options.infoSetting |= OptionType::ImageInfoDimensions;
    if (ImageComment->isChecked())
      KalleryGlobals::ref()->options.infoSetting |= OptionType::ImageInfoComment;
    if (ShootingDate->isChecked())
      KalleryGlobals::ref()->options.infoSetting |= OptionType::ImageInfoShootingDate;
    if (ExposureInfo->isChecked())
      KalleryGlobals::ref()->options.infoSetting |= OptionType::ImageInfoExposure;
  }
  if (LoadDescBtn->isChecked()) KalleryGlobals::ref()->options.descSetting = OptionType::LoadDescriptions;
  if (EnterDescBtn->isChecked()) KalleryGlobals::ref()->options.descSetting = OptionType::EnterDescriptions;

  /*If we enter or load the descriptions, do a check.*/
  if ((KalleryGlobals::ref()->options.descSetting > OptionType::LoadImageInfo) && (KalleryGlobals::ref()->options.descList.count() != KalleryGlobals::ref()->options.imageList.count()) )
  {
    KMessageBox::error(this,i18n("The number of descriptions is not equal with the number of image files!\n\n %1 descriptions, but\n %2 image files were selected.") \
                                                  .arg(KalleryGlobals::ref()->options.descList.count()).arg(KalleryGlobals::ref()->options.imageList.count()),i18n("Number mismatch error"),true);
    return false;
  }

  if (KalleryGlobals::ref()->options.descSetting == OptionType::NoDescriptions )
  {
    KalleryGlobals::ref()->options.descList.clear();
    for (uint i = 0; i < KalleryGlobals::ref()->options.imageList.count(); i++)
      KalleryGlobals::ref()->options.descList.append(OptionType::Description());
  }

  return true;
}

void DescSourcePage::setupPage()
{
  EnterDescBtn->setChecked(KalleryGlobals::ref()->options.descSetting == OptionType::EnterDescriptions);
  LoadDescBtn->setChecked(KalleryGlobals::ref()->options.descSetting == OptionType::LoadDescriptions);
  ImageInfoDescBtn->setChecked(KalleryGlobals::ref()->options.descSetting == OptionType::LoadImageInfo);
  NoDescBtn->setChecked(KalleryGlobals::ref()->options.descSetting == OptionType::NoDescriptions);
  
  FileSize->setChecked(KalleryGlobals::ref()->options.infoSetting &  OptionType::ImageInfoFileSize);
  ImageDimension->setChecked(KalleryGlobals::ref()->options.infoSetting &  OptionType::ImageInfoDimensions);
  ImageComment->setChecked(KalleryGlobals::ref()->options.infoSetting &  OptionType::ImageInfoComment);
  ShootingDate->setChecked(KalleryGlobals::ref()->options.infoSetting &  OptionType::ImageInfoShootingDate);
  ExposureInfo->setChecked(KalleryGlobals::ref()->options.infoSetting &  OptionType::ImageInfoExposure);
  
  PrevDescBtn->setEnabled(false);
  NextDescBtn->setEnabled(true);
  ImageNameTxt->setText(i18n("Describe the image: %1").arg(QFileInfo(KalleryGlobals::ref()->options.imageList[0]).fileName()));
  DescPosition = 0;
  if (KalleryGlobals::ref()->options.descList.count() > 1)
  {
    DescEdit->setText(KalleryGlobals::ref()->options.descList[0].comment);
    pm.load(KalleryGlobals::ref()->options.imageList[0]);
    dx = double(descPixmap->width()) / double(pm.width());
    matrix.reset();
    matrix.scale(dx, dx);
    pm_scale = pm.xForm(matrix);
//    DescPic->setPaletteBackgroundPixmap(pm_scale);
    descPixmap->setPixmap(pm_scale);
  }
  else
  {
    DescEdit->clear();
  }
  slotDescSettingsChanged();
}


#include "descsourcepage.moc"
