/***************************************************************************
                           videosettings.h 
                             -------------------
    begin                : Mit Mai 7 2003
    revision             : $Revision: 1.2 $
    last modified        : $Date: 2005/02/02 10:08:28 $ by $Author: juergenk $
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VIDEOSETTINGS_H
#define VIDEOSETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class QSlider;

class VideoSettings : public KDialogBase
{

   Q_OBJECT
   
public: 
  VideoSettings(int hue, int sat, int contrast, int bright, int avOffset,
                int spuOffset, QWidget *parent=0, const char *name=0);
 ~VideoSettings();

signals:
  void signalNewHue(int);
  void signalNewSaturation(int);
  void signalNewContrast(int);
  void signalNewBrightness(int);
  void signalNewAVOffset(int);
  void signalNewSpuOffset(int);

private slots:

  void slotSetDefaultValues();


private:
  QSlider* m_hueSlider;
  QSlider* m_satSlider;
  QSlider* m_contrastSlider;
  QSlider* m_brightSlider;
  QSlider* m_avOffsetSlider;
  QSlider* m_spuOffsetSlider;
                
};

#endif
