// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Provides an implementation of k3d::iuser_interface
		\author Tim Shead (tshead@k-3d.com)
*/

#include "iuser_interface.h"

#include "application.h"

#include <iostream>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// message

void message(const std::string& Message, const std::string& Title)
{
	if(k3d::application().user_interface())
		k3d::application().user_interface()->message(Message, Title);
	else
		std::cerr << Title << " " << Message << std::endl;
}

/////////////////////////////////////////////////////////////////////////////
// error_message

void error_message(const std::string& Message, const std::string& Title)
{
	if(k3d::application().user_interface())
		k3d::application().user_interface()->error_message(Message, Title);
	else
		std::cerr << Title << " " << Message << std::endl;
}

/////////////////////////////////////////////////////////////////////////////
// query_message

unsigned int query_message(const std::string& Message, const std::string& Title, const unsigned int DefaultButton, const std::vector<std::string> Buttons)
{
	if(k3d::application().user_interface())
		return k3d::application().user_interface()->query_message(Message, Title, DefaultButton, Buttons);

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// get_file_path

bool get_file_path(const std::string& Type, const std::string& Prompt, const bool PromptOverwrite, const boost::filesystem::path& OldPath, boost::filesystem::path& FilePath)
{
	if(k3d::application().user_interface())
		return k3d::application().user_interface()->get_file_path(Type, Prompt, PromptOverwrite, OldPath, FilePath);

	return false;
}

} // namespace k3d


