#ifndef K3DSDK_MANIPULATORS_H
#define K3DSDK_MANIPULATORS_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares convenience functions and classes for working with interactive 3D manipulators
		\author Tim Shead (tshead@k-3d.com)
*/

#include "vectors.h"

// Forward declarations
class k3dICamera;

namespace k3d
{

/// Transform mouse coordinates into some other reference frame
const vector2 transform_mouse_coordinates(k3dICamera& Camera, const vector2 MouseCoords, double Left, double Right, double Top, double Bottom);
/// Transform mouse coordinates into some other reference frame with scaling
const vector2 transform_mouse_coordinates(k3dICamera& Camera, const vector2 MouseCoords, double Left, double Right, double Top, double Bottom, double scale);
/// Transform mouse coordinates to a normalized ray originating at the camera, within the camera's reference frame
void mouse_to_camera_ray(k3dICamera& Camera, const vector2 MouseCoords, vector3& RayDirection);
/// Transform mouse coordinates to a normalized ray originating at the camera, within the world reference frame
void mouse_to_world_ray(k3dICamera& Camera, const vector2 MouseCoords, vector3& RayOrigin, vector3& RayDirection);

} // namespace k3d

#endif // !K3DSDK_MANIPULATORS_H


