
/*
 * mixer.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MIXER_MIXER_C
#define MIXER_MIXER_C

#include <unistd.h>
#include <sys/soundcard.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <string.h>

#include "mixer.h"

bool Mixer::Open ()
{
   return ((mixer_fd = open (MIXER_DEVICE,O_RDWR)) != -1);
}

void Mixer::Close ()
{
   close (mixer_fd);
}

bool Mixer::HasChannel (int channel)
{
   int mask;
   if (ioctl (mixer_fd,SOUND_MIXER_READ_DEVMASK,&mask) == -1) return FALSE;
   return (mask & (1 << channel));
}

bool Mixer::IsStereo (int channel)
{
   int mask;
   if (ioctl (mixer_fd,SOUND_MIXER_READ_STEREODEVS,&mask) == -1) return FALSE;
   return (mask & (1 << channel));
}

int Mixer::GetVolume (int channel)
{
   int volume;
   if (ioctl (mixer_fd,MIXER_READ (channel),&volume) == -1) return FALSE;
   return volume;
}

void Mixer::SetVolume (int channel,int volume)
{
   int newvolume = volume;
   ioctl (mixer_fd,MIXER_WRITE (channel),&newvolume);
}

#endif
