#!/bin/sh
#
# Generate current download page with correct version plugged in.
#
VERSION=$1

VERS=`echo $VERSION | tr -d '.'`

cat >download.html <<EOF
<!doctype HTML public "-//W3O//DTD W3 HTML 4.0//EN">
<HTML>
<HEAD>
<link rev=made href=mailto:esr@snark.thyrsus.com>
<TITLE>Download the Jargon File</TITLE>
</HEAD>
<BODY>
<H1 ALIGN=CENTER>Access to the File</H1>

The Jargon File is  available for browsing <a href="html/">here</a>, or as a
<a href="jargon.html">single HTML file</a>.
<P>
You can download an installable HTML 
<a href="jargon-${VERSION}.tar.gz">tarball</a> from here.
<P>
You can download a <a href="jarg${VERS}.gz">flat-text version</a>, with
headwords and references bracketed by colons, from here.  Yes, the
filling/justification is badly done, with lots of rivers (makeinfo is
less good at this than the Emacs Lisp code used in older versions).
No, we don't care; we're trying to phase out this format.
<P>
You can also download a copy of the Jargon File <a href=jargsrc.tar.gz>
masters and the production tools</A> used to generate HTML and TeX versions.
<P>
Unfortunately, the Jargon File is far too big to email.  Requests that
we mail it will be ignored.  Also note that the Info version has been
phased out; it's an HTML world now.
<P>
In the future we hope to offer an SGML/XML version suitable for
serious database work.
<P>

<H1>Why There Are No diff Files</H1>

Many people have asked why I don't release diff files for new versions, so
people can avoid having to FTP or uucp-fetch the whole thing each time.  It's
because diffs tend to lose the actual semantic changes in a lot of noise
resulting from very low-level tweaks (typo fixes, re-justifications, etc.).
This bulks the diffs up to the point where I don't think they're enough smaller
than the File itself to justify the hassle costs of issuing or using them.<p>

<HR>
<ADDRESS>Eric S. Raymond <A HREF="mailto:esr@thyrsus.com">&lt;esr@snark.thyrsus.com&gt;</A></ADDRESS>
</BODY>
</HTML>
EOF