use strict;
use vars qw($VERSION %IRSSI);

use Irssi qw(command_bind signal_add);
$VERSION = '2.10';
%IRSSI = (
    authors	=> 'Juerd',
    contact	=> 'juerd@juerd.nl',
    name	=> 'Foo encryption',
    description	=> 'Rot $x encryption and decryption',
    license	=> 'Public Domain',
    url		=> 'http://juerd.nl/irssi/',
    changed	=> 'Tue Mar 19 11:00 CET 2002',
);

my $char1 = "\xC0-\xCF\xD2-\xD6\xD8-\xDD";
my $char2 = "\xE0-\xF6\xF8-\xFF";

sub sig_public {
    my ($server, $msg, $nick, $address, $target) = @_;
    if ($msg =~ s/^\cO(\cB+)\cO(\cB+)\cO//){
	my $rotABC = length $1;
	my $rot123 = length $2;
	$msg =~ tr/B-ZAb-za/A-Za-z/ for 1..$rotABC;
	$msg =~ tr/1-90/0-9/ for 1..$rot123;
	$msg =~ s{\cO\x1F\x1F([a-zA-Z])}<
	    my $char = $1;
	    eval qq{
	        \$char =~ tr/A-Z/$char1/;
	        \$char =~ tr/a-z/$char2/;
	    };
	    $char;
        >geo;
        my $pnick = $nick =~ m'^[#+!&]' ? $server->{nick} : $nick;
        $server->print($target||$nick, "\cC4<\cC\cB*$pnick\cC4>\cC $msg", MSGLEVEL_PUBLIC);
    }
}

sub sig_private {
    my ($server, $msg, $nick, $address, $target) = @_;
    if ($msg =~ s/^\cO(\cB+)\cO(\cB+)\cO//){
	my $rotABC = length $1;
	my $rot123 = length $2;
	$msg =~ tr/B-ZAb-za/A-Za-z/ for 1..$rotABC;
	$msg =~ tr/1-90/0-9/ for 1..$rot123;
	$msg =~ s{\cO\x1F\x1F([a-zA-Z])}<
	    my $char = $1;
	    eval qq{
	        \$char =~ tr/A-Z/$char1/;
	        \$char =~ tr/a-z/$char2/;
	    };
    	    $char;
        >geo;
        my $pnick = $address eq '*' ? $server->{nick} : $nick;
        $server->print($nick, "\cC4<\cC\cB$pnick\cC4>\cC $msg", MSGLEVEL_MSGS);
    }
}

command_bind rot => sub {
    my ($msg, $server, $window) = @_;
    my $rotABC = 1 + 2 * int(rand 13);
    my $rot123 = 1 + 2 * int(rand 4);
    $msg =~ s/([$char1$char2])/\cO\x1F\x1F$1/go;
    eval qq{
        \$msg =~ tr/$char1/A-Z/;
        \$msg =~ tr/$char2/a-z/;
    };
    $msg =~ tr/A-Za-z/B-ZAb-za/ for 1..$rotABC;
    $msg =~ tr/0-9/1-90/ for 1..$rot123;
    $msg = "\cO" . ("\cB" x $rotABC) . "\cO" . ("\cB" x $rot123) . "\cO$msg";
    $window->command("say $msg");
};

signal_add {
    'message private'     => \&sig_private,
    'message own_private' => \&sig_private,
    'message public'      => \&sig_public,
    'message own_public'  => \&sig_public,
};
