// --------------------------------------------------------------------
// Ipelet  for moving objekts in small steps,
// best used with shortcuts
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2007  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include "ipelib.h"

// --------------------------------------------------------------------

static const char *aboutText = "Written by Gunter Schenck";

class MoveIpelet : public Ipelet {
public:
  virtual int IpelibVersion() const { return IPELIB_VERSION; }
  virtual int NumFunctions() const { return 24; }
  virtual const char *Label() const { return "Move"; }
  virtual const char *SubLabel(int function) const;
  virtual void Run(int function, IpePage *page, IpeletHelper *helper);
  virtual const char *About() const { return aboutText; }
};

// --------------------------------------------------------------------

const char * const sublabel[] = {
  "right 1pt",
  "left 1pt",
  "up 1pt",
  "down 1pt",
  "right-up 1pt",
  "left-up 1pt",
  "right-down 1pt",
  "left-down 1pt",
  "right 0.1pt",
  "left 0.1pt",
  "up 0.1pt",
  "down 0.1pt",
  "right-up 0.1pt",
  "left-up 0.1pt",
  "right-down 0.1pt",
  "left-down 0.1pt",
  "right 10pt",
  "left 10pt",
  "up 10pt",
  "down 10pt",
  "right-up 10pt",
  "left-up 10pt",
  "right-down 10pt",
  "left-down 10pt"
 };

const char *MoveIpelet::SubLabel(int function) const
{
  return sublabel[function];
}

// --------------------------------------------------------------------

const double dpmm = 72.0 / 25.4;

// --------------------------------------------------------------------

void MoveIpelet::Run(int function, IpePage *page, IpeletHelper *helper)
{
  if (!page->HasSelection()) {
    helper->Message("Nothing selected");
    return;
  }

  IpeVector v;

  switch (function) {
// 1px
  case 0: //right
	v = IpeVector( 1, 0 );
    break;
  case 1: //left
	v = IpeVector( -1, 0 );
    break;
  case 2: //up
	v = IpeVector( 0, 1 );
    break;
  case 3: //down
	v = IpeVector( 0, -1 );
    break;
  case 4: // right-up 1pt
	v = IpeVector( 1, 1 );
    break;
  case 5: //left-up
	v = IpeVector( -1, 1 );
    break;
  case 6: //right-down
	v = IpeVector( 1, -1 );
    break;
  case 7: //left-down
	v = IpeVector( -1, -1 );
    break;
// 0.1px
  case 8: //right
	v = IpeVector( .1, 0 );
    break;
  case 9: //left
	v = IpeVector( -.1, 0 );
    break;
  case 10: //up
	v = IpeVector( 0, .1 );
    break;
  case 11: //down
	v = IpeVector( 0, -.1 );
    break;
  case 12: // right-up 1pt
	v = IpeVector( .1, .1 );
    break;
  case 13: //left-up
	v = IpeVector( -.1, .1 );
    break;
  case 14: //right-down
	v = IpeVector( .1, -.1 );
    break;
  case 15: //left-down
	v = IpeVector( -.1, -.1 );
    break;
// 10px
  case 16: //right
	v = IpeVector( 10, 0 );
    break;
  case 17: //left
	v = IpeVector( -10, 0 );
    break;
  case 18: //up
	v = IpeVector( 0, 10 );
    break;
  case 19: //down
	v = IpeVector( 0, -10 );
    break;
  case 20: // right-up 1pt
	v = IpeVector( 10, 10 );
    break;
  case 21: //left-up
	v = IpeVector( -10, 10 );
    break;
  case 22: //right-down
	v = IpeVector( 10, -10 );
    break;
  case 23: //left-down
	v = IpeVector( -10, -10 );
    break;
  default:
    return;
  }
  for (IpePage::iterator it = page->begin(); it != page->end(); ++it) {
    if (it->Select())
      it->Transform(IpeMatrix(v));
  }
}

// --------------------------------------------------------------------

IPELET_DECLARE Ipelet *NewIpelet()
{
  return new MoveIpelet;
}

// --------------------------------------------------------------------
