dnl
#! /bin/sh
# integrit - file integrity verification system
# Copyright (C) 2006 Ed L. Cashin
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# 
define(`myself', `test')dnl
define(`abort', `{ echo "myself: TEST FAILED: $1" 1>&2; rm -rf $testdir; exit 1; }')dnl
define(`try', `$2 || abort($1)')dnl
define(`integritcheck', `./integrit -C $testdir/test.conf -c -u > $testdir/test.out || status=$?; if test "$status" = "1"; then echo exit one indicates changes; true; else false; fi')

# NOTE: the file, "test", is generated from the file, "test.m4"

changequote([, ])dnl
scriptdir="`dirname $0`"

set -x
try([running integrit binary], [./integrit -V])
testdir=test-$$
try([creating test area], [$scriptdir/make-filetree $testdir])
try([creating config file], [$scriptdir/make-config $testdir])
try([integrit update], [./integrit -C $testdir/test.conf -u])
try([checking for current database], [test -f $testdir/curr.cdb])
try([installing current db], [mv $testdir/curr.cdb $testdir/known.cdb])
try([integrit check and update], integritcheck)
try([make sure update created new database], [test -f $testdir/curr.cdb])
try([check for recognition that curr.cdb has changed],dnl
 [grep "changed: .*curr\.cdb" $testdir/test.out])
try([check for recognition that known.cdb is new],dnl
 [grep "new: .*known\.cdb" $testdir/test.out])
dnl
dnl
dnl now modify a file
modfile=$testdir/data/two/three
modfile_esc="$testdir\/data\/two\/three"
try([modify a data file], [echo new contents > $modfile])
try([install the database], [mv $testdir/curr.cdb $testdir/known.cdb])
try([integrit check and update], integritcheck)
try([make sure update created new database], [test -f $testdir/curr.cdb])
try([make sure output acknowledged curr.cdb has changed],dnl
 [grep "changed: .*curr\.cdb" $testdir/test.out])
try([make sure output acknowledged curr.cdb has changed],dnl
 [grep "changed: .*$modfile_esc .*s[(]" $testdir/test.out])

rm -rf $testdir

set +x
printf "\neverything's fine.\n"
