#!/usr/bin/perl

### NOTE: THE var $HomeDir must NOT conatin a trailing /

# This script will export a pine address book into a mysql database
# Specially designed for use with IMP http://www.horde.org/imp
# This script requires arguments: <action - import/export> <user@domain> <home dir> <address-file name>
# first lets define some vars
use DBI;
# you should not need to change these
$Action = $ARGV[0];
$User = $ARGV[1];
$HomeDir = $ARGV[2]; 
$AddressFile = $ARGV[3];
# Check for the arguments
if ($Action eq "" || $User eq "" || $HomeDir eq "" || $AddressFile eq "") {
	die "you did not give all the arguments.";
}
# Adjust these vars.
####### Define Main Vars ##########
$Machine  =  "db.domain.com";
$UserName  =  "impuser";
$PassWord  =  "imppassword";
$DataBase = "impdb";
$TableName = "imp_addr";
###################################
if ($Action eq "import") {
	&ImportToMysql;
} elsif ($Action eq "export") {
	&ExportToAddr;
}
sub ExportToAddr {
open(PADDR, ">$HomeDir/$AddressFile") || die "Can't write $HomeDir/$AddressFile.";
# time to connect to the database
   $dbh = DBI->connect("DBI:mysql:$DataBase:$Machine:3306",$UserName,$PassWord) or die "Can't connect to database: $dbh->errstr";    
   $Statement = "select * from $TableName where user='$User'";
   $sth = $dbh->prepare($Statement) or &Error("Can't execute the query: $dbh->errstr");
   $rv = $sth->execute or  &Error("Can't execute the query: $sth->errstr");
   while(@Paddr = $sth->fetchrow_array) {
        print PADDR "$Paddr[2]\t$Paddr[3]\t$Paddr[1]\t\t\n";
   }
close PADDR;
}
sub ImportToMysql {
# Next lets open this file and get the addresses
# then dump them into the database
if (!(-e "$HomeDir/$AddressFile")) { # checks to make sure we can find that users address book
   die "The file $HomeDir/$AddressFile does not exist.";
}
# lets open the file and start reading
open(ADDR, "<$HomeDir/$AddressFile") || die "Can't open $HomeDir/$AddressFile.";
# time to connect to the database
$dbh = DBI->connect("DBI:mysql:$DataBase:$Machine:3306",$UserName,$PassWord) or die "Can't connect to database: $dbh->errstr"; 
while (<ADDR>) {
		$Line = $_;
		chomp($Line);
		$Chk = $Line;
		$Chk =~  s/ //g; # cut out spaces
        	$Chk =~  s/\t//g; # cut out tabs
		if ($Chk ne "") { # now if the line is empty do nothing, if it isnt lets put the data in the addressbook
		  	($Nick, $FullName, $Addr, $Fcc, $Comment) = split(/\t/, $Line); 
			$Query = "insert into $TableName(user, address, nickname, fullname) values('$User', '$Addr', '$Nick', '$FullName')";
			$sth = $dbh->prepare($Query) or die "Can't execute the query: $dbh->errstr";
			$rv = $sth->execute or die "Can't execute the query: $dbh->errstr";
    		}
}
close ADDR; # closes the file
# disconnect from database
}
