/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Method for outputing messages
//
#ifndef IOUTPUTCHANNEL_H
#define IOUTPUTCHANNEL_H


#include <vtkObjectBase.h>


#include "iconsole.h"
#include "istring.h"

#include <vtkSetGet.h>

class iShell;


class iOutputChannel : public vtkObjectBase
{
	
	friend class iConsole;
	friend class iShell;

public:
	
	vtkTypeMacro(iOutputChannel,vtkObjectBase);
	static void SetInstance(iOutputChannel *c);

	//
	//  Use this function to report errors and display text
	//
	void Display(iConsole::MessageType type, const iString &message, const char *file, int line);

	//
	//  Log functions
	//
	void NotifyIfLogCreated();
	void BlockLogging(bool s);

protected:
	
	iOutputChannel(iShell *s);
	virtual ~iOutputChannel();

	virtual void DisplayBody(iConsole::MessageType type, const iString &message, const char *file, int line);

	iString FormPlainTextMessage(iConsole::MessageType type, const iString &message, const char *file, int line);

private:

	static iOutputChannel* GetInstance();

	static iOutputChannel* mInstance;
	iString mLogFileName;
	bool mInDisplay, mLogCreated, mInUpdateLog, mLoggingBlocked;
	void UpdateLog(const iString &message, const char* file, int line);
};

#endif  // IOUTPUTCHANNEL_H
