/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  A vtkPlane with a glass plane representation
//
#ifndef ICLIPPLANE_H
#define ICLIPPLANE_H


#include <vtkPlane.h>


#include "ipointermacro.h"

#include <vtkSetGet.h>

class iActor;
class iTransform;
class iViewModule;


class iClipPlane : public vtkPlane
{

	IPOINTER_AS_PART(ViewModule);

public:

	vtkTypeMacro(iClipPlane,vtkPlane);
	static iClipPlane* New(iViewModule *vm = 0);

	void SetDirection(const float *dir);
	inline void GetDirection(float *dir) const { for(int i=0; i<3; i++) dir[i] = mClipPlaneDirection[i]; }
	inline const float* GetDirection() const { return mClipPlaneDirection; }

	void SetDistance(float d);
	inline float GetDistance() const { return mDistance; }

	void SetGlassPlaneVisible(bool s);
	bool GetGlassPlaneVisible() const;

protected:

	virtual ~iClipPlane();

private:

	iClipPlane(iViewModule *vm);

	//
	//  Actors displayed by this class
	//
	iActor *mClipPlaneActor;
	iTransform *mTransform;
	float mDistance, mClipPlaneDirection[3], mClipPlaneActorNormal[3];
};

#endif // ICLIPPLANE_H

