/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  DataSubject(s) for basic IFrITe DataType(s)
//
#ifndef IBASICDATASUBJECTS_H
#define IBASICDATASUBJECTS_H


#include "ifielddatasubject.h"
#include "iparticledatasubject.h"


class iUniformScalarsFileLoader;


class iUniformScalarsDataSubject : public iFieldDataSubject
{

	friend class iDataReader;

public:

	vtkTypeMacro(iUniformScalarsDataSubject,iFieldDataSubject);

	//
	//  Inherited members
	//
	IFIELDDATASUBJECT_DECLARE_INHERITED_KEYS;
	IFIELDDATASUBJECT_DECLARE_INHERITED_MEMBERS;

	static const iObjectKey& KeyVariableCalculatorFunction();
	static const iObjectKey& KeyVariableCalculatorOutput();

protected:

	virtual void FieldDataSubjectPackStateBody(iString &) const;
	virtual void FieldDataSubjectUnPackStateBody(const iString &);

private:

	iUniformScalarsDataSubject(iUniformScalarsFileLoader *fl); // should not be created except by a Reader

	iUniformScalarsFileLoader *mConcreteLoader;
};


class iUniformVectorsDataSubject : public iFieldDataSubject
{

	friend class iDataReader;

public:

	vtkTypeMacro(iUniformVectorsDataSubject,iFieldDataSubject);

	//
	//  Inherited members
	//
	IFIELDDATASUBJECT_DECLARE_INHERITED_KEYS;
	IFIELDDATASUBJECT_DECLARE_INHERITED_MEMBERS;

private:

	iUniformVectorsDataSubject(iFieldFileLoader *fl); // should not be created except by a Reader
};


class iUniformTensorsDataSubject : public iFieldDataSubject
{

	friend class iDataReader;

public:

	vtkTypeMacro(iUniformTensorsDataSubject,iFieldDataSubject);

	//
	//  Inherited members
	//
	IFIELDDATASUBJECT_DECLARE_INHERITED_KEYS;
	IFIELDDATASUBJECT_DECLARE_INHERITED_MEMBERS;

private:

	iUniformTensorsDataSubject(iFieldFileLoader *fl); // should not be created except by a Reader
};


class iBasicParticlesDataSubject : public iParticleDataSubject
{

	friend class iDataReader;

public:

	vtkTypeMacro(iBasicParticlesDataSubject,iParticleDataSubject);

	//
	//  Inherited members
	//
	IPARTICLEDATASUBJECT_DECLARE_INHERITED_KEYS;
	IPARTICLEDATASUBJECT_DECLARE_INHERITED_MEMBERS;

private:

	iBasicParticlesDataSubject(iParticleFileLoader *fl); // should not be created except by a Reader
};

#endif

