/* utility.h
 * - Utility Function Headers
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */


#ifndef __ICECAST_UTILITY_H
#define __ICECAST_UTILITY_H

char *clean_string_from_spaces(char *string);
char *clean_string_from_leading_spaces(char *string);
void clean_away_source(source_t *source);
void assign_old_listeners(source_t *ser);
int map_id_to_source_socket(char *idstring);
source_t *source_with_id(int id);
int password_match(const char *crypted, const char *uncrypted);
int check_pass(int sockfd, char *pass, int *counter, char *string);
void print_connection (void *data, void *param);
void print_source(void *data, void *param);
void print_source_verbose (void *data, void *param);
void print_clients(void *data, void *param);
void print_client(void *data, void *param);
void print_directory(void *data, void *param);
void print_admin(void *data, void *param);
directory_server_t *create_directory();
int field_ok (char *xac, char *field);
int find_frame_ofs(source_t *source);
void kick_connection_not_me (void *conarg, void *reasonarg);
void kick_connection(void *conarg, void *reasonarg);
void kick_everything();
void kick_if_match (char *pattern);
void kick_not_connected (connection_t *con, char *reason);
void kick_silently (connection_t *con);
void close_directory(void *data, void *param);
connection_t *get_admin_with_id(int id);
void close_connection(void *data, void *param);
void close_socket(sock_t sock);
source_t *source_with_client(connection_t *con);
void threaded_detach ();
int server_detach();
connection_t *find_id (int id);
connection_t *find_client_with_id (int id);
connection_t *find_con_with_host_and_udpport (const char *hostptr, const int portnr);
connection_t *find_con_with_host (const struct sockaddr_in *sin);
connection_t *find_source_with_id (int id);
connection_t *find_source_with_mount (char *mount);
void kill_threads ();
unsigned long int new_id ();
void do_if_match_all (char *pattern, avl_node_func func, void *buf, int destructive);
void do_if_match_tree (avl_tree *tree, char *pattern, avl_node_func func, void *buf, int destructive);
void do_if_match_tree_destructive (avl_tree *tree, char *pattern, avl_node_func func, void *buf);
time_t tree_time(avl_tree *tree);
void write_icecast_header ();
void print_startup_server_info ();
void sanity_check ();
unsigned long int transfer_average (unsigned long int bytes, unsigned long int connections);
char *connect_average (unsigned long int seconds, unsigned long int connections, char *buf);
void clear_source_stats (void *data, void *param);
void clear_client_stats (void *data, void *param);
void clear_admin_stats (void *data, void *param);
int hostname_local (char *name);
void build_request (char *line, request_t *req);
int mount_exists (char *mount);
void zero_request (request_t *req);
void generate_request (char *line, request_t *req);
void generate_http_request (char *line, request_t *req);
void init_thread_tree (int line, char *file);
char *next_mount_point();
connection_t *get_pending_mount (char *mount);
void pending_connection (connection_t *con);
int pending_source_signoff (connection_t *con);
int hosteq (connection_t *con, connection_t *con2);
int hostmatch (const connection_t *con, const char *pattern);
int open_for_reading (const char *filename);
int open_for_writing (const char *filename);
int open_for_append (const char *filename);
char *get_icecast_file (const char *filename, filetype_t type, int flags);
char *get_template (const char *filename);
char *get_log_file (const char *filename);
void stat_add_write (statistics_t *stat, int len);
void stat_add_read (statistics_t *stat, int len);
char * type_of_str (contype_t type, char *buf);
void zero_song_info (songinfo_t *si);
void my_sleep (int microseconds);
void show_runtime_configuration ();
int is_recoverable (int error);
void set_run_path (char **argv);
void zero_audiocast (audiocast_t *au);
void dispose_audiocast (audiocast_t *au);
int is_valid_http_request (request_t *req);

#ifndef _WIN32
#define min(x,y) ((x)<(y)?(x):(y))
#endif

#endif


