% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidingTOC.r
\name{hidingTOC}
\alias{hidingTOC}
\title{Moving and Hiding Table of Contents}
\usage{
hidingTOC(buttonLabel = "Contents", levels = 3, tocSide = c("right",
  "left"), buttonSide = c("right", "left"), posCollapse = c("margin",
  "top", "bottom"), hidden = FALSE)
}
\arguments{
\item{buttonLabel}{the text on the button that hides and unhides the
table of contents. Defaults to \code{Contents}.}

\item{levels}{the max depth of the table of contents that it is desired to
have control over the display of.  (defaults to 3)}

\item{tocSide}{which side of the page should the table of contents be placed
on. Can be either \code{'right'} or \code{'left'}. Defaults to
\code{'right'}}

\item{buttonSide}{which side of the page should the button that hides the TOC
be placed on. Can be either \code{'right'} or \code{'left'}. Defaults to
\code{'right'}}

\item{posCollapse}{if \code{'margin'} then display the depth select buttons
vertically along the side of the page choosen by \code{buttonSide}. If
\code{'top'} then display the depth select buttons horizontally under the
button that hides the TOC. Defaults to \code{'margin'}. \code{'bottom'} is
currently unimplemented.}

\item{hidden}{Logical should the table of contents be hidden at page load
Defaults to \code{FALSE}}
}
\value{
a HTML formated text string to be inserted into an markdown document
}
\description{
Moving and hiding table of contents for Rmd HTML documents
}
\details{
\code{hidingTOC} creates a table of contents in a Rmd document that
can be hidden at the press of a button. It also generate buttons that allow
the hiding or unhiding of the diffrent level depths of the table of contents.
}
\examples{
\dontrun{
hidingTOC()
}
}
\author{
Thomas Dupont
}
