/*  -*-objc-*-
 *  Workspace.m: Implementation of the GWorkspace (WorkspaceMethods) Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "GWorkspace.h"
#include "FileOperation.h"
#include "Watchers/Watcher.h"
#include "Dialogs/Dialogs.h"
#include "Inspectors/InspectorsWin.h"
#include "Processes/Processes.h"
#include "Finder/Finder.h"
#include "Preferences/PreferencesWin.h"
#include "Fiend/Fiend.h"
#include "Viewers/ViewersWindow.h"
#include "Desktop/DesktopWindow.h"
#include "Desktop/DesktopView.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation GWorkspace (WorkspaceMethods)

- (BOOL)performFileOperation:(NSString *)operation 
                      source:(NSString *)source 
                 destination:(NSString *)destination 
                       files:(NSArray *)files 
                         tag:(int *)tag
{
	FileOperation *ops;
	int i;
	
	if (([self verifyFileAtPath: source] == NO) 
														|| ([self verifyFileAtPath: source] == NO)) {
		return NO;
	}
	
	for (i = 0; i < [files count]; i++) {
		NSString *fname = [files objectAtIndex: i];
		NSString *fullPath = [source stringByAppendingPathComponent: fname];

		if ([self verifyFileAtPath: fullPath] == NO) {
			return NO;
		}
	}
		
  ops = [[FileOperation alloc] initWithOperation: operation 
              source: source destination: destination files: files];
	[bgdOpsArr addObject: ops]; 
  RELEASE (ops);
                                                       
	return YES;           					  		
}

- (BOOL)selectFile:(NSString *)fullPath
											inFileViewerRootedAtPath:(NSString *)rootFullpath
{
	NSArray *paths;
	int l1, l2;
	BOOL isdirRoot, isdirFpath;
	BOOL newViewer = YES;

	if ([fm fileExistsAtPath: fullPath isDirectory: &isdirFpath] == NO) {
		return NO;
	}
	
	if (!rootFullpath || ([rootFullpath length] == 0)) {
		newViewer = NO;
	} else if (([fm fileExistsAtPath: rootFullpath isDirectory: &isdirRoot] && isdirRoot) == NO) {
		return NO;
	}
	
	l1 = [rootFullpath length];
	l2 = [fullPath length];  

	if ((l1 > l2) || ((l1 == l2) && (isdirFpath == NO))) {
		return NO;
	}

	if (newViewer == YES) {
		if ([[fullPath substringToIndex: l1] isEqualToString: rootFullpath] == NO) {
			return NO;
		}
	}
	
	paths = [NSArray arrayWithObject: fullPath];
	[self setSelectedPaths: paths];
	
	if (newViewer == YES) {
		ViewersWindow *viewer;
		NSString *app, *type;
	
		[ws getInfoForFile: rootFullpath application: &app type: &type];
		viewer = [self newViewerAtPath: rootFullpath canViewApps: (type == NSApplicationFileType)];
		[viewer setViewerSelection: paths];
		[viewer orderFrontRegardless];
		// [GSCurrentContext() flush];
	} else {
		[rootViewer setViewerSelection: paths];
	}
				
	return YES;
}

- (BOOL)openFile:(NSString *)fullPath
{
	NSImage *image = [ws iconForFile: fullPath];
	NSPoint p = [currentViewer locationOfIconForPath: fullPath];
	NSView *aview = [currentViewer viewer];
	
	return [self openFile: fullPath fromImage: image at: p inView: aview];
}

- (BOOL)openFile:(NSString *)fullPath 
			 fromImage:(NSImage *)anImage 
			  			at:(NSPoint)point 
					inView:(NSView *)aView
{
	NSString *ext = [fullPath pathExtension];
	NSString *appName = [ws getBestAppInRole: nil forExtension: ext];
	id fiendLeaf;
	id app;
	NSPoint toPoint;
	BOOL dissolved;
	
#define RETURN_OPEN \
return [ws openFile: fullPath withApplication: appName]
	
	if (appName == nil) {
		appName = defEditor;
	}		

	if ((fiend == nil) || ([[fiend myWin] isVisible] == NO)) RETURN_OPEN;
	
	fiendLeaf = [fiend fiendLeafOfType: NSApplicationFileType withName: appName];
	if (fiendLeaf == nil) RETURN_OPEN;
	
	app = [self connectApplication: appName];
	if (app == nil) {
		dissolved = [fiend dissolveLeaf: fiendLeaf];
	}
	
	if (point.x <= 0 || point.y <= 0) RETURN_OPEN;

	toPoint = [fiend positionOfLeaf: fiendLeaf];
	if (toPoint.x <= 0 || toPoint.y <= 0) RETURN_OPEN;
			
	point = [[aView window] convertBaseToScreen: point];
	[self slideImage: anImage from: point to: toPoint];
	
	RETURN_OPEN;
}
					
- (void)slideImage:(NSImage *)image 
							from:(NSPoint)fromPoint 
								to:(NSPoint)toPoint
{
	[[NSWorkspace sharedWorkspace] slideImage: image from: fromPoint to: toPoint];
}

- (void)noteFileSystemChanged
{

}

- (void)noteFileSystemChanged:(NSString *)path
{

}

@end





