 /*  -*-objc-*-
 *  Processes.m: Implementation of the Processes Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "Processes.h"
#include "ProcsView.h"
#include "FileOperation.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation Processes

- (void)dealloc
{
	[[ws notificationCenter] removeObserver: self]; 
  RELEASE (appsMatrix);
  RELEASE (procsMatrix);
  RELEASE (procsView);
  RELEASE (applicationView);
  RELEASE (noBackgroundView);  
  RELEASE (bgndViews);
  RELEASE (pWin);
  [super dealloc];
}

- (id)init
{
	self = [super init];
  	if (self) {
			id cell, label;
	    unsigned int style = NSTitledWindowMask | NSClosableWindowMask				
							                                      | NSResizableWindowMask;
      ws = [NSWorkspace sharedWorkspace];
      
	    pWin = [[NSPanel alloc] initWithContentRect: NSZeroRect
						    styleMask: style backing: NSBackingStoreBuffered defer: YES];
      if ([pWin setFrameUsingName: @"Processes"] == NO) {
        [pWin setFrame: NSMakeRect(100, 100, 384, 265) display: NO];
      }            
      [pWin setMaxSize: NSMakeSize(384, 2000)];
      [pWin setMinSize: NSMakeSize(384, 265)];
      [pWin setTitle: NSLocalizedString(@"Processes",@"")];
      [pWin setReleasedWhenClosed: NO]; 
      [pWin setDelegate: self];

      procsView = [[ProcsView alloc] initWithFrame: NSMakeRect(0, 0, 384, 265)];
      popUp = [procsView popUp];
      [popUp setTarget: self];
      [popUp setAction: @selector(activateView:)];  
      scrollView = [procsView scrollView];
      controlsView = [procsView controlsView];
      [pWin setContentView: procsView]; 

      cell = AUTORELEASE([NSButtonCell new]);
      [cell setButtonType: NSPushOnPushOffButton];
      [cell setBordered: NO];
      [cell setFont: [NSFont systemFontOfSize: 12]];
      [cell setAlignment: NSLeftTextAlignment]; 

      appsMatrix = [[NSMatrix alloc] initWithFrame: NSZeroRect
			      	        mode: NSRadioModeMatrix prototype: cell
		       							            numberOfRows: 0 numberOfColumns: 0];

      [appsMatrix setIntercellSpacing: NSZeroSize];
      [appsMatrix setCellSize: NSMakeSize(343, 16)];
      [appsMatrix sizeToCells];
      [appsMatrix setTarget: self];		
      [appsMatrix setAction: @selector(setApplicationInfo:)];		

      procsMatrix = [[NSMatrix alloc] initWithFrame: NSZeroRect
			      	        mode: NSRadioModeMatrix prototype: cell
		       							            numberOfRows: 0 numberOfColumns: 0];

      [procsMatrix setIntercellSpacing: NSZeroSize];
      [procsMatrix setCellSize: NSMakeSize(343, 16)];
      [procsMatrix sizeToCells];
      [procsMatrix setTarget: self];		
      [procsMatrix setAction: @selector(setFileOperationInfo:)];	
      
      bgndViews = [[NSMutableArray alloc] initWithCapacity: 1];
      noBackgroundView = [[NSView alloc] initWithFrame: NSMakeRect(0, 0, 366, 150)];      
      label = [[NSTextField alloc] initWithFrame: NSMakeRect(10, 75, 346, 25)];	
      [label setFont: [NSFont systemFontOfSize: 18]];
      [label setAlignment: NSCenterTextAlignment];
	    [label setBackgroundColor: [NSColor windowBackgroundColor]];
	    [label setTextColor: [NSColor grayColor]];	
	    [label setBezeled: NO];
	    [label setEditable: NO];
	    [label setSelectable: NO];
      [label setStringValue: NSLocalizedString(@"No Background Process", @"")];
      [noBackgroundView addSubview: label]; 
      AUTORELEASE (label);      
      [bgndViews addObject: noBackgroundView];

      applicationView = [[NSView alloc] initWithFrame: NSMakeRect(0, 0, 366, 150)];
      backgroundView = noBackgroundView;
      
      [[ws notificationCenter] addObserver: self 
                			    selector: @selector(applicationLaunched:) 
                					    name: NSWorkspaceDidLaunchApplicationNotification
                				    object: nil];

      [[ws notificationCenter] addObserver: self 
                			    selector: @selector(applicationTerminated:) 
                					    name: NSWorkspaceDidTerminateApplicationNotification
                				    object: nil];
    }
  
  return self;
}

- (void)activateView:(id)sender
{
  NSString *title = [popUp titleOfSelectedItem];	
  if ([title isEqualToString: NSLocalizedString(@"Applications", @"")]) {
    [self activateApplications];
  } else {
    [self activateBackground];  
  }  
}

- (void)activateApplications
{
  id view, subviews;
  
  view = [scrollView documentView];
  if (view != nil) {
    [view removeFromSuperview];
  }    
  [scrollView setDocumentView: appsMatrix];

  subviews = [controlsView subviews];
  if ([subviews count] != 0) {
    view = [subviews objectAtIndex: 0];
    [view removeFromSuperview];
  }
  [controlsView addSubview: applicationView];

  [self setApplicationInfo: appsMatrix];    
  [pWin orderFront: nil];
}

- (void)activateBackground
{
  id view, subviews;
  
  view = [scrollView documentView];
  if (view != nil) {
    [view removeFromSuperview];
  }    
  [scrollView setDocumentView: procsMatrix];

  subviews = [controlsView subviews];
  if ([subviews count] != 0) {
    view = [subviews objectAtIndex: 0];
    [view removeFromSuperview];
  }
  [controlsView addSubview: backgroundView];

  [pWin orderFront: nil];
}

- (void)addAlertsFromFileOperation:(id)ops
{
  int index;
  id cell;
  
  [bgndViews addObject: [(FileOperation *)ops taskAlerts]];
  backgroundView = [bgndViews objectAtIndex: [bgndViews count] - 1];
  
  [procsMatrix addRow];
  index = [[procsMatrix cells] count] - 1;
  cell = [procsMatrix cellAtRow: index column: 0];
  [cell setTitle: [(FileOperation *)ops myLabel]];

  [procsMatrix sizeToCells];  
  [procsMatrix selectCellAtRow: [[procsMatrix cells] count] - 1 column: 0];
  
  [self activateBackgroundsView];
}

- (void)removeAlertsOfFileOperation:(id)ops
{
  NSArray *cells;  
  id cell;
  NSString *labelstr;
  int i;

  labelstr = [(FileOperation *)ops myLabel];
  
  cells = [procsMatrix cells];
  
  for (i = 0; i < [cells count]; i++) {
    cell = [procsMatrix cellAtRow: i column: 0];
    if ([[cell title] isEqualToString: labelstr]) {
      [procsMatrix removeRow: i];
      break;
    }
  }
  [procsMatrix sizeToCells];

  [bgndViews removeObject: [(FileOperation *)ops taskAlerts]];
  backgroundView = [bgndViews objectAtIndex: [bgndViews count] - 1];
  [self activateBackgroundsView];
}
    
- (void)setFileOperationInfo:(id)sender
{
  int index = [sender selectedRow];
  if (index != -1) {
    index++;
    if ([bgndViews count] > index) {
      backgroundView = [bgndViews objectAtIndex: index];
      [self activateBackgroundsView];
    }
  }
}

- (void)setApplicationInfo:(id)sender
{
//  id theApp;
  NSString *appName, *appPath, *appStatus;
  NSArray *subviews;
  NSButton *appButt, *killButt;
  NSImage *image;
  id cell, label;
  NSString *strtmp;
  int i;
  
  subviews = [applicationView subviews];
  if ([subviews count] != 0) {
    for (i = 0; i < [subviews count]; i++) {
      [[subviews objectAtIndex: i] removeFromSuperview];  
    }
  }

  cell = [sender selectedCell];
  if (cell == nil) {
    [applicationView setNeedsDisplay: YES];
    return;
  }

  appName = [NSString stringWithString: [cell title]];
//  theApp = nil; 
  appStatus = @" ";
/*  
  NS_DURING
    {
      theApp = [NSConnection rootProxyForConnectionWithRegisteredName: appName host: @""];
    }
  NS_HANDLER
    {
      theApp = nil;
    }
  NS_ENDHANDLER

  if (theApp != nil) {
    if ([theApp isRunning]) {
      appStatus = @"running";
    } else {
      appStatus = @"stopped";
    }
  }
*/
  
  appPath = [ws fullPathForApplication: appName];
  if (appPath == nil) {
    appName = [appName stringByAppendingPathExtension: @"debug"];
    appPath = [ws fullPathForApplication: appName]; 
  }
  
  appButt = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect(0, 84, 48, 48)]);
	[appButt setButtonType: NSMomentaryLight];
  [appButt setBordered: NO];
	[appButt setImagePosition: NSImageOnly];  
  image = [ws iconForFile: appPath];
  [appButt setImage: image];	  
  [applicationView addSubview: appButt];

	label = AUTORELEASE([[NSTextField alloc] initWithFrame: NSMakeRect(55, 95, 230, 25)]);	
	[label setFont: [NSFont systemFontOfSize: 18]];
	[label setAlignment: NSLeftTextAlignment];
	[label setBackgroundColor: [NSColor windowBackgroundColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];
  [label setStringValue: [appName stringByDeletingPathExtension]];
	[applicationView addSubview: label]; 

	label = AUTORELEASE([[NSTextField alloc] initWithFrame: NSMakeRect(8, 43, 350, 20)]);	
	[label setFont: [NSFont systemFontOfSize: 12]];
	[label setAlignment: NSLeftTextAlignment];
	[label setBackgroundColor: [NSColor windowBackgroundColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];  
  strtmp = pathFittingInContainer(label, appPath, 30);
  strtmp = [NSString stringWithFormat: @"%@%@", NSLocalizedString(@"Path: ", @""), strtmp];
  [label setStringValue: strtmp];
	[applicationView addSubview: label]; 

	label = AUTORELEASE([[NSTextField alloc] initWithFrame: NSMakeRect(8, 18, 100, 20)]);	
	[label setFont: [NSFont systemFontOfSize: 12]];
	[label setAlignment: NSLeftTextAlignment];
	[label setBackgroundColor: [NSColor windowBackgroundColor]];
	[label setBezeled: NO];
	[label setEditable: NO];
	[label setSelectable: NO];  
  [label setStringValue: [NSString stringWithFormat: @"%@%@", NSLocalizedString(@"Status: ", @""), appStatus]];
	[applicationView addSubview: label]; 

  appName = [appName stringByDeletingPathExtension];
  killButt = AUTORELEASE([[NSButton alloc] initWithFrame: NSMakeRect(300, 75, 64, 64)]);
	[killButt setButtonType: NSMomentaryLight];
	[killButt setImagePosition: NSImageOverlaps]; 
	[killButt setTitle: NSLocalizedString(@"Kill", @"")]; 
  image = [NSImage imageNamed: @"Kill.tiff"];
  [killButt setImage: image];	  
  [killButt setTarget: self];		
  [killButt setAction: @selector(killApplication:)];		
  [applicationView addSubview: killButt];
  
	if ([pWin isVisible] == YES) {
  	[applicationView setNeedsDisplay: YES];  
	}
}

- (void)killApplication:(id)sender
{
/*  NSString *appName;
  id theApp;
  int result;
  
  appName = [[appsMatrix selectedCell] title];

  NS_DURING
    {
      theApp = [NSConnection rootProxyForConnectionWithRegisteredName: appName host: @""];
    }
  NS_HANDLER
    {
      theApp = nil;
    }
  NS_ENDHANDLER

  if (theApp != nil) {    
    result = NSRunAlertPanel(@"GWorkspace", 
				[NSString stringWithFormat: @"Do you really want to kill %@?", appName], 
                          @"Kill", @"Cancel", NULL);		
    if (result == NSAlertDefaultReturn) {    
      [theApp terminate];
    }
  }
*/
}

- (void)applicationLaunched:(NSNotification *)aNotification
{
  NSDictionary *userinfo;
  NSString *appName;  
  id cell;
  int index;
    
  userinfo = [aNotification userInfo];
  appName = [userinfo objectForKey: @"NSApplicationName"];

  [appsMatrix addRow];
  index = [[appsMatrix cells] count] - 1;
  cell = [appsMatrix cellAtRow: index column: 0];
  [cell setTitle: appName];

  [appsMatrix sizeToCells]; 
	if ([pWin isVisible] == YES) { 	
  	[appsMatrix selectCellAtRow: [[appsMatrix cells] count] - 1 column: 0];
  }
	
	[self setApplicationInfo: appsMatrix];
	
	if ([pWin isVisible] == YES) { 	
  	[procsView setNeedsDisplay: YES];  
	}
}

- (void)applicationTerminated:(NSNotification *)aNotification
{
  NSDictionary *userinfo;
  NSString *appName;
  NSArray *cells;  
  id cell;
  int i;
    
  userinfo = [aNotification userInfo];
  appName = [userinfo objectForKey: @"NSApplicationName"];

  cells = [appsMatrix cells];
  
  for (i = 0; i < [cells count]; i++) {
    cell = [appsMatrix cellAtRow: i column: 0];
    if ([[cell title] isEqualToString: appName]) {
      [appsMatrix removeRow: i];
      break;
    }
  }

  [appsMatrix sizeToCells];
  [self setApplicationInfo: appsMatrix];      
  [procsView setNeedsDisplay: YES]; 
}

- (BOOL)windowShouldClose:(id)sender
{
  [self updateDefaults];
	return YES;
}

- (void)activateApplicationsView
{
  [popUp selectItemWithTitle: NSLocalizedString(@"Applications", @"")];
  [self activateView: popUp]; 
}

- (void)activateBackgroundsView
{
  [popUp selectItemWithTitle: NSLocalizedString(@"Background", @"")];
  [self activateView: popUp]; 
}

- (void)updateDefaults
{
  [pWin saveFrameUsingName: @"Processes"];
}

- (NSWindow *)myWin
{
  return pWin;
}

- (id)popUp
{
  return popUp;
}

@end
