 /*
 *  Processes.h: Interface and declarations for the Processes Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef PROCESSES_H
#define PROCESSES_H

#import <Foundation/NSObject.h>

@class NSWindow;
@class NSView;
@class NSMatrix;
@class NSMutableArray;
@class NSNotification;
@class ProcsView;
@class NSWorkspace;

@interface Processes : NSObject 
{
  NSPanel *pWin;
  ProcsView *procsView;
  NSMatrix *appsMatrix, *procsMatrix; 
  NSView *applicationView, *backgroundView, *noBackgroundView;
  NSMutableArray *bgndViews;
  id popUp, scrollView, controlsView; 
  NSWorkspace *ws;
}

- (void)activateView:(id)sender;

- (void)activateApplications;

- (void)activateBackground;

- (void)addAlertsFromFileOperation:(id)ops;

- (void)removeAlertsOfFileOperation:(id)ops;

- (void)setFileOperationInfo:(id)sender;

- (void)setApplicationInfo:(id)sender;

- (void)applicationLaunched:(NSNotification *)aNotification;

- (void)applicationTerminated:(NSNotification *)aNotification;

- (void)activateApplicationsView;

- (void)activateBackgroundsView;

- (void)updateDefaults;

- (NSWindow *)myWin;

- (id)popUp;

@end

#endif // PROCESSES_H

